/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.tools.image.BrokenImageException;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageLoader;
import VASSAL.tools.image.ImageTypeConverter;
import VASSAL.tools.image.JPEGDecoder;
import VASSAL.tools.image.PNGChunkSkipInputStream;
import VASSAL.tools.image.PNGDecoder;
import VASSAL.tools.image.UnrecognizedImageTypeException;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.RereadableInputStream;
import VASSAL.tools.lang.Reference;
import java.awt.Dimension;
import java.awt.color.CMMException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageIOImageLoader
implements ImageLoader {
    protected final ImageTypeConverter tconv;
    protected static final boolean iTXtBug;
    protected static final Set<Integer> skip_iTXt;
    protected static final boolean YCbCrBug;
    protected static Wrapper<BufferedImage> readImage;
    protected static Wrapper<Dimension> readSize;

    public ImageIOImageLoader(ImageTypeConverter imageTypeConverter) {
        this.tconv = imageTypeConverter;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BufferedImage load(String var1_1, InputStream var2_2, int var3_3, int var4_4, boolean var5_5) throws ImageIOException {
        block28: {
            block29: {
                block30: {
                    var6_6 = false;
                    var7_7 = 0;
                    var8_8 = false;
                    var9_9 = null;
                    var10_10 = null;
                    try {
                        var10_10 = new RereadableInputStream(var2_2);
                        var10_10.mark(512);
                        var11_11 = new DataInputStream(var10_10);
                        if (PNGDecoder.decodeSignature(var11_11)) {
                            var12_15 = PNGDecoder.decodeChunk(var11_11);
                            if (var12_15.type != 1229472850) break block28;
                            if (var12_15.data[8] != 8 || var12_15.data[9] != 2) break block29;
                            break block30;
                        }
                        if (ImageIOImageLoader.YCbCrBug) {
                            var10_10.reset();
                            var10_10.mark(512);
                            var11_11 = new DataInputStream(var10_10);
                            if (JPEGDecoder.decodeSignature(var11_11)) {
                                var8_8 = true;
                                block16: while (true) {
                                    var12_15 = JPEGDecoder.decodeChunk(var11_11);
                                    switch (var12_15.type) {
                                        case 65472: 
                                        case 65473: 
                                        case 65474: 
                                        case 65475: 
                                        case 65476: 
                                        case 65477: 
                                        case 65478: 
                                        case 65479: 
                                        case 65481: 
                                        case 65482: 
                                        case 65483: 
                                        case 65484: 
                                        case 65485: 
                                        case 65486: 
                                        case 65487: {
                                            var8_8 = var12_15.data.length == 15 && var12_15.data[5] == 3 && var12_15.data[7] == var12_15.data[10] && var12_15.data[7] == var12_15.data[13];
                                            ** break;
                                        }
                                        case 65504: {
                                            if (var12_15.data.length < 4 || var12_15.data[0] != 74 || var12_15.data[1] != 70 || var12_15.data[2] != 73 || var12_15.data[3] != 70) continue block16;
                                            var8_8 = false;
                                            ** break;
                                        }
                                        case 65506: {
                                            if (var12_15.data.length < 12 || var12_15.data[0] != 73 || var12_15.data[1] != 67 || var12_15.data[2] != 67 || var12_15.data[3] != 95 || var12_15.data[4] != 80 || var12_15.data[5] != 82 || var12_15.data[6] != 79 || var12_15.data[7] != 70 || var12_15.data[8] != 73 || var12_15.data[9] != 76 || var12_15.data[10] != 69 || var12_15.data[11] != 0) continue block16;
                                            var8_8 = false;
                                            ** break;
                                        }
                                        case 65517: 
                                        case 65518: {
                                            var8_8 = false;
                                            ** break;
                                        }
                                        case 65497: 
                                        case 65498: {
                                            ** break;
                                        }
                                    }
                                }
                            }
                        }
                        break block28;
                    }
                    catch (ImageIOException var11_12) {
                        try {
                            throw var11_12;
                            catch (IOException var11_13) {
                                throw new ImageIOException(var1_1, (Throwable)var11_13);
                            }
                        }
                        catch (Throwable var13_16) {
                            IOUtils.closeQuietly(var10_10);
                            throw var13_16;
                        }
                    }
                }
                block17: while (true) {
                    var12_15 = PNGDecoder.decodeChunk(var11_11);
                    switch (var12_15.type) {
                        case 1951551059: {
                            var6_6 = true;
                            break block17;
                        }
                        case 1229209940: {
                            var6_6 = false;
                            break block17;
                        }
                        default: {
                            continue block17;
                        }
                    }
                    break;
                }
                if (var6_6) {
                    if (var12_15.data.length != 6) {
                        throw new BrokenImageException(var1_1, "bad tRNS chunk length");
                    }
                    var7_7 = -16777216 | (var12_15.data[1] & 255) << 16 | (var12_15.data[3] & 255) << 8 | var12_15.data[5] & 255;
                }
            }
            if (ImageIOImageLoader.iTXtBug) {
                var10_10.reset();
                var10_10 = new RereadableInputStream(new PNGChunkSkipInputStream(ImageIOImageLoader.skip_iTXt, var10_10));
                var10_10.mark(1);
            }
        }
        var10_10.reset();
        var9_9 = this.wrapImageIO(var1_1, var10_10, ImageIOImageLoader.readImage);
        var10_10.close();
        IOUtils.closeQuietly((InputStream)var10_10);
        var11_14 = var9_9.getTransparency() == 1 && var6_6 == false ? var3_3 : var4_4;
        var12_15 = new Reference<BufferedImage>(var9_9);
        if (var6_6) {
            var9_9 = null;
            var9_9 = this.fix_tRNS(var12_15, var7_7, var11_14);
            var12_15.obj = var9_9;
        } else if (var8_8) {
            var9_9 = null;
            var9_9 = this.fix_YCbCr(var12_15, var11_14);
            var12_15.obj = var9_9;
        }
        if (var9_9.getType() == var11_14) {
            if (var6_6 == false) return var9_9;
            if (var5_5 == false) return var9_9;
        }
        var9_9 = null;
        return this.tconv.convert(var12_15, var11_14);
    }

    protected <T> T wrapImageIO(String string, InputStream inputStream, Wrapper<T> wrapper) throws ImageIOException {
        try {
            return wrapper.run(string, inputStream);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BrokenImageException(string, (Throwable)arrayIndexOutOfBoundsException);
        }
        catch (CMMException cMMException) {
            throw new BrokenImageException(string, (Throwable)cMMException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BrokenImageException(string, (Throwable)illegalArgumentException);
        }
        catch (ImageIOException imageIOException) {
            throw imageIOException;
        }
        catch (IOException iOException) {
            throw new ImageIOException(string, (Throwable)iOException);
        }
    }

    protected BufferedImage fix_tRNS(Reference<BufferedImage> reference, int n, int n2) throws ImageIOException {
        BufferedImage bufferedImage = (BufferedImage)reference.obj;
        if (bufferedImage.getType() != 2 && bufferedImage.getType() != 3) {
            if (n2 != 2 && n2 != 3) {
                n2 = 2;
            }
            bufferedImage = null;
            bufferedImage = this.tconv.convert(reference, n2);
        }
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            nArray[i] = 0;
        }
        return bufferedImage;
    }

    protected BufferedImage fix_YCbCr(Reference<BufferedImage> reference, int n) throws ImageIOException {
        BufferedImage bufferedImage = (BufferedImage)reference.obj;
        if (bufferedImage.getType() != 1 && bufferedImage.getType() != 2) {
            if (n != 1 && n != 2) {
                n = 2;
            }
            bufferedImage = null;
            bufferedImage = this.tconv.convert(reference, n);
        }
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i] >> 16 & 0xFF;
            int n3 = (nArray[i] >> 8 & 0xFF) - 128;
            int n4 = (nArray[i] & 0xFF) - 128;
            int n5 = nArray[i] >> 24 & 0xFF;
            int n6 = (int)Math.round((double)n2 + 1.402 * (double)n4);
            int n7 = (int)Math.round((double)n2 - 0.34414 * (double)n3 - 0.71414 * (double)n4);
            int n8 = (int)Math.round((double)n2 + 1.772 * (double)n3);
            nArray[i] = n5 << 24 | (n6 < 0 ? 0 : (n6 > 255 ? 255 : n6)) << 16 | (n7 < 0 ? 0 : (n7 > 255 ? 255 : n7)) << 8 | (n8 < 0 ? 0 : (n8 > 255 ? 255 : n8));
        }
        return bufferedImage;
    }

    @Override
    public Dimension size(String string, InputStream inputStream) throws ImageIOException {
        return this.wrapImageIO(string, inputStream, readSize);
    }

    static {
        block26: {
            Object object = System.getProperty("java.version");
            iTXtBug = object == null || ((String)object).startsWith("1.5");
            skip_iTXt = Collections.singleton(1767135348);
            object = null;
            Object object2 = null;
            try {
                object2 = ImageIOImageLoader.class.getResourceAsStream("/images/black.jpg");
                object = ImageIO.read(new MemoryCacheImageInputStream((InputStream)object2));
                ((InputStream)object2).close();
            }
            catch (IOException iOException) {
                throw new IllegalStateException();
            }
            finally {
                IOUtils.closeQuietly((InputStream)object2);
            }
            if (object == null) {
                throw new IllegalStateException();
            }
            int n = ((BufferedImage)object).getRGB(0, 0);
            switch (n) {
                case -16777216: {
                    YCbCrBug = false;
                    break;
                }
                case -16744320: 
                case -16742656: {
                    YCbCrBug = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected pixel value 0x" + String.format("%08x", n));
                }
            }
            object = null;
            try {
                object = Class.forName("sun.java2d.cmm.ProfileDeferralMgr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    object = Class.forName("sun.awt.color.ProfileDeferralMgr");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            if (object != null) {
                object2 = null;
                try {
                    object2 = ((Class)object).getField("deferring");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (object2 != null) {
                    try {
                        if (!((Field)object2).getBoolean(null)) break block26;
                        Method method = null;
                        try {
                            method = ((Class)object).getMethod("activateProfiles", new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (method != null) {
                            try {
                                method.invoke(null, new Object[0]);
                                ((Field)object2).setBoolean(null, false);
                            }
                            catch (InvocationTargetException invocationTargetException) {}
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }
        readImage = new Wrapper<BufferedImage>(){

            @Override
            public BufferedImage run(String string, InputStream inputStream) throws IOException {
                BufferedImage bufferedImage = ImageIO.read(new MemoryCacheImageInputStream(inputStream));
                if (bufferedImage == null) {
                    throw new UnrecognizedImageTypeException(string);
                }
                return bufferedImage;
            }
        };
        readSize = new Wrapper<Dimension>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension run(String string, InputStream inputStream) throws IOException {
                MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(memoryCacheImageInputStream);
                if (!iterator.hasNext()) {
                    throw new UnrecognizedImageTypeException(string);
                }
                ImageReader imageReader = iterator.next();
                try {
                    imageReader.setInput(memoryCacheImageInputStream);
                    Dimension dimension = new Dimension(imageReader.getWidth(0), imageReader.getHeight(0));
                    return dimension;
                }
                finally {
                    imageReader.dispose();
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Wrapper<T> {
        public T run(String var1, InputStream var2) throws IOException;
    }
}

