/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker;

import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;

public class BoardSlot
extends JPanel
implements Icon,
ActionListener {
    private static final long serialVersionUID = 1L;
    private String prompt = Resources.getString("BoardPicker.select_board");
    protected BoardPicker picker;
    protected Board board = null;
    protected JComboBox boards;
    protected JCheckBox reverseCheckBox;

    public BoardSlot(BoardPicker boardPicker) {
        this(boardPicker, Resources.getString("BoardPicker.select_board"));
    }

    public BoardSlot(BoardPicker boardPicker, String string) {
        this.prompt = string;
        this.picker = boardPicker;
        this.boards = new JComboBox();
        this.boards.addItem(string);
        String[] stringArray = this.picker.getAllowableLocalizedBoardNames();
        for (String string2 : stringArray) {
            this.boards.addItem(string2);
        }
        this.boards.setSelectedIndex(stringArray.length == 1 ? 1 : 0);
        this.boards.addActionListener(this);
        this.reverseCheckBox = new JCheckBox(Resources.getString("BoardPicker.flip"));
        this.reverseCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (BoardSlot.this.getBoard() != null) {
                    BoardSlot.this.getBoard().setReversed(BoardSlot.this.reverseCheckBox.isSelected());
                    BoardSlot.this.picker.repaint();
                }
            }
        });
        this.reverseCheckBox.setVisible(false);
        this.setLayout(new OverlayLayout(this));
        JPanel jPanel = new JPanel();
        Box box = Box.createHorizontalBox();
        box.add(this.boards);
        box.add(this.reverseCheckBox);
        jPanel.add(box);
        jPanel.setOpaque(false);
        jPanel.setAlignmentX(0.5f);
        JLabel jLabel = new JLabel(this);
        jLabel.setAlignmentX(0.5f);
        this.add(jPanel);
        this.add(jLabel);
        this.actionPerformed(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.prompt.equals(this.boards.getSelectedItem())) {
            this.setBoard(null);
        } else {
            String string = (String)this.boards.getSelectedItem();
            if (string != null) {
                Board board = this.picker.getLocalizedBoard(string);
                if (this.picker.getBoardsFromControls().contains(board)) {
                    board = board.copy();
                }
                this.setBoard(board);
            }
        }
    }

    public Board getBoard() {
        return this.board;
    }

    public void setBoard(Board board) {
        this.board = board;
        if (board != null) {
            this.reverseCheckBox.setVisible("true".equals(board.getAttributeValueString("reversible")));
            this.reverseCheckBox.setSelected(board.isReversed());
            this.board = board;
            this.setSize(this.getPreferredSize());
            this.revalidate();
            this.repaint();
        } else {
            this.reverseCheckBox.setVisible(false);
            this.revalidate();
            this.setSize(this.getPreferredSize());
            this.repaint();
        }
    }

    public int getIconHeight() {
        if (this.board != null) {
            return (int)(this.picker.getSlotScale() * (double)this.board.bounds().height);
        }
        if (this == this.picker.getSlot(0) || this.picker.getSlot(0) == null) {
            return this.picker.getDefaultSlotSize().height;
        }
        return this.picker.getSlot(0).getIconHeight();
    }

    public int getIconWidth() {
        if (this.board != null) {
            return (int)(this.picker.getSlotScale() * (double)this.board.bounds().width);
        }
        if (this == this.picker.getSlot(0) || this.picker.getSlot(0) == null) {
            return this.picker.getDefaultSlotSize().width;
        }
        return this.picker.getSlot(0).getIconWidth();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.board != null) {
            this.board.draw(graphics, n, n2, this.picker.getSlotScale(), component);
        } else {
            graphics.clearRect(n, n2, this.getIconWidth(), this.getIconHeight());
        }
    }
}

