topic "General description";
[ $$0,0#00000000000000000000000000000000:Default]
[a83;*R6 $$1,0#31310162474203024125188417583966:caption]
[{_}%EN-US 
[s1; [+184 MAPIEx]&]
[s0; [2 MAPIEx handles Microsoft Outlook elements as messages, folders, 
contacts and appointments through Extended MAPI (Message API).]&]
[s0;2 &]
[s0; [2 With MAPIEx you can check email folders, open and save emails 
including images and attachments, create contacts or delete emails 
and folders. Many simple examples are included in MAPIEx`_demo 
package.]&]
[s0;2 &]
[s0; [2 MAPIEx is a wrapper of ][^http`:`/`/www`.mud`.ca`/MAPIEx`.zip^2 Noel 
Dillabough CMAPIEx library][2  It contains code from ][^http`:`/`/www`.wischik`.com`/lu`/programmer`/mapi`_utils`.html^2 L
ucian Wischik MAPI Utils][2 .]&]
[s0;2 &]
[s0; [2 The main changes in relationship with original code have been:]&]
[s0;2 &]
[s0;i150;O0; [2 `"new`" and `"delete`" are not necessary in user program. 
No heap errors are expected as now all user variables are in 
the stack. In addition internal use of heap has been reduced.]&]
[s0;i150;O0; [2 The library interface from user point of view has been 
simplified. GetContents() and GetHierarchy() use is now private.]&]
[s0;i150;O0; [2 To improve compatibility CString and TCHAR have been 
removed. They have been substituted by String.]&]
[s0;i150;O0; [2 Added documentation.]&]
[s0;2 &]
[s0;2 &]
[s0; [2 MAPIEx classes are:]&]
[s0;2 &]
[s0;i150;O0; [^topic`:`/`/MAPIEx`/src`/MAPIEx`$en`-us^2 MAPIEx]&]
[s0;i150;O0; [^topic`:`/`/MAPIEx`/src`/MAPIFolder`$en`-us^2 MAPIFolder]&]
[s0;i150;O0; [^topic`:`/`/MAPIEx`/src`/MAPIMessage`$en`-us^2 MAPIMessage]&]
[s0;i150;O0; [^topic`:`/`/MAPIEx`/src`/MAPIAppointment`$en`-us^2 MAPIAppointment]&]
[s0;i150;O0; [^topic`:`/`/MAPIEx`/src`/MAPIAttachment`$en`-us^2 MAPIAttachment]&]
[s0;i150;O0; [^topic`:`/`/MAPIEx`/src`/MAPIContact`$en`-us^2 MAPIContact]&]
[s0;2 &]
[s0; [2 There is a ][^topic`:`/`/MAPIEx`/srcdoc`/ChangesLog`$en`-us^2 News 
and changes log][2 , ][^topic`:`/`/MAPIEx`/srcdoc`/License`$en`-us^2 License][2  
and a ][^topic`:`/`/MAPIEx`/srcdoc`/ToDo`$en`-us^2 ToDo list][2 .]&]
[s0;2 &]
[s0;2 &]
[s0; [*+92 Compiler support and Requirements]&]
[s0;*+92 &]
[s0; [2 As MAPIEx uses internal Microsoft infrastructure, it can only 
work with Outlook installed.]&]
[s0;2 &]
[s0; [2 MAPIEx has been tested with MSC and MinGW.]&]
[s0;2 &]
[s0; [2 MAPIEx compiled in 32 bits can only work with Outlook 32 bits, 
and the same happens with 64 bits. Mixing version of different 
bits will raise a window like this:]&]
[s0;2 &]
[s0; [2 
@@image:2308&855
(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)
]&]
[s0;2 &]
[s0; [2 If your compiler does not include MAPI header files (MinGW, 
MSC 12) they can be downloaded from][^https`:`/`/www`.microsoft`.com`/en`-us`/download`/details`.aspx`?id`=12905^2  
this Microsoft Outlook link][2 .]&]
[s0;2 &]
[s0; [2 If this link does not serve you, you can also copy the files 
in MAPIEx/include`_MINGW32 to compiler include folder.]&]
[s0;*+92 &]
[s0;2 ]]