/* DateTime.c generated by valac 0.52.4, the Vala compiler
 * generated from DateTime.vala, do not modify */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#define TOOTLE_TYPE_DATE_TIME (tootle_date_time_get_type ())
#define TOOTLE_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_DATE_TIME, TootleDateTime))
#define TOOTLE_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_DATE_TIME, TootleDateTimeClass))
#define TOOTLE_IS_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_DATE_TIME))
#define TOOTLE_IS_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_DATE_TIME))
#define TOOTLE_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_DATE_TIME, TootleDateTimeClass))

typedef struct _TootleDateTime TootleDateTime;
typedef struct _TootleDateTimeClass TootleDateTimeClass;
typedef struct _TootleDateTimePrivate TootleDateTimePrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TootleParamSpecDateTime TootleParamSpecDateTime;

struct _TootleDateTime {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TootleDateTimePrivate * priv;
};

struct _TootleDateTimeClass {
	GTypeClass parent_class;
	void (*finalize) (TootleDateTime *self);
};

struct _TootleParamSpecDateTime {
	GParamSpec parent_instance;
};

static gpointer tootle_date_time_parent_class = NULL;

gpointer tootle_date_time_ref (gpointer instance);
void tootle_date_time_unref (gpointer instance);
GParamSpec* tootle_param_spec_date_time (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void tootle_value_set_date_time (GValue* value,
                                 gpointer v_object);
void tootle_value_take_date_time (GValue* value,
                                  gpointer v_object);
gpointer tootle_value_get_date_time (const GValue* value);
GType tootle_date_time_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleDateTime, tootle_date_time_unref)
gchar* tootle_date_time_humanize (const gchar* iso8601);
gboolean tootle_date_time_is_same_day (GDateTime* d1,
                                       GDateTime* d2);
TootleDateTime* tootle_date_time_new (void);
TootleDateTime* tootle_date_time_construct (GType object_type);
static void tootle_date_time_finalize (TootleDateTime * obj);
static GType tootle_date_time_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
tootle_date_time_humanize (const gchar* iso8601)
{
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GTimeSpan delta = 0LL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (iso8601 != NULL, NULL);
	_tmp0_ = g_date_time_new_from_iso8601 (iso8601, NULL);
	date = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = date;
	delta = g_date_time_difference (_tmp2_, _tmp3_);
	if (delta <= G_TIME_SPAN_MINUTE) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (_ ("Just now"));
		result = _tmp4_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (date);
		return result;
	} else {
		if (delta < G_TIME_SPAN_HOUR) {
			GTimeSpan minutes = 0LL;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			minutes = delta / G_TIME_SPAN_MINUTE;
			_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) minutes);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strconcat (_tmp6_, "m", NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup (_ (_tmp8_));
			_tmp10_ = _tmp9_;
			_g_free0 (_tmp8_);
			_g_free0 (_tmp6_);
			result = _tmp10_;
			_g_date_time_unref0 (now);
			_g_date_time_unref0 (date);
			return result;
		} else {
			if (delta <= G_TIME_SPAN_DAY) {
				GTimeSpan hours = 0LL;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				hours = delta / G_TIME_SPAN_HOUR;
				_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) hours);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp12_, "h", NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strdup (_ (_tmp14_));
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				result = _tmp16_;
				_g_date_time_unref0 (now);
				_g_date_time_unref0 (date);
				return result;
			} else {
				GDateTime* _tmp17_;
				GDateTime* _tmp18_;
				GDateTime* _tmp19_;
				GDateTime* _tmp20_;
				gboolean _tmp21_;
				_tmp17_ = now;
				_tmp18_ = date;
				_tmp19_ = g_date_time_add_days (_tmp18_, 1);
				_tmp20_ = _tmp19_;
				_tmp21_ = tootle_date_time_is_same_day (_tmp17_, _tmp20_);
				_g_date_time_unref0 (_tmp20_);
				if (_tmp21_) {
					gchar* _tmp22_;
					_tmp22_ = g_strdup (_ ("Yesterday"));
					result = _tmp22_;
					_g_date_time_unref0 (now);
					_g_date_time_unref0 (date);
					return result;
				} else {
					GDateTime* _tmp23_;
					GDateTime* _tmp24_;
					_tmp23_ = date;
					_tmp24_ = now;
					if (g_date_time_get_year (_tmp23_) == g_date_time_get_year (_tmp24_)) {
						GDateTime* _tmp25_;
						gchar* _tmp26_;
						_tmp25_ = date;
						_tmp26_ = g_date_time_format (_tmp25_, _ ("%b %e"));
						result = _tmp26_;
						_g_date_time_unref0 (now);
						_g_date_time_unref0 (date);
						return result;
					} else {
						GDateTime* _tmp27_;
						gchar* _tmp28_;
						_tmp27_ = date;
						_tmp28_ = g_date_time_format (_tmp27_, _ ("%b %e, %Y"));
						result = _tmp28_;
						_g_date_time_unref0 (now);
						_g_date_time_unref0 (date);
						return result;
					}
				}
			}
		}
	}
}

gboolean
tootle_date_time_is_same_day (GDateTime* d1,
                              GDateTime* d2)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (d1 != NULL, FALSE);
	g_return_val_if_fail (d2 != NULL, FALSE);
	if (g_date_time_get_day_of_year (d1) == g_date_time_get_day_of_year (d2)) {
		_tmp0_ = g_date_time_get_year (d1) == g_date_time_get_year (d2);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

TootleDateTime*
tootle_date_time_construct (GType object_type)
{
	TootleDateTime* self = NULL;
	self = (TootleDateTime*) g_type_create_instance (object_type);
	return self;
}

TootleDateTime*
tootle_date_time_new (void)
{
	return tootle_date_time_construct (TOOTLE_TYPE_DATE_TIME);
}

static void
tootle_value_date_time_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tootle_value_date_time_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tootle_date_time_unref (value->data[0].v_pointer);
	}
}

static void
tootle_value_date_time_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tootle_date_time_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tootle_value_date_time_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tootle_value_date_time_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TootleDateTime * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tootle_date_time_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tootle_value_date_time_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	TootleDateTime ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tootle_date_time_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tootle_param_spec_date_time (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	TootleParamSpecDateTime* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TOOTLE_TYPE_DATE_TIME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tootle_value_get_date_time (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TOOTLE_TYPE_DATE_TIME), NULL);
	return value->data[0].v_pointer;
}

void
tootle_value_set_date_time (GValue* value,
                            gpointer v_object)
{
	TootleDateTime * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TOOTLE_TYPE_DATE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TOOTLE_TYPE_DATE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tootle_date_time_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tootle_date_time_unref (old);
	}
}

void
tootle_value_take_date_time (GValue* value,
                             gpointer v_object)
{
	TootleDateTime * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TOOTLE_TYPE_DATE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TOOTLE_TYPE_DATE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tootle_date_time_unref (old);
	}
}

static void
tootle_date_time_class_init (TootleDateTimeClass * klass,
                             gpointer klass_data)
{
	tootle_date_time_parent_class = g_type_class_peek_parent (klass);
	((TootleDateTimeClass *) klass)->finalize = tootle_date_time_finalize;
}

static void
tootle_date_time_instance_init (TootleDateTime * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
tootle_date_time_finalize (TootleDateTime * obj)
{
	TootleDateTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TOOTLE_TYPE_DATE_TIME, TootleDateTime);
	g_signal_handlers_destroy (self);
}

static GType
tootle_date_time_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tootle_value_date_time_init, tootle_value_date_time_free_value, tootle_value_date_time_copy_value, tootle_value_date_time_peek_pointer, "p", tootle_value_date_time_collect_value, "p", tootle_value_date_time_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TootleDateTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tootle_date_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TootleDateTime), 0, (GInstanceInitFunc) tootle_date_time_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tootle_date_time_type_id;
	tootle_date_time_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TootleDateTime", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tootle_date_time_type_id;
}

GType
tootle_date_time_get_type (void)
{
	static volatile gsize tootle_date_time_type_id__volatile = 0;
	if (g_once_init_enter (&tootle_date_time_type_id__volatile)) {
		GType tootle_date_time_type_id;
		tootle_date_time_type_id = tootle_date_time_get_type_once ();
		g_once_init_leave (&tootle_date_time_type_id__volatile, tootle_date_time_type_id);
	}
	return tootle_date_time_type_id__volatile;
}

gpointer
tootle_date_time_ref (gpointer instance)
{
	TootleDateTime * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tootle_date_time_unref (gpointer instance)
{
	TootleDateTime * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TOOTLE_DATE_TIME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

