/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Binding;
import com.icl.saxon.Loader;
import com.icl.saxon.expr.ExpressionParser;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.FunctionProxy;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.exslt.Common;
import com.icl.saxon.exslt.Date;
import com.icl.saxon.exslt.Math;
import com.icl.saxon.exslt.Sets;
import com.icl.saxon.functions.Extensions;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NamespaceTest;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLKey;
import com.icl.saxon.style.XSLStyleSheet;
import javax.xml.transform.TransformerException;

public class ExpressionContext
implements StaticContext {
    private StyleElement element;
    private NamePool namePool;

    public ExpressionContext(StyleElement styleElement) {
        this.element = styleElement;
        this.namePool = styleElement.getNamePool();
    }

    @Override
    public StaticContext makeRuntimeContext(NamePool namePool) {
        ExpressionContext expressionContext = new ExpressionContext(this.element);
        expressionContext.namePool = namePool;
        return expressionContext;
    }

    @Override
    public String getSystemId() {
        return this.element.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    @Override
    public String getBaseURI() {
        return this.element.getBaseURI();
    }

    @Override
    public String getURIForPrefix(String string) throws XPathException {
        try {
            short s = this.element.getURICodeForPrefix(string);
            return this.namePool.getURIFromURICode(s);
        }
        catch (NamespaceException namespaceException) {
            throw new XPathException(namespaceException.getMessage());
        }
    }

    @Override
    public final int makeNameCode(String string, boolean bl) throws XPathException {
        String string2 = Name.getPrefix(string);
        try {
            if (string2.equals("")) {
                short s = 0;
                if (!Name.isNCName(string)) {
                    throw new XPathException("Name " + string + " contains invalid characters");
                }
                if (bl) {
                    s = this.element.getURICodeForPrefix(string2);
                }
                return this.namePool.allocate(string2, s, string);
            }
            String string3 = Name.getLocalName(string);
            short s = this.element.getURICodeForPrefix(string2);
            return this.namePool.allocate(string2, s, string3);
        }
        catch (NamespaceException namespaceException) {
            throw new XPathException("Namespace prefix " + string2 + " has not been declared");
        }
    }

    @Override
    public int getFingerprint(String string, boolean bl) throws XPathException {
        String string2 = Name.getPrefix(string);
        if (string2.equals("")) {
            String string3 = "";
            if (bl) {
                string3 = this.getURIForPrefix(string2);
            }
            return this.namePool.getFingerprint(string3, string);
        }
        String string4 = Name.getLocalName(string);
        String string5 = this.getURIForPrefix(string2);
        return this.namePool.getFingerprint(string5, string4);
    }

    @Override
    public NameTest makeNameTest(short s, String string, boolean bl) throws XPathException {
        int n = this.makeNameCode(string, bl);
        NameTest nameTest = new NameTest(s, n);
        nameTest.setOriginalText(string);
        return nameTest;
    }

    @Override
    public NamespaceTest makeNamespaceTest(short s, String string) throws XPathException {
        try {
            short s2 = this.element.getURICodeForPrefix(string);
            NamespaceTest namespaceTest = new NamespaceTest(this.namePool, s, s2);
            namespaceTest.setOriginalText(string + ":*");
            return namespaceTest;
        }
        catch (NamespaceException namespaceException) {
            throw new XPathException(namespaceException.getMessage());
        }
    }

    @Override
    public Binding bindVariable(int n) throws XPathException {
        return this.element.bindVariable(n);
    }

    @Override
    public boolean isExtensionNamespace(short s) throws XPathException {
        return this.element.isExtensionNamespace(s);
    }

    @Override
    public boolean forwardsCompatibleModeIsEnabled() throws XPathException {
        return this.element.forwardsCompatibleModeIsEnabled();
    }

    @Override
    public Function getStyleSheetFunction(int n) throws XPathException {
        return this.element.getStyleSheetFunction(n);
    }

    @Override
    public Class getExternalJavaClass(String string) throws TransformerException {
        XSLStyleSheet xSLStyleSheet = this.element.getPrincipalStyleSheet();
        Class clazz = xSLStyleSheet.getExternalJavaClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (string.equals("http://icl.com/saxon")) {
            return Extensions.class;
        }
        if (string.equals("http://exslt.org/common")) {
            return Common.class;
        }
        if (string.equals("http://exslt.org/sets")) {
            return Sets.class;
        }
        if (string.equals("http://exslt.org/math")) {
            return Math.class;
        }
        if (string.equals("http://exslt.org/dates-and-times")) {
            return Date.class;
        }
        if (!((Boolean)xSLStyleSheet.getPreparedStyleSheet().getTransformerFactory().getAttribute("http://icl.com/saxon/feature/allow-external-functions")).booleanValue()) {
            throw new TransformerException("Calls to external functions have been disabled");
        }
        try {
            if (string.startsWith("java:")) {
                return Loader.getClass(string.substring(5));
            }
            int n = string.lastIndexOf(47);
            if (n < 0) {
                return Loader.getClass(string);
            }
            if (n == string.length() - 1) {
                return null;
            }
            return Loader.getClass(string.substring(n + 1));
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    @Override
    public boolean isElementAvailable(String string) throws XPathException {
        if (!Name.isQName(string)) {
            throw new XPathException("Invalid QName: " + string);
        }
        String string2 = Name.getPrefix(string);
        String string3 = Name.getLocalName(string);
        String string4 = this.getURIForPrefix(string2);
        return this.element.getPreparedStyleSheet().getStyleNodeFactory().isElementAvailable(string4, string3);
    }

    @Override
    public boolean isFunctionAvailable(String string) throws XPathException {
        if (!Name.isQName(string)) {
            throw new XPathException("Invalid QName: " + string);
        }
        String string2 = Name.getPrefix(string);
        String string3 = this.getURIForPrefix(string2);
        try {
            Object object;
            if (string2.equals("")) {
                return ExpressionParser.makeSystemFunction(string) != null;
            }
            int n = this.getFingerprint(string, false);
            if (n >= 0 && (object = this.getStyleSheetFunction(n)) != null) {
                return true;
            }
            object = this.getExternalJavaClass(string3);
            if (object == null) {
                return false;
            }
            String string4 = Name.getLocalName(string);
            FunctionProxy functionProxy = new FunctionProxy();
            return functionProxy.setFunctionName((Class)object, string4);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean allowsKeyFunction() {
        return !(this.element instanceof XSLKey);
    }

    @Override
    public String getVersion() {
        return this.element.getVersion();
    }

    public String toString() {
        return "Expression Context at " + this.element.toString();
    }
}

