/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.Version;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Name;

public class SystemProperty
extends Function {
    @Override
    public String getName() {
        return "system-property";
    }

    @Override
    public int getDataType() {
        return -1;
    }

    @Override
    public Expression simplify() throws XPathException {
        this.checkArgumentCount(1, 1);
        this.argument[0] = this.argument[0].simplify();
        if (this.argument[0] instanceof Value) {
            return this.evaluate(null);
        }
        return this;
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        String string = this.argument[0].evaluateAsString(context);
        if (!Name.isQName(string)) {
            throw new XPathException("Argument " + string + " is not a valid QName");
        }
        String string2 = Name.getPrefix(string);
        String string3 = Name.getLocalName(string);
        String string4 = string2.equals("") ? "" : this.getStaticContext().getURIForPrefix(string2);
        return SystemProperty.getProperty(string4, string3);
    }

    public static Value getProperty(String string, String string2) {
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equals("version")) {
                return new NumericValue(Version.getXSLVersion());
            }
            if (string2.equals("vendor")) {
                return new StringValue(Version.getProductName());
            }
            if (string2.equals("vendor-url")) {
                return new StringValue(Version.getWebSiteAddress());
            }
            return new StringValue("");
        }
        if (string.equals("")) {
            String string3 = System.getProperty(string2);
            if (string3 == null) {
                string3 = "";
            }
            return new StringValue(string3);
        }
        return new StringValue("");
    }

    @Override
    public int getDependencies() {
        return this.argument[0].getDependencies();
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        SystemProperty systemProperty = new SystemProperty();
        systemProperty.addArgument(this.argument[0].reduce(n, context));
        systemProperty.setStaticContext(this.getStaticContext());
        return systemProperty;
    }
}

