/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.AttributeReference;
import com.icl.saxon.expr.AxisExpression;
import com.icl.saxon.expr.ContextNodeExpression;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetIntent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.RootExpression;
import com.icl.saxon.expr.SingletonExpression;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.Step;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Axis;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.sort.NodeOrderComparer;

public class PathExpression
extends NodeSetExpression {
    private Expression start;
    private Step step;
    int dependencies = -1;

    public PathExpression(Expression expression, Step step) {
        this.start = expression;
        this.step = step;
    }

    @Override
    public Expression simplify() throws XPathException {
        this.start = this.start.simplify();
        this.step = this.step.simplify();
        if (this.start instanceof EmptyNodeSet) {
            return this.start;
        }
        if (this.step == null) {
            return new EmptyNodeSet();
        }
        byte by = this.step.getAxis();
        if (this.start instanceof RootExpression && by == 9) {
            return new EmptyNodeSet();
        }
        if (this.start instanceof ContextNodeExpression && by == 2 && this.step.getNodeTest() instanceof NameTest && this.step.getNumberOfFilters() == 0) {
            return new AttributeReference(this.step.getNodeTest().getFingerprint());
        }
        if (this.start instanceof ContextNodeExpression && this.step.getNumberOfFilters() == 0) {
            return new AxisExpression(by, this.step.getNodeTest());
        }
        if (by == 3 && this.step.getNumberOfFilters() == 0 && this.start instanceof PathExpression && ((PathExpression)this.start).step.getAxis() == 5 && ((PathExpression)this.start).step.getNumberOfFilters() == 0 && ((PathExpression)this.start).step.getNodeTest() instanceof AnyNodeTest) {
            return new PathExpression(((PathExpression)this.start).start, new Step(4, this.step.getNodeTest()));
        }
        return this;
    }

    @Override
    public int getDependencies() {
        if (this.dependencies == -1) {
            this.dependencies = this.start.getDependencies();
            Expression[] expressionArray = this.step.getFilters();
            for (int i = 0; i < this.step.getNumberOfFilters(); ++i) {
                Expression expression = expressionArray[i];
                this.dependencies |= expression.getDependencies() & 0x45;
            }
        }
        return this.dependencies;
    }

    @Override
    public boolean isContextDocumentNodeSet() {
        return this.start.isContextDocumentNodeSet();
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        Expression expression = this;
        if ((n & this.getDependencies()) != 0) {
            Expression expression2 = this.start.reduce(n, context);
            Step step = new Step(this.step.getAxis(), this.step.getNodeTest());
            Expression[] expressionArray = this.step.getFilters();
            int n2 = n & 0x45;
            if (this.start.isContextDocumentNodeSet() && (n & 0x80) != 0) {
                n2 |= 0x80;
            }
            for (int i = 0; i < this.step.getNumberOfFilters(); ++i) {
                Expression expression3 = expressionArray[i];
                Expression expression4 = expression3.reduce(n2, context);
                step.addFilter(expression4);
            }
            expression = new PathExpression(expression2, step);
            expression.setStaticContext(this.getStaticContext());
            expression = ((Expression)expression).simplify();
        }
        if (expression instanceof PathExpression && expression.start instanceof NodeSetValue) {
            return new NodeSetIntent((NodeSetExpression)expression, context.getController());
        }
        return expression;
    }

    @Override
    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        int n = this.getDependencies();
        int n2 = 0;
        if ((n & 0x45) != 0) {
            n2 |= 0x45;
        }
        if (this.start.isContextDocumentNodeSet() && (n & 0x80) != 0) {
            n2 |= 0x80;
        }
        if ((n2 & 0xC5) != 0) {
            Expression expression = this.reduce(n2, context);
            return expression.enumerate(context, bl);
        }
        PathEnumeration pathEnumeration = new PathEnumeration(this.start, context);
        if (bl && !pathEnumeration.isSorted()) {
            NodeOrderComparer nodeOrderComparer = this.start instanceof SingletonNodeSet || this.start.isContextDocumentNodeSet() ? LocalOrderComparer.getInstance() : context.getController();
            NodeSetExtent nodeSetExtent = new NodeSetExtent(pathEnumeration, nodeOrderComparer);
            nodeSetExtent.sort();
            return nodeSetExtent.enumerate();
        }
        return pathEnumeration;
    }

    @Override
    public void display(int n) {
        System.err.println(PathExpression.indent(n) + "path");
        this.start.display(n + 1);
        this.step.display(n + 1);
    }

    private class PathEnumeration
    implements NodeEnumeration {
        private Expression thisStart;
        private NodeEnumeration base = null;
        private NodeEnumeration thisStep = null;
        private NodeInfo next = null;
        private Context context;

        public PathEnumeration(Expression expression, Context context) throws XPathException {
            if (expression instanceof SingletonNodeSet && !((SingletonNodeSet)expression).isGeneralUseAllowed()) {
                throw new XPathException("To use a result tree fragment in a path expression, either use exsl:node-set() or specify version='1.1'");
            }
            this.thisStart = expression;
            this.context = context.newContext();
            this.base = expression.enumerate(this.context, false);
            this.next = this.getNextNode();
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public NodeInfo nextElement() throws XPathException {
            NodeInfo nodeInfo = this.next;
            this.next = this.getNextNode();
            return nodeInfo;
        }

        private NodeInfo getNextNode() throws XPathException {
            if (this.thisStep != null && this.thisStep.hasMoreElements()) {
                return this.thisStep.nextElement();
            }
            while (this.base.hasMoreElements()) {
                NodeInfo nodeInfo = this.base.nextElement();
                this.thisStep = PathExpression.this.step.enumerate(nodeInfo, this.context);
                if (!this.thisStep.hasMoreElements()) continue;
                return this.thisStep.nextElement();
            }
            return null;
        }

        @Override
        public boolean isSorted() {
            byte by = PathExpression.this.step.getAxis();
            return Axis.isForwards[by] && (this.thisStart instanceof SingletonExpression || this.base.isSorted() && this.base.isPeer() && Axis.isSubtreeAxis[by] || this.base.isSorted() && (by == 2 || by == 8));
        }

        @Override
        public boolean isReverseSorted() {
            return this.thisStart instanceof SingletonExpression && Axis.isReverse[PathExpression.this.step.getAxis()];
        }

        @Override
        public boolean isPeer() {
            return this.base.isPeer() && Axis.isPeerAxis[PathExpression.this.step.getAxis()];
        }
    }
}

