/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Binding;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public final class Bindery {
    private Object[] globals;
    private boolean[] busy;
    private Object[][] stack = new Object[20][];
    private Object[] currentStackFrame;
    private ParameterSet globalParameters;
    private int top = -1;
    private int allocated = 0;
    private int globalSpace = 0;
    private int localSpace = 0;

    public void allocateGlobals(int n) {
        this.globalSpace = n;
        this.globals = new Object[n];
        this.busy = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.globals[i] = null;
            this.busy[i] = false;
        }
    }

    public void defineGlobalParameters(ParameterSet parameterSet) {
        this.globalParameters = parameterSet;
    }

    public boolean useGlobalParameter(int n, Binding binding) {
        if (this.globalParameters == null) {
            return false;
        }
        Value value = this.globalParameters.get(n);
        if (value == null) {
            return false;
        }
        this.globals[binding.getSlotNumber()] = value;
        return true;
    }

    public void defineGlobalVariable(Binding binding, Value value) {
        this.globals[binding.getSlotNumber()] = value;
    }

    public void setExecuting(Binding binding, boolean bl) throws XPathException {
        int n = binding.getSlotNumber();
        if (bl) {
            if (this.busy[n]) {
                throw new XPathException("Circular definition of variable " + binding.getVariableName());
            }
            this.busy[n] = true;
        } else {
            this.busy[n] = false;
        }
    }

    public boolean isEvaluated(Binding binding) {
        return this.globals[binding.getSlotNumber()] != null;
    }

    public void allocateLocals(int n) {
        if (n > this.localSpace) {
            this.localSpace = n;
        }
    }

    public void openStackFrame(ParameterSet parameterSet) {
        if (++this.top >= this.allocated) {
            if (this.allocated == this.stack.length) {
                Object[][] objectArrayArray = new Object[this.allocated * 2][];
                System.arraycopy(this.stack, 0, objectArrayArray, 0, this.allocated);
                this.stack = objectArrayArray;
            }
            this.currentStackFrame = new Object[this.localSpace + 1];
            this.stack[this.top] = this.currentStackFrame;
            ++this.allocated;
        } else {
            this.currentStackFrame = this.stack[this.top];
        }
        this.currentStackFrame[0] = parameterSet;
        for (int i = 1; i < this.currentStackFrame.length; ++i) {
            this.currentStackFrame[i] = null;
        }
    }

    public void closeStackFrame() {
        --this.top;
        this.currentStackFrame = this.top < 0 ? null : this.stack[this.top];
    }

    public boolean useLocalParameter(int n, Binding binding) {
        ParameterSet parameterSet = (ParameterSet)this.currentStackFrame[0];
        if (parameterSet == null) {
            return false;
        }
        Value value = parameterSet.get(n);
        this.currentStackFrame[binding.getSlotNumber() + 1] = value;
        return value != null;
    }

    public Value getLocalParameter(int n) {
        ParameterSet parameterSet = (ParameterSet)this.currentStackFrame[0];
        if (parameterSet == null) {
            return null;
        }
        return parameterSet.get(n);
    }

    public void defineLocalVariable(Binding binding, Value value) {
        if (this.currentStackFrame == null) {
            throw new IllegalArgumentException("Can't define local variable: stack is empty");
        }
        this.currentStackFrame[binding.getSlotNumber() + 1] = value;
    }

    public Value getValue(Binding binding) {
        if (binding.isGlobal()) {
            return (Value)this.globals[binding.getSlotNumber()];
        }
        if (this.currentStackFrame != null) {
            return (Value)this.currentStackFrame[binding.getSlotNumber() + 1];
        }
        return null;
    }

    public Value getValue(Binding binding, int n) {
        if (binding.isGlobal()) {
            return (Value)this.globals[binding.getSlotNumber()];
        }
        Object[] objectArray = this.stack[n];
        if (objectArray != null) {
            return (Value)objectArray[binding.getSlotNumber() + 1];
        }
        return null;
    }

    public int getFrameId() {
        return this.top;
    }

    public void assignVariable(Binding binding, Value value) {
        if (binding.isGlobal()) {
            this.defineGlobalVariable(binding, value);
        } else {
            this.defineLocalVariable(binding, value);
        }
    }
}

