/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.application;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationException;

public abstract class ApplicationHandle {
    public static final String APPLICATION_PID = "service.pid";
    public static final String APPLICATION_DESCRIPTOR = "application.descriptor";
    public static final String APPLICATION_STATE = "application.state";
    public static final String APPLICATION_SUPPORTS_EXITVALUE = "application.supports.exitvalue";
    public static final String RUNNING = "RUNNING";
    public static final String STOPPING = "STOPPING";
    private final String instanceId;
    private final ApplicationDescriptor descriptor;
    Delegate delegate;

    protected ApplicationHandle(String string, ApplicationDescriptor applicationDescriptor) {
        if (null == string || null == applicationDescriptor) {
            throw new NullPointerException("Parameters must not be null!");
        }
        this.instanceId = string;
        this.descriptor = applicationDescriptor;
        try {
            this.delegate = new Delegate();
            this.delegate.setApplicationHandle(this, applicationDescriptor.delegate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("No implementation available for ApplicationDescriptor, property is: " + Delegate.cName);
        }
    }

    public final ApplicationDescriptor getApplicationDescriptor() {
        return this.descriptor;
    }

    public abstract String getState();

    public Object getExitValue(long l) throws ApplicationException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public final String getInstanceId() {
        return this.instanceId;
    }

    public final void destroy() {
        try {
            this.delegate.destroy();
        }
        catch (SecurityException securityException) {
            this.descriptor.isLaunchableSpecific();
            throw securityException;
        }
        this.destroySpecific();
    }

    protected abstract void destroySpecific();

    static class Delegate {
        static String cName;
        static Class implementation;
        static Method setApplicationHandle;
        static Method destroy;
        Object target = AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return implementation.newInstance();
            }
        });

        Delegate() throws Exception {
        }

        void setApplicationHandle(ApplicationHandle applicationHandle, ApplicationDescriptor.Delegate delegate) {
            try {
                try {
                    setApplicationHandle.invoke(this.target, applicationHandle, delegate.target);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        void destroy() {
            try {
                try {
                    destroy.invoke(this.target, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    cName = System.getProperty("org.osgi.vendor.application.ApplicationHandle");
                    if (cName == null) {
                        throw new NoClassDefFoundError("org.osgi.vendor.application.ApplicationHandle property must be set");
                    }
                    try {
                        implementation = Class.forName(cName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.toString());
                    }
                    try {
                        setApplicationHandle = implementation.getMethod("setApplicationHandle", ApplicationHandle.class, Object.class);
                        destroy = implementation.getMethod("destroy", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new NoSuchMethodError(noSuchMethodException.toString());
                    }
                    return null;
                }
            });
        }
    }
}

