/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.runners;

import java.lang.reflect.InvocationTargetException;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.runners.RunnerImpl;
import org.mockito.internal.runners.util.RunnerProvider;
import org.mockito.internal.runners.util.TestMethodsFinder;

public class RunnerFactory {
    private final RunnerProvider runnerProvider;

    RunnerFactory(RunnerProvider runnerProvider) {
        this.runnerProvider = runnerProvider;
    }

    public RunnerFactory() {
        this(new RunnerProvider());
    }

    public RunnerImpl create(Class<?> clazz) throws InvocationTargetException {
        try {
            if (this.runnerProvider.isJUnit45OrHigherAvailable()) {
                return this.runnerProvider.newInstance("org.mockito.internal.runners.JUnit45AndHigherRunnerImpl", clazz);
            }
            return this.runnerProvider.newInstance("org.mockito.internal.runners.JUnit44RunnerImpl", clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!new TestMethodsFinder().hasTestMethods(clazz)) {
                throw new MockitoException("\n\nNo tests found in " + clazz.getSimpleName() + "\n" + "Haven't you forgot @Test annotation?\n", invocationTargetException);
            }
            throw invocationTargetException;
        }
        catch (Throwable throwable) {
            throw new MockitoException("\n\nMockitoRunner can only be used with JUnit 4.4 or higher.\nYou can upgrade your JUnit version or write your own Runner (please consider contributing your runner to the Mockito community).\nBear in mind that you can still enjoy all features of the framework without using runners (they are completely optional).\nIf you get this error despite using JUnit 4.4 or higher then please report this error to the mockito mailing list.\n", throwable);
        }
    }
}

