/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.collections15.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections15.iterators.AbstractListIteratorDecorator;
import org.apache.commons.collections15.list.AbstractSerializableListDecorator;
import org.apache.commons.collections15.set.UnmodifiableSet;

public class SetUniqueList<E>
extends AbstractSerializableListDecorator<E> {
    private static final long serialVersionUID = 7196982186153478694L;
    protected final Set<E> set;

    public static <E> SetUniqueList<E> decorate(List<E> list) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        if (list.isEmpty()) {
            return new SetUniqueList<E>(list, new HashSet());
        }
        ArrayList<E> temp = new ArrayList<E>(list);
        list.clear();
        SetUniqueList<E> sl = new SetUniqueList<E>(list, new HashSet());
        sl.addAll(temp);
        return sl;
    }

    protected SetUniqueList(List<E> list, Set<E> set) {
        super(list);
        if (set == null) {
            throw new IllegalArgumentException("Set must not be null");
        }
        this.set = set;
    }

    public Set<E> asSet() {
        return UnmodifiableSet.decorate(this.set);
    }

    @Override
    public boolean add(E object) {
        int sizeBefore = this.size();
        this.add(this.size(), object);
        return sizeBefore != this.size();
    }

    @Override
    public void add(int index, E object) {
        if (!this.set.contains(object)) {
            super.add(index, object);
            this.set.add(object);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        return this.addAll(this.size(), coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        int sizeBefore = this.size();
        Iterator<E> it = coll.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return sizeBefore != this.size();
    }

    @Override
    public E set(int index, E object) {
        int pos = this.indexOf(object);
        E result = super.set(index, object);
        if (pos == -1 || pos == index) {
            return result;
        }
        return this.remove(pos);
    }

    @Override
    public boolean remove(Object object) {
        boolean result = super.remove(object);
        this.set.remove(object);
        return result;
    }

    @Override
    public E remove(int index) {
        Object result = super.remove(index);
        this.set.remove(result);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean result = super.removeAll(coll);
        this.set.removeAll(coll);
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean result = super.retainAll(coll);
        this.set.retainAll(coll);
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.set.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.set.containsAll(coll);
    }

    @Override
    public Iterator<E> iterator() {
        return new SetListIterator(super.iterator(), this.set);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new SetListListIterator(super.listIterator(), this.set);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new SetListListIterator(super.listIterator(index), this.set);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new SetUniqueList(super.subList(fromIndex, toIndex), this.set);
    }

    static class SetListListIterator<E>
    extends AbstractListIteratorDecorator<E> {
        protected final Set<E> set;
        protected E last = null;

        protected SetListListIterator(ListIterator<E> it, Set<E> set) {
            super(it);
            this.set = set;
        }

        @Override
        public E next() {
            this.last = super.next();
            return this.last;
        }

        @Override
        public E previous() {
            this.last = super.previous();
            return this.last;
        }

        @Override
        public void remove() {
            super.remove();
            this.set.remove(this.last);
            this.last = null;
        }

        @Override
        public void add(E object) {
            if (!this.set.contains(object)) {
                super.add(object);
                this.set.add(object);
            }
        }

        @Override
        public void set(E object) {
            throw new UnsupportedOperationException("ListIterator does not support set");
        }
    }

    static class SetListIterator<E>
    extends AbstractIteratorDecorator<E> {
        protected final Set<E> set;
        protected E last = null;

        protected SetListIterator(Iterator<E> it, Set<E> set) {
            super(it);
            this.set = set;
        }

        @Override
        public E next() {
            this.last = super.next();
            return this.last;
        }

        @Override
        public void remove() {
            super.remove();
            this.set.remove(this.last);
            this.last = null;
        }
    }
}

