/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.util.HashMap;
import java.util.List;
import lcmc.data.Host;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class LVM {
    private static final String SIZE_PH = "@SIZE@";
    private static final String DEVICE_PH = "@DEVICE@";
    private static final String LV_NAME_PH = "@LVNAME@";
    private static final String VG_NAME_PH = "@VGNAME@";
    private static final String PV_NAMES_PH = "@PVNAMES@";

    private LVM() {
    }

    private static SSH.SSHOutput execCommand(Host host, String command, boolean outputVisible, boolean testOnly) {
        return Tools.execCommandProgressIndicator(host, command, null, outputVisible, Tools.getString("LVM.ExecutingCommand") + " " + command.replaceAll("@DMCSUDO@", " ") + "...", SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    public static boolean resize(Host host, String blockDevice, String size, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put(SIZE_PH, size);
        replaceHash.put(DEVICE_PH, blockDevice);
        String command = host.getDistCommand("LVM.resize", replaceHash);
        SSH.SSHOutput ret = LVM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean pvCreate(Host host, String blockDevice, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put(DEVICE_PH, blockDevice);
        String command = host.getDistCommand("LVM.pvcreate", replaceHash);
        SSH.SSHOutput ret = LVM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean pvRemove(Host host, String blockDevice, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put(DEVICE_PH, blockDevice);
        String command = host.getDistCommand("LVM.pvremove", replaceHash);
        SSH.SSHOutput ret = LVM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean vgRemove(Host host, String vgName, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put(VG_NAME_PH, vgName);
        String command = host.getDistCommand("LVM.vgremove", replaceHash);
        SSH.SSHOutput ret = LVM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean lvRemove(Host host, String blockDevice, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put(DEVICE_PH, blockDevice);
        String command = host.getDistCommand("LVM.lvremove", replaceHash);
        SSH.SSHOutput ret = LVM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean lvCreate(Host host, String lvName, String vgName, String size, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put(SIZE_PH, size);
        replaceHash.put(LV_NAME_PH, lvName);
        replaceHash.put(VG_NAME_PH, vgName);
        String command = host.getDistCommand("LVM.lvcreate", replaceHash);
        SSH.SSHOutput ret = LVM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean vgCreate(Host host, String vgName, List<String> pvNames, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put(PV_NAMES_PH, Tools.join(" ", pvNames));
        replaceHash.put(VG_NAME_PH, vgName);
        String command = host.getDistCommand("LVM.vgcreate", replaceHash);
        SSH.SSHOutput ret = LVM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean lvSnapshot(Host host, String snapshotName, String device, String size, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put(SIZE_PH, size);
        replaceHash.put(DEVICE_PH, device);
        replaceHash.put(LV_NAME_PH, snapshotName);
        String command = host.getDistCommand("LVM.lvsnapshot", replaceHash);
        SSH.SSHOutput ret = LVM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }
}

