/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import lcmc.data.Host;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class Heartbeat {
    private static final String HA_CONF_DIR = "/etc/ha.d/";
    private static final String HA_CONF_NAME = "ha.cf";
    private static final String HA_CONF_PERMS = "0600";
    private static final String AUTHKEYS_CONF_NAME = "authkeys";
    private static final String AUTHKEYS_CONF_PERMS = "0600";

    private Heartbeat() {
    }

    private static void execCommand(Host host, String command, boolean outputVisible) {
        Tools.execCommandProgressIndicator(host, command, null, outputVisible, Tools.getString("Heartbeat.ExecutingCommand"), 180000);
    }

    public static void startHeartbeat(Host host) {
        String command = host.getDistCommand("Heartbeat.startHeartbeat", (ConvertCmdCallback)null);
        Heartbeat.execCommand(host, command, true);
    }

    public static void stopHeartbeat(Host host) {
        String command = host.getDistCommand("Heartbeat.stopHeartbeat", (ConvertCmdCallback)null);
        Heartbeat.execCommand(host, command, true);
    }

    public static void startHeartbeatRc(Host host) {
        String command = host.getDistCommand("Heartbeat.startHeartbeat;;;Heartbeat.addToRc", (ConvertCmdCallback)null);
        Heartbeat.execCommand(host, command, true);
    }

    public static void switchFromCorosyncToHeartbeat(Host host) {
        String command = host.getDistCommand("Corosync.deleteFromRc;;;Heartbeat.addToRc;;;Heartbeat.startHeartbeat", (ConvertCmdCallback)null);
        Heartbeat.execCommand(host, command, true);
    }

    public static void switchFromOpenaisToHeartbeat(Host host) {
        String command = host.getDistCommand("Openais.deleteFromRc;;;Heartbeat.addToRc;;;Heartbeat.startHeartbeat", (ConvertCmdCallback)null);
        Heartbeat.execCommand(host, command, true);
    }

    public static void addHeartbeatToRc(Host host) {
        String command = host.getDistCommand("Heartbeat.addToRc", (ConvertCmdCallback)null);
        Heartbeat.execCommand(host, command, true);
    }

    public static void reloadHeartbeat(Host host) {
        String command = host.getDistCommand("Heartbeat.reloadHeartbeat", (ConvertCmdCallback)null);
        Heartbeat.execCommand(host, command, true);
    }

    public static void createHBConfig(Host[] hosts, StringBuilder config) {
        Tools.createConfigOnAllHosts(hosts, config.toString(), HA_CONF_NAME, HA_CONF_DIR, "0600", true);
        StringBuilder authkeys = new StringBuilder("## generated by drbd-gui\n\nauth 1\n1 sha1 ");
        authkeys.append(Tools.getRandomSecret(32));
        authkeys.append('\n');
        Tools.createConfigOnAllHosts(hosts, authkeys.toString(), AUTHKEYS_CONF_NAME, HA_CONF_DIR, "0600", true);
    }

    public static void reloadHeartbeats(Host[] hosts) {
        for (Host host : hosts) {
            Heartbeat.reloadHeartbeat(host);
        }
    }

    public static void enableDopd(Host host, boolean workAround) {
        String cmd = workAround ? "Heartbeat.dopdWorkaround;;;Heartbeat.enableDopd" : "Heartbeat.enableDopd";
        SSH.ExecCommandThread t = host.execCommand(cmd, null, null, true, SSH.DEFAULT_COMMAND_TIMEOUT);
        try {
            t.join();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }
}

