/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import javax.swing.ImageIcon;
import lcmc.data.resources.BlockDevice;
import lcmc.data.resources.CommonBlockDevice;
import lcmc.gui.Browser;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.CommonDeviceInterface;
import lcmc.gui.resources.HbCategoryInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.utilities.Tools;

public final class CommonBlockDevInfo
extends HbCategoryInfo
implements CommonDeviceInterface {
    private final BlockDevice[] blockDevices;

    public CommonBlockDevInfo(String name, BlockDevice[] blockDevices, Browser browser) {
        super(name, browser);
        this.setResource(new CommonBlockDevice(name));
        this.blockDevices = blockDevices;
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return BlockDevInfo.HARDDISK_ICON;
    }

    @Override
    public String getDevice() {
        return this.getCommonBlockDevice().getDevice();
    }

    @Override
    String getInfo() {
        return "Device    : " + this.getCommonBlockDevice().getName() + "\n";
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (name == null || "".equals(name)) {
            name = Tools.getString("ClusterBrowser.CommonBlockDevUnconfigured");
        }
        return name;
    }

    @Override
    public void setUsedByCRM(ServiceInfo isUsedByCRM) {
        for (BlockDevice bd : this.blockDevices) {
            bd.setUsedByCRM(isUsedByCRM != null);
        }
    }

    @Override
    public boolean isUsedByCRM() {
        boolean is = true;
        for (int i = 0; i < this.blockDevices.length; ++i) {
            is = is && this.blockDevices[i].isUsedByCRM();
        }
        return is;
    }

    CommonBlockDevice getCommonBlockDevice() {
        return (CommonBlockDevice)this.getResource();
    }

    @Override
    public String getCreatedFs() {
        return null;
    }

    @Override
    public int getUsed() {
        int used = -1;
        for (BlockDevice bd : this.blockDevices) {
            if (bd.getUsed() <= used) continue;
            used = bd.getUsed();
        }
        return used;
    }
}

