/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.dialog.host.DrbdLinbitInst;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.Tools;

public class LinbitLogin
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private Widget downloadUserField;
    private Widget downloadPasswordField;
    private JCheckBox saveCheckBox;
    private static final int CHECKBOX_WIDTH = 120;

    public LinbitLogin(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    @Override
    protected final void finishDialog() {
        Tools.getConfigData().setDownloadLogin(this.downloadUserField.getStringValue().trim(), this.downloadPasswordField.getStringValue().trim(), this.saveCheckBox.isSelected());
    }

    @Override
    public WizardDialog nextDialog() {
        return new DrbdLinbitInst(this, this.getHost());
    }

    protected final void checkFields() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean v = LinbitLogin.this.downloadUserField.getStringValue().trim().length() > 0;
                LinbitLogin.this.buttonClass(LinbitLogin.this.nextButton()).setEnabled(v &= LinbitLogin.this.downloadPasswordField.getStringValue().trim().length() > 0);
            }
        });
    }

    @Override
    protected final void checkFields(Widget field) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean v = LinbitLogin.this.downloadUserField.getStringValue().trim().length() > 0;
                LinbitLogin.this.buttonClass(LinbitLogin.this.nextButton()).setEnabled(v &= LinbitLogin.this.downloadPasswordField.getStringValue().trim().length() > 0);
            }
        });
    }

    @Override
    protected final String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.LinbitLogin.Title");
    }

    @Override
    protected final String getDescription() {
        return Tools.getString("Dialog.Host.LinbitLogin.Description");
    }

    @Override
    protected final void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        this.checkFields();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LinbitLogin.this.downloadUserField.requestFocus();
            }
        });
        if (Tools.getConfigData().getAutoOptionHost("drbdinst") != null) {
            Tools.sleep(1000);
            this.pressNextButton();
        }
    }

    @Override
    protected final JComponent getInputPane() {
        JPanel p = new JPanel(new BorderLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        inputPane.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
        JLabel userLabel = new JLabel(Tools.getString("Dialog.Host.LinbitLogin.EnterUser"));
        inputPane.add(userLabel);
        this.downloadUserField = WidgetFactory.createInstance(Widget.GUESS_TYPE, Tools.getConfigData().getDownloadUser(), Widget.NO_ITEMS, "^[,\\w.-]+$", 120, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.addCheckField(this.downloadUserField);
        userLabel.setLabelFor(this.downloadUserField);
        inputPane.add(this.downloadUserField);
        JLabel passwordLabel = new JLabel(Tools.getString("Dialog.Host.LinbitLogin.EnterPassword"));
        inputPane.add(passwordLabel);
        this.downloadPasswordField = WidgetFactory.createInstance(Widget.Type.PASSWDFIELD, Tools.getConfigData().getDownloadPassword(), Widget.NO_ITEMS, Widget.NO_REGEXP, 120, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.addCheckField(this.downloadPasswordField);
        passwordLabel.setLabelFor(this.downloadPasswordField);
        inputPane.add(this.downloadPasswordField);
        JLabel saveLabel = new JLabel("");
        saveLabel.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
        inputPane.add(saveLabel);
        this.saveCheckBox = new JCheckBox(Tools.getString("Dialog.Host.LinbitLogin.Save"), Tools.getConfigData().getLoginSave());
        saveLabel.setLabelFor(this.saveCheckBox);
        this.saveCheckBox.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
        inputPane.add(this.saveCheckBox);
        SpringUtilities.makeCompactGrid(inputPane, 3, 2, 1, 1, 1, 1);
        p.add((Component)inputPane, "South");
        return p;
    }
}

