/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public abstract class ConfigDialog {
    private static final long serialVersionUID = 1L;
    private volatile JOptionPane optionPane;
    private JDialog dialogPanel;
    private String pressedButton = "";
    private final Map<String, MyButton> buttonToObjectMap = new HashMap<String, MyButton>();
    private final StringBuilder answerPaneText = new StringBuilder(100);
    private JEditorPane answerPane = null;
    private final List<JComponent> disabledComponents = new ArrayList<JComponent>();
    private static final int INPUT_PANE_HEIGHT = 200;
    private CountDownLatch dialogGate;
    private JCheckBox skipButton = null;
    private volatile Object optionPaneAnswer;
    private boolean skipButtonShouldBeEnabled = true;
    private final MyButton[] options = new MyButton[this.buttons().length];
    private final List<JComponent> additionalOptions = new ArrayList<JComponent>();

    protected final JDialog getDialogPanel() {
        return this.dialogPanel;
    }

    final void setDialogPanel(JDialog dialogPanel) {
        this.dialogPanel = dialogPanel;
    }

    final Point getLocation() {
        return this.dialogPanel.getLocation();
    }

    protected abstract String getDialogTitle();

    protected abstract String getDescription();

    protected abstract JComponent getInputPane();

    protected final JOptionPane getOptionPane() {
        return this.optionPane;
    }

    protected final JScrollPane getAnswerPane(String initialText) {
        this.answerPane = new JEditorPane("text/plain", initialText);
        this.answerPane.setBackground(Tools.getDefaultColor("ConfigDialog.AnswerPane"));
        this.answerPane.setForeground(Color.WHITE);
        this.answerPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.answerPane);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 80));
        scrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, 80));
        return scrollPane;
    }

    protected final void answerPaneSetText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int l = ConfigDialog.this.answerPaneText.length();
                if (l > 1) {
                    ConfigDialog.this.answerPaneText.delete(0, l);
                }
                ConfigDialog.this.answerPaneText.append(text);
                ConfigDialog.this.answerPane.setText(ConfigDialog.this.answerPaneText.toString());
            }
        });
    }

    protected final void answerPaneAddText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigDialog.this.answerPaneText.append('\n');
                ConfigDialog.this.answerPaneText.append(text);
                ConfigDialog.this.answerPaneSetText(ConfigDialog.this.answerPaneText.toString());
            }
        });
    }

    protected final void answerPaneSetTextError(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigDialog.this.answerPane.setForeground(Tools.getDefaultColor("ConfigDialog.AnswerPane.Error"));
                int l = ConfigDialog.this.answerPaneText.length();
                if (l > 1) {
                    ConfigDialog.this.answerPaneText.delete(0, l);
                }
                ConfigDialog.this.answerPaneText.append(text);
                ConfigDialog.this.answerPane.setText(ConfigDialog.this.answerPaneText.toString());
            }
        });
    }

    protected final void answerPaneAddTextError(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigDialog.this.answerPaneText.append('\n');
                ConfigDialog.this.answerPaneText.append(text);
                ConfigDialog.this.answerPaneSetTextError(ConfigDialog.this.answerPaneText.toString());
            }
        });
    }

    protected final JPanel body() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        JEditorPane descPane = new JEditorPane("text/html", "<span style='font:bold italic;font-family:Dialog; font-size:" + Tools.getConfigData().scaled(14) + ";'>" + this.getDialogTitle() + "</span><br>" + "<span style='font-family:Dialog; font-size:" + Tools.getConfigData().scaled(12) + ";'>" + this.getDescription() + "</span>");
        descPane.setSize(300, Integer.MAX_VALUE);
        descPane.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
        descPane.setEditable(false);
        JScrollPane descSP = new JScrollPane(descPane);
        descSP.setBorder(null);
        descSP.setAlignmentX(0.0f);
        descSP.setMinimumSize(new Dimension(0, 50));
        pane.add(descSP);
        JComponent inputPane = this.getInputPane();
        if (inputPane != null) {
            inputPane.setMinimumSize(new Dimension(Short.MAX_VALUE, 200));
            inputPane.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
            inputPane.setAlignmentX(0.0f);
            pane.add(inputPane);
        }
        pane.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
        return pane;
    }

    protected ImageIcon icon() {
        return Tools.createImageIcon(Tools.getDefault("ConfigDialog.Icon"));
    }

    protected String[] buttons() {
        return new String[]{this.okButton()};
    }

    protected ImageIcon[] getIcons() {
        return new ImageIcon[]{null};
    }

    protected String defaultButton() {
        return this.okButton();
    }

    public final boolean isPressedButton(String button) {
        return this.pressedButton.equals(button);
    }

    protected final void setPressedButton(String button) {
        this.pressedButton = button;
    }

    final String okButton() {
        return this.buttonString("Ok");
    }

    protected String cancelButton() {
        return this.buttonString("Cancel");
    }

    protected final String buttonString(String b) {
        return Tools.getString("Dialog.Dialog." + b);
    }

    protected final MyButton buttonClass(String button) {
        return this.buttonToObjectMap.get(button);
    }

    protected void initDialog() {
    }

    protected void initDialogAfterVisible() {
    }

    protected void checkFields(Widget field) {
    }

    protected final void addCheckField(final Widget field) {
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ConfigDialog.this.checkFields(field);
                    }
                });
                t.start();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ConfigDialog.this.checkFields(field);
                    }
                });
                t.start();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ConfigDialog.this.checkFields(field);
                    }
                });
                t.start();
            }
        });
    }

    protected ConfigDialog checkAnswer() {
        return null;
    }

    protected int dialogWidth() {
        return Tools.getDefaultInt("ConfigDialog.width");
    }

    protected int dialogHeight() {
        return Tools.getDefaultInt("ConfigDialog.height");
    }

    protected int getMessageType() {
        return 1;
    }

    protected boolean skipButtonEnabled() {
        return false;
    }

    protected ItemListener skipButtonListener() {
        return null;
    }

    protected final boolean skipButtonIsSelected() {
        if (this.skipButton != null) {
            return this.skipButton.isSelected();
        }
        return false;
    }

    protected final void skipButtonSetEnabled(boolean enable) {
        this.skipButtonShouldBeEnabled = enable;
    }

    public final ConfigDialog showDialog() {
        this.dialogGate = new CountDownLatch(1);
        this.dialogPanel = null;
        if (this.dialogPanel == null) {
            ImageIcon[] icons = this.getIcons();
            MyButton defaultButtonClass = null;
            final ArrayList<JComponent> allOptions = new ArrayList<JComponent>(this.additionalOptions);
            if (this.skipButtonEnabled()) {
                this.skipButton = new JCheckBox(Tools.getString("Dialog.ConfigDialog.SkipButton"));
                this.skipButton.setEnabled(false);
                this.skipButton.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
                this.skipButton.addItemListener(this.skipButtonListener());
                allOptions.add(this.skipButton);
            }
            String[] buttons = this.buttons();
            for (int i = 0; i < buttons.length; ++i) {
                this.options[i] = new MyButton(buttons[i], icons[i]);
                this.options[i].setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
                allOptions.add(this.options[i]);
                this.buttonToObjectMap.put(buttons[i], this.options[i]);
                if (!buttons[i].equals(this.defaultButton())) continue;
                defaultButtonClass = this.options[i];
            }
            final JPanel b = this.body();
            final MyButton dbc = defaultButtonClass;
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ConfigDialog.this.optionPane = new JOptionPane(b, ConfigDialog.this.getMessageType(), -1, ConfigDialog.this.icon(), allOptions.toArray(new JComponent[allOptions.size()]), dbc);
                    ConfigDialog.this.optionPane.setPreferredSize(new Dimension(ConfigDialog.this.dialogWidth(), ConfigDialog.this.dialogHeight()));
                    ConfigDialog.this.optionPane.setMaximumSize(new Dimension(ConfigDialog.this.dialogWidth(), ConfigDialog.this.dialogHeight()));
                    ConfigDialog.this.optionPane.setMinimumSize(new Dimension(ConfigDialog.this.dialogWidth(), ConfigDialog.this.dialogHeight()));
                    ConfigDialog.this.optionPane.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Dark"));
                    Container mainFrame = Tools.getGUIData().getMainFrame();
                    if (mainFrame instanceof JApplet) {
                        JFrame noframe = new JFrame();
                        ConfigDialog.this.dialogPanel = new JDialog(noframe);
                        ConfigDialog.this.dialogPanel.setContentPane(ConfigDialog.this.optionPane);
                    } else {
                        ConfigDialog.this.dialogPanel = new JDialog((JFrame)mainFrame);
                        ConfigDialog.this.dialogPanel.setContentPane(ConfigDialog.this.optionPane);
                    }
                    ConfigDialog.this.dialogPanel.setModal(false);
                    ConfigDialog.this.dialogPanel.setResizable(true);
                }
            });
        }
        HashMap<MyButton, OptionPaneActionListener> optionPaneActionListeners = new HashMap<MyButton, OptionPaneActionListener>();
        for (MyButton o : this.options) {
            OptionPaneActionListener ol = new OptionPaneActionListener();
            optionPaneActionListeners.put(o, ol);
            o.addActionListener(ol);
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("value".equals(evt.getPropertyName()) && !"uninitializedValue".equals(evt.getNewValue())) {
                    ConfigDialog.this.optionPaneAnswer = ConfigDialog.this.optionPane.getValue();
                    ConfigDialog.this.dialogGate.countDown();
                }
            }
        };
        this.optionPane.addPropertyChangeListener(propertyChangeListener);
        this.initDialog();
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ConfigDialog.this.dialogPanel.setPreferredSize(new Dimension(ConfigDialog.this.dialogWidth(), ConfigDialog.this.dialogHeight()));
                ConfigDialog.this.dialogPanel.setMaximumSize(new Dimension(ConfigDialog.this.dialogWidth(), ConfigDialog.this.dialogHeight()));
                ConfigDialog.this.dialogPanel.setMinimumSize(new Dimension(ConfigDialog.this.dialogWidth(), ConfigDialog.this.dialogHeight()));
                ConfigDialog.this.dialogPanel.setLocationRelativeTo(Tools.getGUIData().getMainFrame());
                ConfigDialog.this.dialogPanel.setVisible(true);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigDialog.this.dialogPanel.setLocationRelativeTo(Tools.getGUIData().getMainFrameContentPane());
            }
        });
        this.initDialogAfterVisible();
        try {
            this.dialogGate.await();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        if (this.optionPaneAnswer instanceof String) {
            this.setPressedButton((String)this.optionPaneAnswer);
        } else {
            this.setPressedButton(this.cancelButton());
        }
        this.optionPane.removePropertyChangeListener(propertyChangeListener);
        for (MyButton o : this.options) {
            o.removeActionListener((ActionListener)optionPaneActionListeners.get(o));
        }
        this.dialogPanel.dispose();
        return this.checkAnswer();
    }

    protected final void disableComponents(final JComponent[] components) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String b : ConfigDialog.this.buttons()) {
                    MyButton option = ConfigDialog.this.buttonClass(b);
                    if (!option.isEnabled()) continue;
                    ConfigDialog.this.disabledComponents.add(option);
                    ((JComponent)option).setEnabled(false);
                }
                for (JComponent c : components) {
                    if (!c.isEnabled()) continue;
                    ConfigDialog.this.disabledComponents.add(c);
                    c.setEnabled(false);
                }
            }
        });
    }

    protected final void disableComponents() {
        this.disableComponents(new JComponent[0]);
    }

    protected void enableComponents(JComponent[] componentsToDisable) {
        final HashSet<JComponent> ctdHash = new HashSet<JComponent>(Arrays.asList(componentsToDisable));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (JComponent dc : ConfigDialog.this.disabledComponents) {
                    if (ctdHash.contains(dc)) continue;
                    dc.setEnabled(true);
                }
                ConfigDialog.this.disabledComponents.clear();
                if (ConfigDialog.this.skipButton != null) {
                    ConfigDialog.this.skipButton.setEnabled(ConfigDialog.this.skipButtonShouldBeEnabled);
                }
            }
        });
    }

    protected void enableComponentsLater(JComponent[] componentsToEnable) {
        for (JComponent c : componentsToEnable) {
            this.disabledComponents.add(c);
        }
    }

    protected void enableComponents() {
        this.enableComponents(new JComponent[0]);
    }

    public void cancelDialog() {
    }

    protected final JPanel getComponentPanel(String text, JComponent component) {
        JPanel mp = new JPanel(new FlowLayout(0, 0, 0));
        mp.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
        mp.add(new JLabel(text));
        mp.add(new JLabel(" "));
        mp.add(component);
        mp.setAlignmentX(0.0f);
        return mp;
    }

    protected final void disposeDialog() {
        this.dialogGate.countDown();
    }

    protected final void addToOptions(JComponent c) {
        this.additionalOptions.add(c);
    }

    class OptionPaneActionListener
    implements ActionListener {
        OptionPaneActionListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent event) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ConfigDialog.this.optionPane.setValue(((JButton)event.getSource()).getText());
                        }
                    });
                }
            });
            t.start();
        }
    }
}

