/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.util.Map;
import java.util.StringTokenizer;
import lcmc.Exceptions;
import lcmc.utilities.Tools;

public final class DrbdProxy {
    public static final boolean PROXY = true;
    private static final boolean DONE = true;
    public static final String PLUGIN_PREFIX = "plugin-";

    private DrbdProxy() {
    }

    static boolean parse(String text, Map<String, String> nameValueMap) throws Exceptions.DrbdConfigException {
        StringTokenizer st = new StringTokenizer(text);
        while (st.hasMoreTokens()) {
            if (!"proxy".equals(st.nextToken())) continue;
            Tools.debug(null, "proxy: " + text, 1);
            String nextToken = st.nextToken();
            if (!"{".equals(nextToken)) {
                throw new Exceptions.DrbdConfigException("proxy config: unexpected token: " + nextToken + "/'{'");
            }
            while (st.hasMoreTokens()) {
                boolean done = DrbdProxy.parseStatement("", st, nameValueMap);
                if (!done) continue;
                return true;
            }
            throw new Exceptions.DrbdConfigException("proxy config: parsing error");
        }
        return false;
    }

    private static void parsePlugin(StringTokenizer st, Map<String, String> nameValueMap) throws Exceptions.DrbdConfigException {
        String nextToken = st.nextToken();
        if (!"{".equals(nextToken)) {
            throw new Exceptions.DrbdConfigException("proxy plugin config: unexpected token: " + nextToken + "/'{'");
        }
        while (st.hasMoreTokens()) {
            boolean done = DrbdProxy.parseStatement(PLUGIN_PREFIX, st, nameValueMap);
            if (!done) continue;
            return;
        }
        throw new Exceptions.DrbdConfigException("proxy plugin config: parsing error");
    }

    private static boolean parseStatement(String prefix, StringTokenizer st, Map<String, String> nameValueMap) throws Exceptions.DrbdConfigException {
        String nextToken = st.nextToken();
        if ("plugin".equals(nextToken)) {
            DrbdProxy.parsePlugin(st, nameValueMap);
            return false;
        }
        if ("}".equals(nextToken)) {
            return true;
        }
        if (DrbdProxy.endOfStatement(nextToken)) {
            String param = nextToken.substring(0, nextToken.length() - 1);
            String value = "yes";
            nameValueMap.put(prefix + param, "yes");
            return false;
        }
        String param = nextToken;
        String value = null;
        boolean eos = false;
        while (st.hasMoreTokens() && !eos) {
            nextToken = st.nextToken();
            if (DrbdProxy.endOfStatement(nextToken)) {
                eos = true;
                nextToken = nextToken.substring(0, nextToken.length() - 1);
            }
            value = value == null ? nextToken : value + " " + nextToken;
            if (!eos) continue;
        }
        nameValueMap.put(prefix + param, value);
        if (!eos) {
            throw new Exceptions.DrbdConfigException("proxy config: statement error");
        }
        return false;
    }

    private static boolean endOfStatement(String token) {
        if (token == null) {
            return false;
        }
        return token.endsWith(";");
    }
}

