/*
 * Decompiled with CFR 0.152.
 */
import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

public class BufferTasks
extends FJTask {
    static int niters = 65536;
    static int[] pairs = new int[]{1, 2, 4, 8, 16, 32, 64};
    static int[] sizes = new int[]{1024, 64, 1};
    int callbackCount;
    Buffer buffer;

    public static void main(String[] args) {
        try {
            int procs;
            try {
                procs = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                System.out.println("Usage: java BufferTasks <threads>");
                return;
            }
            System.out.print("pairs:");
            for (int p = 0; p < pairs.length; ++p) {
                System.out.print("\t" + pairs[p]);
            }
            System.out.print("\n");
            FJTaskRunnerGroup g = new FJTaskRunnerGroup(procs);
            g.invoke(new BufferTasks());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        for (int s = 0; s < sizes.length; ++s) {
            System.out.println("cap: " + sizes[s]);
            for (int p = 0; p < pairs.length; ++p) {
                this.buffer = new Buffer(sizes[s]);
                int npairs = pairs[p];
                int iters = niters / npairs;
                long startTime = System.currentTimeMillis();
                this.setCallbackCount(npairs * 2);
                for (int k = 0; k < npairs; ++k) {
                    new Producer(iters).fork();
                    new Consumer(iters).fork();
                }
                while (!this.checkDone()) {
                    BufferTasks.yield();
                }
                long now = System.currentTimeMillis();
                long time = now - startTime;
                long tpi = time * 1000L / (long)(npairs * niters);
                System.out.print("\t" + tpi);
            }
            System.out.print("\n");
            BufferTasks.getFJTaskRunnerGroup().stats();
        }
    }

    synchronized void notifyDone() {
        --this.callbackCount;
    }

    synchronized void setCallbackCount(int c) {
        this.callbackCount = c;
    }

    synchronized boolean checkDone() {
        return this.callbackCount == 0;
    }

    static class NonBlockingSemaphore {
        private long permits_;

        public NonBlockingSemaphore(long initialPermits) {
            this.permits_ = initialPermits;
        }

        public synchronized boolean attempt() {
            if (this.permits_ > 0L) {
                --this.permits_;
                return true;
            }
            return false;
        }

        public synchronized void release() {
            ++this.permits_;
        }
    }

    static class Buffer {
        protected Object[] array_;
        protected int putPtr_ = 0;
        protected int takePtr_ = 0;
        final NonBlockingSemaphore putPermits;
        final NonBlockingSemaphore takePermits;

        public Buffer(int capacity) {
            this.putPermits = new NonBlockingSemaphore(capacity);
            this.takePermits = new NonBlockingSemaphore(0L);
            this.array_ = new Object[capacity];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(Object x) {
            if (!this.putPermits.attempt()) {
                return false;
            }
            Buffer buffer = this;
            synchronized (buffer) {
                this.array_[this.putPtr_] = x;
                if (++this.putPtr_ == this.array_.length) {
                    this.putPtr_ = 0;
                }
            }
            this.takePermits.release();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll() {
            Object x;
            if (!this.takePermits.attempt()) {
                return null;
            }
            Buffer buffer = this;
            synchronized (buffer) {
                x = this.array_[this.takePtr_];
                this.array_[this.takePtr_] = null;
                if (++this.takePtr_ == this.array_.length) {
                    this.takePtr_ = 0;
                }
            }
            this.putPermits.release();
            return x;
        }
    }

    class Consumer
    extends FJTask {
        final int iters;

        Consumer(int n) {
            this.iters = n;
        }

        @Override
        public void run() {
            for (int n = this.iters; n > 0; --n) {
                if (BufferTasks.this.buffer.poll() != null) continue;
                Consumer.yield();
                new Consumer(n).start();
                return;
            }
            BufferTasks.this.notifyDone();
        }
    }

    class Producer
    extends FJTask {
        final int iters;

        Producer(int n) {
            this.iters = n;
        }

        @Override
        public void run() {
            for (int n = this.iters; n > 0; --n) {
                if (BufferTasks.this.buffer.offer(new Integer(n))) continue;
                Producer.yield();
                new Producer(n).start();
                return;
            }
            BufferTasks.this.notifyDone();
        }
    }
}

