/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.uploader;

import com.google.gdata.client.uploader.ResumableHttpFileUploader;
import com.google.gdata.client.uploader.UploadData;
import com.google.gdata.client.uploader.UrlConnectionFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ResumableHttpUploadTask
implements Callable<ResumableHttpFileUploader.ResponseMessage> {
    private final ResumableHttpFileUploader uploader;
    private final boolean resume;
    private final UrlConnectionFactory urlConnectionFactory;
    private static final String CONTENT_LENGTH_HEADER_NAME = "Content-Length";
    private static final String CONTENT_RANGE_HEADER_NAME = "Content-Range";

    public ResumableHttpUploadTask(UrlConnectionFactory urlConnectionFactory, ResumableHttpFileUploader uploader, boolean resume) {
        this.urlConnectionFactory = urlConnectionFactory;
        this.uploader = uploader;
        this.resume = resume;
    }

    @Override
    public ResumableHttpFileUploader.ResponseMessage call() throws Exception {
        return this.upload();
    }

    private long getNextStartByteFromServer() throws IOException {
        HttpURLConnection connection = this.urlConnectionFactory.create(this.uploader.getUrl());
        connection.setRequestMethod(this.uploader.getHttpRequestMethod().toString());
        connection.setRequestProperty(CONTENT_LENGTH_HEADER_NAME, "0");
        connection.connect();
        if (connection.getResponseCode() != 308) {
            return 0L;
        }
        return this.getNextByteIndexFromRangeHeader(connection.getHeaderField("Range"));
    }

    private long getNextByteIndexFromRangeHeader(String rangeHeader) {
        if (rangeHeader == null || rangeHeader.indexOf(45) == -1) {
            return 0L;
        }
        Matcher rangeMatcher = Pattern.compile("[0-9]+-[0-9]+").matcher(rangeHeader);
        if (!rangeMatcher.find(1)) {
            return 0L;
        }
        try {
            String[] rangeParts = rangeMatcher.group().split("-");
            long firstByteIndex = Long.parseLong(rangeParts[0]);
            if (firstByteIndex != 0L) {
                return 0L;
            }
            long lastByteIndex = Long.parseLong(rangeParts[1]);
            this.uploader.setNumBytesUploaded(lastByteIndex + 1L);
            return lastByteIndex + 1L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private void setHeaders(HttpURLConnection conn, long start, long length) {
        long fileSize = this.uploader.getData().length();
        conn.setRequestProperty(CONTENT_LENGTH_HEADER_NAME, String.valueOf(length));
        String contentRange = "bytes " + (fileSize == 0L ? "*/0" : start + "-" + (start + length - 1L) + "/" + String.valueOf(fileSize));
        conn.setRequestProperty(CONTENT_RANGE_HEADER_NAME, contentRange);
        for (Map.Entry<String, String> header : this.uploader.getHeaders().entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
    }

    private ResumableHttpFileUploader.ResponseMessage upload() throws IOException {
        long start;
        long l = start = this.resume ? this.getNextStartByteFromServer() : 0L;
        block9: while (this.uploader.getUploadState().equals((Object)ResumableHttpFileUploader.UploadState.IN_PROGRESS)) {
            long length = Math.min(this.uploader.getData().length() - start, this.uploader.getChunkSize());
            HttpURLConnection connection = this.urlConnectionFactory.create(this.uploader.getUrl());
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod(this.uploader.getHttpRequestMethod().toString());
            this.setHeaders(connection, start, length);
            OutputStream out = connection.getOutputStream();
            try {
                this.writeSlice(start, length, out);
                out.close();
                switch (connection.getResponseCode()) {
                    case 308: {
                        String range = connection.getHeaderField("Range");
                        start = range != null ? this.getNextByteIndexFromRangeHeader(range) : (start += length);
                        String location = connection.getHeaderField("Location");
                        if (location != null) {
                            this.uploader.setUrl(new URL(location));
                        }
                        this.uploader.getBackoffPolicy().reset();
                        break;
                    }
                    case 503: {
                        if (this.uploader.isPaused()) continue block9;
                        start = this.getNextStartByteFromServer();
                        this.uploader.addNumBytesUploaded(-length);
                        try {
                            long backoffMs = this.uploader.getBackoffPolicy().getNextBackoffMs();
                            if (backoffMs == -1L) {
                                this.uploader.pause();
                                break;
                            }
                            Thread.sleep(backoffMs);
                        }
                        catch (InterruptedException e) {}
                        break;
                    }
                    default: {
                        this.uploader.setUploadState(ResumableHttpFileUploader.UploadState.COMPLETE);
                        this.uploader.sendCompletionNotification();
                        this.uploader.getBackoffPolicy().reset();
                        return new ResumableHttpFileUploader.ResponseMessage(connection.getContentLength(), connection.getInputStream());
                    }
                }
            }
            catch (ServerException e) {
                if (this.uploader.isPaused()) continue;
                start = this.getNextStartByteFromServer();
            }
            catch (IOException e) {
                this.uploader.setUploadState(ResumableHttpFileUploader.UploadState.CLIENT_ERROR);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSlice(long start, long length, OutputStream out) throws IOException, ServerException {
        int numRead = 0;
        long numRemaining = length;
        byte[] chunk = new byte[65536];
        UploadData uploadData = this.uploader.getData();
        uploadData.setPosition(start);
        UploadData uploadData2 = uploadData;
        synchronized (uploadData2) {
            while (!this.uploader.isPaused()) {
                numRead = numRemaining < (long)chunk.length ? uploadData.read(chunk, 0, (int)numRemaining) : uploadData.read(chunk, 0, chunk.length);
                try {
                    if (numRead < 0) {
                        if (numRemaining <= 0L) break;
                        out.flush();
                        this.uploader.setUploadState(ResumableHttpFileUploader.UploadState.CLIENT_ERROR);
                        break;
                    }
                    out.write(chunk, 0, numRead);
                    out.flush();
                    this.uploader.addNumBytesUploaded(numRead);
                    if ((numRemaining -= (long)numRead) != 0L) continue;
                    break;
                }
                catch (IOException e) {
                    throw new ServerException();
                }
            }
        }
    }

    class ServerException
    extends Exception {
        ServerException() {
        }
    }
}

