/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.zidfile;

import gnu.java.zrtp.zidfile.ZidRecord;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;

public class ZidFile {
    private static final int IDENTIFIER_LENGTH = 12;
    private static final int ZID_RECORD_LENGTH = 128;
    private static ZidFile instance = null;
    private RandomAccessFile zidFile;
    private byte[] associatedZid = new byte[12];

    private ZidFile() {
    }

    public static synchronized ZidFile getInstance() {
        if (instance == null) {
            instance = new ZidFile();
        }
        return instance;
    }

    private void createZIDFile(String name) {
        try {
            this.zidFile = new RandomAccessFile(name, "rw");
        }
        catch (FileNotFoundException e) {
            this.zidFile = null;
            return;
        }
        if (this.zidFile != null) {
            Random ran = new Random();
            ran.nextBytes(this.associatedZid);
            ZidRecord rec = new ZidRecord();
            rec.setIdentifier(this.associatedZid);
            rec.setOwnZIDRecord();
            try {
                this.zidFile.seek(0L);
                this.zidFile.write(rec.getBuffer());
            }
            catch (IOException e) {
                try {
                    this.zidFile.close();
                }
                catch (IOException e1) {
                    this.zidFile = null;
                    return;
                }
                this.zidFile = null;
                return;
            }
        }
    }

    public synchronized int open(String name) {
        if (this.zidFile != null) {
            return 0;
        }
        File f = new File(name);
        if (f.exists()) {
            try {
                this.zidFile = new RandomAccessFile(f, "rw");
            }
            catch (FileNotFoundException e) {
                this.zidFile = null;
                return -1;
            }
        } else {
            this.createZIDFile(name);
        }
        if (this.zidFile != null) {
            ZidRecord rec = new ZidRecord();
            try {
                this.zidFile.seek(0L);
                this.zidFile.readFully(rec.getBuffer());
            }
            catch (IOException e) {
                try {
                    this.zidFile.close();
                }
                catch (IOException e1) {
                    this.zidFile = null;
                    return -1;
                }
                this.zidFile = null;
                return -1;
            }
            if (!rec.isOwnZIDRecord()) {
                try {
                    this.zidFile.close();
                }
                catch (IOException e) {
                    this.zidFile = null;
                    return -1;
                }
                this.zidFile = null;
                return -1;
            }
            rec.getIdentifierInto(this.associatedZid);
        }
        return this.zidFile == null ? -1 : 1;
    }

    public synchronized boolean isOpen() {
        return this.zidFile != null;
    }

    public synchronized void close() {
        if (this.zidFile != null) {
            try {
                this.zidFile.close();
            }
            catch (IOException e1) {
                this.zidFile = null;
                return;
            }
            this.zidFile = null;
        }
    }

    public synchronized ZidRecord getRecord(byte[] zid) {
        long pos = 0L;
        ZidRecord rec = new ZidRecord();
        boolean numRead = false;
        try {
            this.zidFile.seek(128L);
        }
        catch (IOException e2) {
            return null;
        }
        do {
            try {
                pos = this.zidFile.getFilePointer();
                this.zidFile.readFully(rec.getBuffer());
                numRead = true;
            }
            catch (EOFException e) {
                numRead = false;
            }
            catch (IOException e) {
                try {
                    this.zidFile.close();
                }
                catch (IOException e1) {
                    this.zidFile = null;
                    return null;
                }
            }
            if (!numRead) break;
            if (!rec.isOwnZIDRecord() && rec.isValid()) continue;
        } while (numRead && !rec.isSameIdentifier(zid));
        if (!numRead) {
            rec = new ZidRecord();
            rec.setIdentifier(zid);
            rec.setValid();
            try {
                pos = this.zidFile.getFilePointer();
                this.zidFile.write(rec.getBuffer());
            }
            catch (IOException e) {
                return null;
            }
        }
        rec.setPosition(pos);
        return rec;
    }

    public synchronized int saveRecord(ZidRecord zidRecord) {
        try {
            this.zidFile.seek(zidRecord.getPosition());
            this.zidFile.write(zidRecord.getBuffer());
        }
        catch (IOException e) {
            return -1;
        }
        return 1;
    }

    public synchronized byte[] getZid() {
        return this.associatedZid;
    }
}

