/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationPanel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SwingWorker;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.ChatLinkClickedListener;
import net.java.sip.communicator.service.gui.ConfigurationContainer;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.replacement.directimage.DirectImageReplacementService;
import net.java.sip.communicator.util.Logger;

public class ShowPreviewDialog
extends SIPCommDialog
implements ActionListener,
ChatLinkClickedListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ShowPreviewDialog.class);
    private final JButton okButton;
    private final JButton cancelButton;
    private final JCheckBox configureReplacement;
    private final ChatConversationPanel chatPanel;
    private Map<String, String> msgIDToChatString = new ConcurrentHashMap<String, String>();
    private Map<String, String> msgIDandPositionToLink = new ConcurrentHashMap<String, String>();
    private Map<String, String> linkToReplacement = new ConcurrentHashMap<String, String>();
    private String currentMessageID = "";
    private String currentLinkPosition = "";

    ShowPreviewDialog(ChatConversationPanel chatPanel) {
        this.chatPanel = chatPanel;
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.SHOW_PREVIEW_DIALOG_TITLE"));
        this.okButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.OK"));
        this.cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
        TransparentPanel mainPanel = new TransparentPanel();
        mainPanel.setLayout(new BoxLayout((Container)mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)mainPanel);
        JTextPane descriptionMsg = new JTextPane();
        descriptionMsg.setEditable(false);
        descriptionMsg.setOpaque(false);
        descriptionMsg.setText(GuiActivator.getResources().getI18NString("service.gui.SHOW_PREVIEW_WARNING_DESCRIPTION"));
        ImageIcon warningIcon = null;
        try {
            warningIcon = new ImageIcon(ImageIO.read(GuiActivator.getResources().getImageURL("service.gui.icons.WARNING_ICON")));
        }
        catch (IOException e) {
            logger.debug((Object)"failed to load the warning icon");
        }
        JLabel warningSign = new JLabel(warningIcon);
        TransparentPanel warningPanel = new TransparentPanel();
        warningPanel.setLayout(new BoxLayout((Container)warningPanel, 0));
        warningPanel.add(warningSign);
        warningPanel.add(Box.createHorizontalStrut(10));
        warningPanel.add(descriptionMsg);
        this.configureReplacement = new SIPCommCheckBox(GuiActivator.getResources().getI18NString("plugin.chatconfig.replacement.CONFIGURE_REPLACEMENT"));
        TransparentPanel checkBoxPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
        checkBoxPanel.add(this.configureReplacement);
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        mainPanel.add((Component)warningPanel);
        mainPanel.add(Box.createVerticalStrut(10));
        mainPanel.add((Component)checkBoxPanel);
        mainPanel.add((Component)buttonsPanel);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.setPreferredSize(new Dimension(390, 230));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.okButton)) {
            SwingWorker worker = new SwingWorker(){

                public void finished() {
                    String newChatString = (String)this.get();
                    if (newChatString != null) {
                        try {
                            Element elem = ((ShowPreviewDialog)ShowPreviewDialog.this).chatPanel.document.getElement(ShowPreviewDialog.this.currentMessageID);
                            ((ShowPreviewDialog)ShowPreviewDialog.this).chatPanel.document.setOuterHTML(elem, newChatString);
                            ShowPreviewDialog.this.msgIDToChatString.put(ShowPreviewDialog.this.currentMessageID, newChatString);
                        }
                        catch (BadLocationException ex) {
                            logger.error((Object)"Could not replace chat message", (Throwable)ex);
                        }
                        catch (IOException ex) {
                            logger.error((Object)"Could not replace chat message", (Throwable)ex);
                        }
                    }
                }

                protected Object construct() throws Exception {
                    String newChatString = (String)ShowPreviewDialog.this.msgIDToChatString.get(ShowPreviewDialog.this.currentMessageID);
                    try {
                        String originalLink = (String)ShowPreviewDialog.this.msgIDandPositionToLink.get(ShowPreviewDialog.this.currentMessageID + "#" + ShowPreviewDialog.this.currentLinkPosition);
                        String replacementLink = (String)ShowPreviewDialog.this.linkToReplacement.get(originalLink);
                        DirectImageReplacementService source = GuiActivator.getDirectImageReplacementSource();
                        String replacement = originalLink.equals(replacementLink) && (!source.isDirectImage(originalLink) || source.getImageSize(originalLink) == -1) ? originalLink : "<IMG HEIGHT=\"90\" WIDTH=\"120\" SRC=\"" + replacementLink + "\" BORDER=\"0\" ALT=\"" + originalLink + "\"></IMG>";
                        String old = originalLink + "</A> <A href=\"jitsi://" + ShowPreviewDialog.this.getClass().getName() + "/SHOWPREVIEW?" + ShowPreviewDialog.this.currentMessageID + "#" + ShowPreviewDialog.this.currentLinkPosition + "\">" + GuiActivator.getResources().getI18NString("service.gui.SHOW_PREVIEW");
                        newChatString = newChatString.replace(old, replacement);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Could not replace chat message", (Throwable)ex);
                    }
                    return newChatString;
                }
            };
            worker.start();
            this.setVisible(false);
        } else if (arg0.getSource().equals(this.cancelButton)) {
            this.setVisible(false);
        }
        if (this.configureReplacement.isSelected()) {
            ConfigurationContainer configContainer = GuiActivator.getUIService().getConfigurationContainer();
            ConfigurationForm chatConfigForm = ChatConversationPanel.getChatConfigForm();
            if (chatConfigForm != null) {
                configContainer.setSelected(chatConfigForm);
                configContainer.setVisible(true);
            }
            this.configureReplacement.setSelected(false);
        }
    }

    public void chatLinkClicked(URI url) {
        String action = url.getPath();
        if (action.equals("/SHOWPREVIEW")) {
            this.currentMessageID = url.getQuery();
            this.currentLinkPosition = url.getFragment();
            this.setVisible(true);
            this.setLocationRelativeTo((Component)((Object)this.chatPanel));
        }
    }

    Map<String, String> getMsgIDToChatString() {
        return this.msgIDToChatString;
    }

    Map<String, String> getMsgIDandPositionToLink() {
        return this.msgIDandPositionToLink;
    }

    Map<String, String> getLinkToReplacement() {
        return this.linkToReplacement;
    }

    protected void close(boolean escaped) {
        this.cancelButton.doClick();
    }
}

