/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main;

import com.explodingpixels.macwidgets.MacUtils;
import com.explodingpixels.macwidgets.UnifiedToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.DefaultContactEventHandler;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.UIServiceImpl;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.main.DialPadButton;
import net.java.sip.communicator.impl.gui.main.SingleWindowContainer;
import net.java.sip.communicator.impl.gui.main.call.CallButton;
import net.java.sip.communicator.impl.gui.main.call.CallHistoryButton;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatManager;
import net.java.sip.communicator.impl.gui.main.contactlist.CommonRightButtonMenu;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListPane;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListSearchKeyDispatcher;
import net.java.sip.communicator.impl.gui.main.contactlist.SearchField;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.UnknownContactPanel;
import net.java.sip.communicator.impl.gui.main.menus.MainMenu;
import net.java.sip.communicator.impl.gui.main.presence.AccountStatusPanel;
import net.java.sip.communicator.plugin.desktoputil.MessageDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.event.TextFieldChangeListener;
import net.java.sip.communicator.service.contacteventhandler.ContactEventHandler;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.gui.ContactListContainer;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.WindowID;
import net.java.sip.communicator.service.protocol.AccountInfoUtils;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetAdHocMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetMessageWaiting;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.OperationSetWebContactInfo;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationListener;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationRejectionListener;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationRejectionListener;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageWaitingListener;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.TypingNotificationsListener;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class MainFrame
extends SIPCommFrame
implements ContactListContainer,
ExportedWindow,
PluginComponentListener,
Skinnable {
    private static final long serialVersionUID = 0L;
    private final Logger logger = Logger.getLogger(MainFrame.class);
    private final TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(0, 0));
    private final TransparentPanel statusBarPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private final TransparentPanel centerPanel = new TransparentPanel((LayoutManager)new BorderLayout(0, 0));
    private MainMenu menu;
    private SearchField searchField;
    private final HashMap<ProtocolProviderService, Integer> protocolProviders = new LinkedHashMap<ProtocolProviderService, Integer>();
    private AccountStatusPanel accountStatusPanel;
    private UnknownContactPanel unknownContactPanel;
    private final Map<ProtocolProviderService, ContactEventHandler> providerContactHandlers = new Hashtable<ProtocolProviderService, ContactEventHandler>();
    private final List<PluginComponentFactory> nativePluginsTable = new ArrayList<PluginComponentFactory>();
    private final JPanel pluginPanelNorth = new TransparentPanel();
    private final JPanel pluginPanelSouth = new TransparentPanel();
    private final JPanel pluginPanelWest = new TransparentPanel();
    private final JPanel pluginPanelEast = new TransparentPanel();
    private ContactListPane contactListPanel;
    private ProviderPresenceStatusListener uiProviderPresenceListener;
    private CallListener uiCallListener;
    private final ContactListSearchKeyDispatcher clKeyDispatcher;
    final KeyboardFocusManager keyManager;

    public MainFrame() {
        if (!ConfigurationUtils.isWindowDecorated()) {
            this.setUndecorated(true);
        }
        this.contactListPanel = new ContactListPane(this);
        this.accountStatusPanel = new AccountStatusPanel();
        this.searchField = new SearchField(this, TreeContactList.searchFilter, true, true);
        this.menu = new MainMenu(this);
        this.initTitleFont();
        ResourceManagementService resources = GuiActivator.getResources();
        String applicationName = resources.getSettingsString("service.gui.APPLICATION_NAME");
        this.setTitle(applicationName);
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, applicationName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mainPanel.setBackground(new Color(GuiActivator.getResources().getColor("service.gui.MAIN_WINDOW_BACKGROUND")));
        this.keyManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.clKeyDispatcher = new ContactListSearchKeyDispatcher(this.keyManager, this.searchField, this);
        this.keyManager.addKeyEventDispatcher(this.clKeyDispatcher);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                MainFrame.this.windowClosed(event);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                Window focusedWindow = MainFrame.this.keyManager.getFocusedWindow();
                if (focusedWindow == null) {
                    MainFrame.this.requestFocusInContactList();
                } else if (!focusedWindow.equals(MainFrame.this)) {
                    MainFrame.this.requestFocusLater(focusedWindow);
                }
            }
        });
        this.init();
        this.initPluginComponents();
    }

    private void requestFocusLater(Window focusedWindow) {
        focusedWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                event.getWindow().removeWindowListener(this);
                Window focusedWindow = MainFrame.this.keyManager.getFocusedWindow();
                if (focusedWindow == null || focusedWindow.getClass().getName().equals("javax.swing.SwingUtilities$SharedOwnerFrame")) {
                    MainFrame.this.requestFocusInContactList();
                } else if (!focusedWindow.equals(MainFrame.this)) {
                    MainFrame.this.requestFocusLater(focusedWindow);
                }
            }
        });
    }

    public void requestFocusInContactList() {
        this.centerPanel.requestFocusInWindow();
        GuiActivator.getContactList().requestFocus();
    }

    private void init() {
        this.updateCloseAction(false);
        this.registerKeyActions();
        JComponent northPanel = this.createTopComponent();
        this.setJMenuBar(this.menu);
        TransparentPanel searchPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 0));
        searchPanel.add((Component)((Object)this.searchField));
        searchPanel.add((Component)((Object)new DialPadButton()), (Object)"West");
        if (!GuiActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.gui.CALL_HISTORY_BUTTON_DISABLED", false)) {
            searchPanel.add(this.createButtonPanel(), (Object)"East");
        }
        northPanel.add((Component)((Object)this.accountStatusPanel), "Center");
        northPanel.add((Component)searchPanel, "South");
        this.centerPanel.add((Component)((Object)this.contactListPanel), (Object)"Center");
        this.mainPanel.add((Component)northPanel, (Object)"North");
        SingleWindowContainer singleWContainer = GuiActivator.getUIService().getSingleWindowContainer();
        this.mainPanel.add((Component)this.centerPanel, (Object)"Center");
        if (singleWContainer != null) {
            JSplitPane topSplitPane = new JSplitPane(1);
            topSplitPane.setBorder(null);
            topSplitPane.setOneTouchExpandable(true);
            topSplitPane.setResizeWeight(0.0);
            topSplitPane.setOpaque(false);
            topSplitPane.setDividerLocation(200);
            topSplitPane.add((Component)this.mainPanel);
            topSplitPane.add((Component)((Object)singleWContainer));
            this.getContentPane().add((Component)topSplitPane, "Center");
            this.getContentPane().add((Component)this.statusBarPanel, "South");
        } else {
            Container contentPane = this.getContentPane();
            contentPane.add((Component)this.mainPanel, "Center");
            contentPane.add((Component)this.statusBarPanel, "South");
        }
    }

    public void updateCloseAction(boolean canHide) {
        if (ConfigurationUtils.isMinimizeInsteadOfHide()) {
            this.logger.info((Object)"Updating close action: DO_NOTHING_ON_CLOSE");
            this.setDefaultCloseOperation(0);
        } else {
            this.logger.info((Object)("Updating close action: " + (canHide ? "HIDE_ON_CLOSE" : "DISPOSE_ON_CLOSE")));
            this.setDefaultCloseOperation(canHide ? 1 : 2);
        }
    }

    private Component createButtonPanel() {
        boolean isCallButtonEnabled = false;
        String callButtonEnabledString = GuiActivator.getResources().getSettingsString("impl.gui.CALL_BUTTON_ENABLED");
        if (callButtonEnabledString != null && callButtonEnabledString.length() > 0) {
            isCallButtonEnabled = new Boolean(callButtonEnabledString);
        }
        CallHistoryButton historyButton = new CallHistoryButton();
        if (isCallButtonEnabled) {
            TransparentPanel panel = new TransparentPanel((LayoutManager)new FlowLayout(0, 3, 0));
            panel.add((Component)((Object)new CallButton(this)));
            panel.add((Component)((Object)historyButton));
            return panel;
        }
        return historyButton;
    }

    private JComponent createTopComponent() {
        Object topComponent = null;
        if (OSUtils.IS_MAC) {
            UnifiedToolBar macToolbarPanel = new UnifiedToolBar();
            MacUtils.makeWindowLeopardStyle(this.getRootPane());
            macToolbarPanel.getComponent().setLayout(new BorderLayout(5, 5));
            macToolbarPanel.getComponent().setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            macToolbarPanel.disableBackgroundPainter();
            macToolbarPanel.installWindowDraggerOnWindow((Window)((Object)this));
            this.centerPanel.setOpaque(true);
            this.centerPanel.setBackground(new Color(GuiActivator.getResources().getColor("service.gui.MAC_PANEL_BACKGROUND")));
            topComponent = macToolbarPanel.getComponent();
        } else {
            TransparentPanel panel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
            panel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            topComponent = panel;
        }
        return topComponent;
    }

    public void initBounds() {
        int width = GuiActivator.getResources().getSettingsInt("impl.gui.MAIN_WINDOW_WIDTH");
        int height = GuiActivator.getResources().getSettingsInt("impl.gui.MAIN_WINDOW_HEIGHT");
        int minWidth = GuiActivator.getResources().getSettingsInt("impl.gui.MAIN_WINDOW_MIN_WIDTH");
        int minHeight = GuiActivator.getResources().getSettingsInt("impl.gui.MAIN_WINDOW_MIN_HEIGHT");
        this.getContentPane().setMinimumSize(new Dimension(minWidth, minHeight));
        this.setSize(width, height);
        this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth(), 50);
    }

    private void initTitleFont() {
        JLayeredPane layeredPane = this.getLayeredPane();
        ResourceManagementService resources = GuiActivator.getResources();
        String fontName = resources.getSettingsString("service.gui.FONT_NAME");
        int fontSize = resources.getSettingsInt("service.gui.FONT_SIZE");
        Font font = new Font(fontName, 1, fontSize);
        int componentCount = layeredPane.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            layeredPane.getComponent(i).setFont(font);
        }
    }

    public void enableUnknownContactView(boolean isEnabled) {
        if (isEnabled) {
            if (this.unknownContactPanel == null) {
                this.unknownContactPanel = new UnknownContactPanel(this);
            }
            if (this.unknownContactPanel.getParent() != this.centerPanel) {
                this.contactListPanel.setVisible(false);
                this.unknownContactPanel.setVisible(true);
                this.centerPanel.remove((Component)((Object)this.contactListPanel));
                this.centerPanel.add((Component)((Object)this.unknownContactPanel), (Object)"Center");
            }
        } else if (this.contactListPanel.getParent() != this.centerPanel) {
            if (this.unknownContactPanel != null) {
                this.unknownContactPanel.setVisible(false);
                this.centerPanel.remove((Component)((Object)this.unknownContactPanel));
            }
            this.contactListPanel.setVisible(true);
            this.centerPanel.add((Component)((Object)this.contactListPanel), (Object)"Center");
        }
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
    }

    public void setContactList(MetaContactListService contactList) {
        this.contactListPanel.initList(contactList);
        this.searchField.setContactList(GuiActivator.getContactList());
        this.clKeyDispatcher.setContactList(GuiActivator.getContactList());
    }

    public void addProtocolSupportedOperationSets(ProtocolProviderService protocolProvider) {
        OperationSetMessageWaiting messageWaiting;
        OperationSetFileTransfer fileTransferOpSet;
        OperationSetAdHocMultiUserChat adHocMultiChatOpSet;
        ConferenceChatManager conferenceManager;
        String multiChatClassName;
        String telOpSetClassName;
        String tnOpSetClassName;
        String smsOpSetClassName;
        String imOpSetClassName;
        Map supportedOperationSets = protocolProvider.getSupportedOperationSets();
        String ppOpSetClassName = OperationSetPersistentPresence.class.getName();
        String pOpSetClassName = OperationSetPresence.class.getName();
        if (supportedOperationSets.containsKey(ppOpSetClassName) || supportedOperationSets.containsKey(pOpSetClassName)) {
            OperationSetPresence presence = (OperationSetPresence)supportedOperationSets.get(ppOpSetClassName);
            if (presence == null) {
                presence = (OperationSetPresence)supportedOperationSets.get(pOpSetClassName);
            }
            this.uiProviderPresenceListener = new GUIProviderPresenceStatusListener();
            presence.addProviderPresenceStatusListener(this.uiProviderPresenceListener);
            presence.addContactPresenceStatusListener((ContactPresenceStatusListener)GuiActivator.getContactList().getMetaContactListSource());
        }
        if (supportedOperationSets.containsKey(imOpSetClassName = OperationSetBasicInstantMessaging.class.getName())) {
            OperationSetBasicInstantMessaging im = (OperationSetBasicInstantMessaging)supportedOperationSets.get(imOpSetClassName);
            im.addMessageListener((MessageListener)this.getContactListPanel());
        }
        if (supportedOperationSets.containsKey(smsOpSetClassName = OperationSetSmsMessaging.class.getName())) {
            OperationSetSmsMessaging sms = (OperationSetSmsMessaging)supportedOperationSets.get(smsOpSetClassName);
            sms.addMessageListener((MessageListener)this.getContactListPanel());
        }
        if (supportedOperationSets.containsKey(tnOpSetClassName = OperationSetTypingNotifications.class.getName())) {
            OperationSetTypingNotifications tn = (OperationSetTypingNotifications)supportedOperationSets.get(tnOpSetClassName);
            tn.addTypingNotificationsListener((TypingNotificationsListener)this.getContactListPanel());
        }
        if (supportedOperationSets.containsKey(telOpSetClassName = OperationSetBasicTelephony.class.getName())) {
            OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)supportedOperationSets.get(telOpSetClassName);
            this.uiCallListener = new CallManager.GuiCallListener();
            telephony.addCallListener(this.uiCallListener);
        }
        if (supportedOperationSets.containsKey(multiChatClassName = OperationSetMultiUserChat.class.getName())) {
            OperationSetMultiUserChat multiUserChat = (OperationSetMultiUserChat)supportedOperationSets.get(multiChatClassName);
            conferenceManager = GuiActivator.getUIService().getConferenceChatManager();
            multiUserChat.addInvitationListener((ChatRoomInvitationListener)conferenceManager);
            multiUserChat.addInvitationRejectionListener((ChatRoomInvitationRejectionListener)conferenceManager);
            multiUserChat.addPresenceListener((LocalUserChatRoomPresenceListener)conferenceManager);
        }
        if ((adHocMultiChatOpSet = (OperationSetAdHocMultiUserChat)protocolProvider.getOperationSet(OperationSetAdHocMultiUserChat.class)) != null) {
            conferenceManager = GuiActivator.getUIService().getConferenceChatManager();
            adHocMultiChatOpSet.addInvitationListener((AdHocChatRoomInvitationListener)conferenceManager);
            adHocMultiChatOpSet.addInvitationRejectionListener((AdHocChatRoomInvitationRejectionListener)conferenceManager);
            adHocMultiChatOpSet.addPresenceListener((LocalUserAdHocChatRoomPresenceListener)conferenceManager);
        }
        if ((fileTransferOpSet = (OperationSetFileTransfer)protocolProvider.getOperationSet(OperationSetFileTransfer.class)) != null) {
            fileTransferOpSet.addFileTransferListener((FileTransferListener)this.getContactListPanel());
        }
        if ((messageWaiting = (OperationSetMessageWaiting)protocolProvider.getOperationSet(OperationSetMessageWaiting.class)) != null) {
            messageWaiting.addMessageWaitingNotificationListener(OperationSetMessageWaiting.MessageType.VOICE, (MessageWaitingListener)TreeContactList.getNotificationContactSource());
        }
    }

    public void removeProtocolSupportedOperationSets(ProtocolProviderService protocolProvider) {
        OperationSetMessageWaiting messageWaiting;
        OperationSetFileTransfer fileTransferOpSet;
        OperationSetAdHocMultiUserChat adHocMultiChatOpSet;
        ConferenceChatManager conferenceManager;
        String multiChatClassName;
        String telOpSetClassName;
        String tnOpSetClassName;
        String smsOpSetClassName;
        String imOpSetClassName;
        Map supportedOperationSets = protocolProvider.getSupportedOperationSets();
        String ppOpSetClassName = OperationSetPersistentPresence.class.getName();
        String pOpSetClassName = OperationSetPresence.class.getName();
        if (supportedOperationSets.containsKey(ppOpSetClassName) || supportedOperationSets.containsKey(pOpSetClassName)) {
            OperationSetPresence presence = (OperationSetPresence)supportedOperationSets.get(ppOpSetClassName);
            if (presence == null) {
                presence = (OperationSetPresence)supportedOperationSets.get(pOpSetClassName);
            }
            if (this.uiProviderPresenceListener != null) {
                presence.removeProviderPresenceStatusListener(this.uiProviderPresenceListener);
            }
            presence.removeContactPresenceStatusListener((ContactPresenceStatusListener)GuiActivator.getContactList().getMetaContactListSource());
        }
        if (supportedOperationSets.containsKey(imOpSetClassName = OperationSetBasicInstantMessaging.class.getName())) {
            OperationSetBasicInstantMessaging im = (OperationSetBasicInstantMessaging)supportedOperationSets.get(imOpSetClassName);
            im.removeMessageListener((MessageListener)this.getContactListPanel());
        }
        if (supportedOperationSets.containsKey(smsOpSetClassName = OperationSetSmsMessaging.class.getName())) {
            OperationSetSmsMessaging sms = (OperationSetSmsMessaging)supportedOperationSets.get(smsOpSetClassName);
            sms.removeMessageListener((MessageListener)this.getContactListPanel());
        }
        if (supportedOperationSets.containsKey(tnOpSetClassName = OperationSetTypingNotifications.class.getName())) {
            OperationSetTypingNotifications tn = (OperationSetTypingNotifications)supportedOperationSets.get(tnOpSetClassName);
            tn.removeTypingNotificationsListener((TypingNotificationsListener)this.getContactListPanel());
        }
        if (supportedOperationSets.containsKey(telOpSetClassName = OperationSetBasicTelephony.class.getName())) {
            OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)supportedOperationSets.get(telOpSetClassName);
            if (this.uiCallListener != null) {
                telephony.removeCallListener(this.uiCallListener);
            }
        }
        if (supportedOperationSets.containsKey(multiChatClassName = OperationSetMultiUserChat.class.getName())) {
            OperationSetMultiUserChat multiUserChat = (OperationSetMultiUserChat)supportedOperationSets.get(multiChatClassName);
            conferenceManager = GuiActivator.getUIService().getConferenceChatManager();
            multiUserChat.removeInvitationListener((ChatRoomInvitationListener)conferenceManager);
            multiUserChat.removeInvitationRejectionListener((ChatRoomInvitationRejectionListener)conferenceManager);
            multiUserChat.removePresenceListener((LocalUserChatRoomPresenceListener)conferenceManager);
        }
        if ((adHocMultiChatOpSet = (OperationSetAdHocMultiUserChat)protocolProvider.getOperationSet(OperationSetAdHocMultiUserChat.class)) != null) {
            conferenceManager = GuiActivator.getUIService().getConferenceChatManager();
            adHocMultiChatOpSet.removeInvitationListener((AdHocChatRoomInvitationListener)conferenceManager);
            adHocMultiChatOpSet.removeInvitationRejectionListener((AdHocChatRoomInvitationRejectionListener)conferenceManager);
            adHocMultiChatOpSet.removePresenceListener((LocalUserAdHocChatRoomPresenceListener)conferenceManager);
        }
        if ((fileTransferOpSet = (OperationSetFileTransfer)protocolProvider.getOperationSet(OperationSetFileTransfer.class)) != null) {
            fileTransferOpSet.removeFileTransferListener((FileTransferListener)this.getContactListPanel());
        }
        if ((messageWaiting = (OperationSetMessageWaiting)protocolProvider.getOperationSet(OperationSetMessageWaiting.class)) != null) {
            messageWaiting.removeMessageWaitingNotificationListener(OperationSetMessageWaiting.MessageType.VOICE, (MessageWaitingListener)TreeContactList.getNotificationContactSource());
        }
    }

    public Iterator<ProtocolProviderService> getProtocolProviders() {
        return new LinkedList<ProtocolProviderService>(this.protocolProviders.keySet()).iterator();
    }

    public ProtocolProviderService getProtocolProviderForAccount(String accountName) {
        for (ProtocolProviderService pps : this.protocolProviders.keySet()) {
            if (!pps.getAccountID().getUserID().equals(accountName)) continue;
            return pps;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtocolProvider(ProtocolProviderService protocolProvider) {
        HashMap<ProtocolProviderService, Integer> hashMap = this.protocolProviders;
        synchronized (hashMap) {
            if (this.protocolProviders.containsKey(protocolProvider)) {
                return;
            }
            this.protocolProviders.put(protocolProvider, this.initiateProviderIndex(protocolProvider));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Add the following protocol provider to the gui: " + protocolProvider.getAccountID().getAccountAddress()));
        }
        this.addProtocolSupportedOperationSets(protocolProvider);
        this.addAccount(protocolProvider);
        ContactEventHandler contactHandler = this.getContactHandlerForProvider(protocolProvider);
        if (contactHandler == null) {
            contactHandler = new DefaultContactEventHandler(this);
        }
        this.addProviderContactHandler(protocolProvider, contactHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProtocolProvider(ProtocolProviderService protocolProvider) {
        HashMap<ProtocolProviderService, Integer> hashMap = this.protocolProviders;
        synchronized (hashMap) {
            return this.protocolProviders.containsKey(protocolProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOperationSet(Class<? extends OperationSet> opSet) {
        HashMap<ProtocolProviderService, Integer> hashMap = this.protocolProviders;
        synchronized (hashMap) {
            for (ProtocolProviderService pp : this.protocolProviders.keySet()) {
                if (pp.getOperationSet(opSet) == null) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProtocolProvider(ProtocolProviderService protocolProvider) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Remove the following protocol provider to the gui: " + protocolProvider.getAccountID().getAccountAddress()));
        }
        HashMap<ProtocolProviderService, Integer> hashMap = this.protocolProviders;
        synchronized (hashMap) {
            this.protocolProviders.remove(protocolProvider);
        }
        this.removeProtocolSupportedOperationSets(protocolProvider);
        this.removeProviderContactHandler(protocolProvider);
        this.updateProvidersIndexes(protocolProvider);
        this.accountStatusPanel.removeAccount(protocolProvider);
    }

    public int getProviderIndex(ProtocolProviderService protocolProvider) {
        Integer o = this.protocolProviders.get(protocolProvider);
        return o != null ? o : 0;
    }

    public void addAccount(ProtocolProviderService protocolProvider) {
        if (!this.accountStatusPanel.containsAccount(protocolProvider)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Add the following account to the status bar: " + protocolProvider.getAccountID().getAccountAddress()));
            }
            this.accountStatusPanel.addAccount(protocolProvider);
        }
    }

    public String getAccountAddress(ProtocolProviderService protocolProvider) {
        return protocolProvider.getAccountID().getAccountAddress();
    }

    public String getAccountDisplayName(ProtocolProviderService protocolProvider) {
        OperationSetServerStoredAccountInfo accountInfoOpSet = (OperationSetServerStoredAccountInfo)protocolProvider.getOperationSet(OperationSetServerStoredAccountInfo.class);
        try {
            String displayName;
            if (accountInfoOpSet != null && (displayName = AccountInfoUtils.getDisplayName((OperationSetServerStoredAccountInfo)accountInfoOpSet)) != null && displayName.length() > 0) {
                return displayName;
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)"Cannot obtain display name through OPSet");
        }
        return protocolProvider.getAccountID().getDisplayName();
    }

    public OperationSetWebContactInfo getWebContactInfoOpSet(ProtocolProviderService protocolProvider) {
        OperationSet opSet = protocolProvider.getOperationSet(OperationSetWebContactInfo.class);
        return opSet instanceof OperationSetWebContactInfo ? (OperationSetWebContactInfo)opSet : null;
    }

    public OperationSetBasicTelephony<?> getTelephonyOpSet(ProtocolProviderService protocolProvider) {
        OperationSet opSet = protocolProvider.getOperationSet(OperationSetBasicTelephony.class);
        return opSet instanceof OperationSetBasicTelephony ? (OperationSetBasicTelephony)opSet : null;
    }

    public OperationSetAdHocMultiUserChat getAdHocMultiUserChatOpSet(ProtocolProviderService protocolProvider) {
        OperationSet opSet = protocolProvider.getOperationSet(OperationSetAdHocMultiUserChat.class);
        return opSet instanceof OperationSetAdHocMultiUserChat ? (OperationSetAdHocMultiUserChat)opSet : null;
    }

    public boolean isMenuSelected() {
        return this.menu.hasSelectedMenus();
    }

    public ContactListPane getContactListPanel() {
        return this.contactListPanel;
    }

    public String getCurrentSearchText() {
        return this.searchField.getText();
    }

    public void clearCurrentSearchText() {
        this.searchField.setText("");
    }

    public void addSearchFieldListener(TextFieldChangeListener l) {
        this.searchField.addTextChangeListener(l);
    }

    public void removeSearchFieldListener(TextFieldChangeListener l) {
        this.searchField.addTextChangeListener(l);
    }

    private int initiateProviderIndex(ProtocolProviderService protocolProvider) {
        ConfigurationService configService = GuiActivator.getConfigurationService();
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        for (String accountRootPropName : accounts) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(protocolProvider.getAccountID().getAccountUniqueID())) continue;
            String index = configService.getString(accountRootPropName + ".accountIndex");
            if (index != null) {
                return Integer.parseInt(index);
            }
            return this.createAccountIndex(protocolProvider, accountRootPropName);
        }
        String accNodeName = "acc" + Long.toString(System.currentTimeMillis());
        String accountPackage = "net.java.sip.communicator.impl.gui.accounts." + accNodeName;
        configService.setProperty(accountPackage, (Object)protocolProvider.getAccountID().getAccountUniqueID());
        return this.createAccountIndex(protocolProvider, accountPackage);
    }

    private int createAccountIndex(ProtocolProviderService protocolProvider, String accountRootPropName) {
        ConfigurationService configService = GuiActivator.getConfigurationService();
        int accountIndex = -1;
        for (ProtocolProviderService pps : this.protocolProviders.keySet()) {
            int index;
            if (!pps.getProtocolDisplayName().equals(protocolProvider.getProtocolDisplayName()) || pps.equals(protocolProvider) || accountIndex >= (index = this.protocolProviders.get(pps).intValue())) continue;
            accountIndex = index;
        }
        configService.setProperty(accountRootPropName + ".accountIndex", (Object)(++accountIndex));
        return accountIndex;
    }

    private void updateProvidersIndexes(ProtocolProviderService removedProvider) {
        ConfigurationService configService = GuiActivator.getConfigurationService();
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        ProtocolProviderService currentProvider = null;
        int sameProtocolProvidersCount = 0;
        for (ProtocolProviderService pps : this.protocolProviders.keySet()) {
            if (!pps.getProtocolDisplayName().equals(removedProvider.getProtocolDisplayName())) continue;
            if (++sameProtocolProvidersCount > 1) break;
            currentProvider = pps;
        }
        if (sameProtocolProvidersCount < 2 && currentProvider != null) {
            this.protocolProviders.put(currentProvider, 0);
            List accounts = configService.getPropertyNamesByPrefix(prefix, true);
            for (String rootPropName : accounts) {
                String accountUID = configService.getString(rootPropName);
                if (!accountUID.equals(currentProvider.getAccountID().getAccountUniqueID())) continue;
                configService.setProperty(rootPropName + ".accountIndex", (Object)0);
            }
        }
    }

    protected void close(boolean isEscaped) {
        TreeContactList contactList = GuiActivator.getContactList();
        Component contactListRightMenu = contactList.getRightButtonMenu();
        CommonRightButtonMenu commonPopupMenu = this.getContactListPanel().getCommonRightButtonMenu();
        if (contactListRightMenu != null && contactListRightMenu.isVisible()) {
            contactListRightMenu.setVisible(false);
        } else if (commonPopupMenu != null && commonPopupMenu.isVisible()) {
            commonPopupMenu.setVisible(false);
        } else if (this.accountStatusPanel.hasSelectedMenus() || this.menu.hasSelectedMenus()) {
            MenuSelectionManager selectionManager = MenuSelectionManager.defaultManager();
            selectionManager.clearSelectedPath();
        }
    }

    public MainMenu getMainMenu() {
        return this.menu;
    }

    public void addProviderContactHandler(ProtocolProviderService protocolProvider, ContactEventHandler contactHandler) {
        this.providerContactHandlers.put(protocolProvider, contactHandler);
    }

    public void removeProviderContactHandler(ProtocolProviderService protocolProvider) {
        this.providerContactHandlers.remove(protocolProvider);
    }

    public ContactEventHandler getContactHandler(ProtocolProviderService protocolProvider) {
        return this.providerContactHandlers.get(protocolProvider);
    }

    private ContactEventHandler getContactHandlerForProvider(ProtocolProviderService protocolProvider) {
        Collection serRefs;
        String osgiFilter = "(PROTOCOL_NAME=" + protocolProvider.getProtocolName() + ")";
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(ContactEventHandler.class, osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            serRefs = null;
            this.logger.error((Object)("GuiActivator : " + (Object)((Object)ex)));
        }
        if (serRefs == null || serRefs.isEmpty()) {
            return null;
        }
        return (ContactEventHandler)GuiActivator.bundleContext.getService((ServiceReference)serRefs.iterator().next());
    }

    private void initPluginComponents() {
        Collection serRefs;
        this.pluginPanelSouth.setLayout(new BoxLayout(this.pluginPanelSouth, 1));
        this.pluginPanelNorth.setLayout(new BoxLayout(this.pluginPanelNorth, 1));
        this.pluginPanelEast.setLayout(new BoxLayout(this.pluginPanelEast, 1));
        this.pluginPanelWest.setLayout(new BoxLayout(this.pluginPanelWest, 1));
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.pluginPanelNorth, "North");
        contentPane.add((Component)this.pluginPanelEast, "East");
        contentPane.add((Component)this.pluginPanelWest, "West");
        this.mainPanel.add((Component)this.pluginPanelSouth, (Object)"South");
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class, "(|(CONTAINER_ID=" + net.java.sip.communicator.service.gui.Container.CONTAINER_MAIN_WINDOW.getID() + ")(" + "CONTAINER_ID" + "=" + net.java.sip.communicator.service.gui.Container.CONTAINER_STATUS_BAR.getID() + "))");
        }
        catch (InvalidSyntaxException exc) {
            serRefs = null;
            this.logger.error((Object)"Could not obtain plugin reference.", (Throwable)exc);
        }
        if (serRefs != null && !serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                PluginComponentFactory factory = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRef);
                if (factory.isNativeComponent()) {
                    this.nativePluginsTable.add(factory);
                    continue;
                }
                String pluginConstraints = factory.getConstraints();
                Object constraints = pluginConstraints != null ? UIServiceImpl.getBorderLayoutConstraintsFromContainer(pluginConstraints) : "South";
                this.addPluginComponent((Component)factory.getPluginComponentInstance((Object)this).getComponent(), factory.getContainer(), constraints);
            }
        }
        GuiActivator.getUIService().addPluginComponentListener(this);
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        net.java.sip.communicator.service.gui.Container pluginContainer = factory.getContainer();
        if (pluginContainer.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_MAIN_WINDOW) || pluginContainer.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_STATUS_BAR)) {
            String pluginConstraints = factory.getConstraints();
            Object constraints = pluginConstraints != null ? UIServiceImpl.getBorderLayoutConstraintsFromContainer(pluginConstraints) : "South";
            if (factory.isNativeComponent()) {
                this.nativePluginsTable.add(factory);
                if (this.isFrameVisible()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this.addNativePlugins();
                        }
                    });
                }
            } else {
                this.addPluginComponent((Component)factory.getPluginComponentInstance((Object)this).getComponent(), pluginContainer, constraints);
            }
        }
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        final PluginComponentFactory factory = event.getPluginComponentFactory();
        final net.java.sip.communicator.service.gui.Container containerID = factory.getContainer();
        if (containerID.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_MAIN_WINDOW)) {
            Object constraints = UIServiceImpl.getBorderLayoutConstraintsFromContainer(factory.getConstraints());
            if (constraints == null) {
                constraints = "South";
            }
            if (factory.isNativeComponent()) {
                if (this.nativePluginsTable.contains(factory)) {
                    final Object finalConstraints = constraints;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this.removePluginComponent((Component)factory.getPluginComponentInstance((Object)MainFrame.this).getComponent(), containerID, finalConstraints);
                            MainFrame.this.getContentPane().repaint();
                        }
                    });
                }
            } else {
                this.removePluginComponent((Component)factory.getPluginComponentInstance((Object)this).getComponent(), containerID, constraints);
            }
            this.nativePluginsTable.remove(factory);
        }
    }

    private void removeNativePlugins() {
        for (PluginComponentFactory factory : this.nativePluginsTable) {
            Object constraints = UIServiceImpl.getBorderLayoutConstraintsFromContainer(factory.getConstraints());
            if (constraints == null) {
                constraints = "South";
            }
            this.removePluginComponent((Component)factory.getPluginComponentInstance((Object)this).getComponent(), factory.getContainer(), constraints);
            this.getContentPane().repaint();
        }
    }

    public void addNativePlugins() {
        this.removeNativePlugins();
        for (PluginComponentFactory factory : this.nativePluginsTable) {
            Object constraints = UIServiceImpl.getBorderLayoutConstraintsFromContainer(factory.getConstraints());
            Component c = (Component)factory.getPluginComponentInstance((Object)this).getComponent();
            this.addPluginComponent(c, factory.getContainer(), constraints);
            this.nativePluginsTable.add(factory);
        }
    }

    public void bringToFront() {
        this.toFront();
    }

    public WindowID getIdentifier() {
        return ExportedWindow.MAIN_WINDOW;
    }

    public Object getSource() {
        return this;
    }

    public void maximize() {
        this.setExtendedState(6);
    }

    public void minimize() {
        this.setExtendedState(1);
    }

    public boolean isFrameVisible() {
        return super.isVisible() && super.getExtendedState() != 1;
    }

    public void setFrameVisible(final boolean isVisible) {
        ConfigurationUtils.setApplicationVisible((boolean)isVisible);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (isVisible) {
                    MainFrame.this.addNativePlugins();
                    Window focusedWindow = MainFrame.this.keyManager.getFocusedWindow();
                    if (focusedWindow != null) {
                        MainFrame.this.setFocusableWindowState(false);
                    }
                    MainFrame.super.setVisible(isVisible);
                    if (focusedWindow != null) {
                        MainFrame.this.setFocusableWindowState(true);
                    }
                    MainFrame.super.setExtendedState(0);
                    MainFrame.super.toFront();
                } else {
                    MainFrame.super.setVisible(isVisible);
                }
            }
        });
    }

    private void addPluginComponent(Component c, net.java.sip.communicator.service.gui.Container container, Object constraints) {
        if (container.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_MAIN_WINDOW)) {
            if (constraints.equals("North")) {
                this.pluginPanelNorth.add(c);
                this.pluginPanelNorth.repaint();
            } else if (constraints.equals("South")) {
                this.pluginPanelSouth.add(c);
                this.pluginPanelSouth.repaint();
            } else if (constraints.equals("West")) {
                this.pluginPanelWest.add(c);
                this.pluginPanelWest.repaint();
            } else if (constraints.equals("East")) {
                this.pluginPanelEast.add(c);
                this.pluginPanelEast.repaint();
            }
        } else if (container.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_STATUS_BAR)) {
            this.statusBarPanel.add(c);
        }
        this.getContentPane().repaint();
        this.getContentPane().validate();
    }

    private void removePluginComponent(Component c, net.java.sip.communicator.service.gui.Container container, Object constraints) {
        if (container.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_MAIN_WINDOW)) {
            if (constraints.equals("North")) {
                this.pluginPanelNorth.remove(c);
            } else if (constraints.equals("South")) {
                this.pluginPanelSouth.remove(c);
            } else if (constraints.equals("West")) {
                this.pluginPanelWest.remove(c);
            } else if (constraints.equals("East")) {
                this.pluginPanelEast.remove(c);
            }
        } else if (container.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_STATUS_BAR)) {
            this.statusBarPanel.remove(c);
        }
    }

    public AccountStatusPanel getAccountStatusPanel() {
        return this.accountStatusPanel;
    }

    public void setParams(Object[] windowParams) {
    }

    protected void windowClosed(WindowEvent event) {
        if (this.getDefaultCloseOperation() == 3 || this.getDefaultCloseOperation() == 2) {
            try {
                GuiActivator.bundleContext.getBundle(0L).stop();
            }
            catch (BundleException ex) {
                this.logger.error((Object)"Failed to gently shutdown Felix", (Throwable)ex);
                System.exit(0);
            }
        }
    }

    protected void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        if (OSUtils.IS_MAC) {
            return;
        }
        switch (this.getDefaultCloseOperation()) {
            case 2: 
            case 3: {
                return;
            }
            case 1: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog dialog;
                        if (ConfigurationUtils.isQuitWarningShown() && (dialog = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.CLOSE"), GuiActivator.getResources().getI18NString("service.gui.HIDE_MAIN_WINDOW"), false)).showDialog() == 2) {
                            ConfigurationUtils.setQuitWarningShown((boolean)false);
                        }
                    }
                });
                ConfigurationUtils.setApplicationVisible((boolean)false);
                break;
            }
            case 0: {
                this.minimize();
            }
        }
    }

    public void enterKeyTyped() {
        if (this.unknownContactPanel != null && this.unknownContactPanel.isVisible()) {
            this.unknownContactPanel.addUnknownContact();
        } else if (this.contactListPanel.isVisible()) {
            GuiActivator.getContactList().startSelectedContactChat();
        }
    }

    public void ctrlEnterKeyTyped() {
        if (this.unknownContactPanel != null && this.unknownContactPanel.isVisible()) {
            this.unknownContactPanel.startCall();
        } else if (this.contactListPanel.isVisible()) {
            GuiActivator.getContactList().startSelectedContactCall();
        }
    }

    private void registerKeyActions() {
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.remove(KeyStroke.getKeyStroke(27, 0));
    }

    public void loadSkin() {
        this.mainPanel.setBackground(new Color(GuiActivator.getResources().getColor("service.gui.MAIN_WINDOW_BACKGROUND")));
    }

    private class GUIProviderPresenceStatusListener
    implements ProviderPresenceStatusListener {
        private GUIProviderPresenceStatusListener() {
        }

        public void providerStatusChanged(ProviderPresenceStatusChangeEvent evt) {
            ProtocolProviderService pps = evt.getProvider();
            MainFrame.this.accountStatusPanel.updateStatus(pps, evt.getNewStatus());
        }

        public void providerStatusMessageChanged(PropertyChangeEvent evt) {
        }
    }
}

