/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.slickless.util.xml;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestXMLUtils
extends TestCase {
    private static final String property1 = "p1";
    private static final String property1Value = "p1.value";
    private static final String property1Value2 = "p1.value.2";
    private static final String property1Path = "parent.";
    private static final String systemProperty = "SYSTEM_PROPERTY";
    private static final String systemPropertyValue = "I AM the SyS guy";
    private static final String systemPropertyValue2 = "sys guy's new face";
    private static final String systemPropertyPath = "parent.";
    private static final String addedProperty = "ADDED_PROPERTY";
    private static final String addedPropertyValue = "added";
    private static final String addedPropertyValue2 = "and then re-aded";
    private static final String addedPropertyPath = "parent.";
    private static final String innerProperty = "INNER_PROPERTY";
    private static final String innerPropertyValue = "I am an insider";
    private static final String innerPropertyValue2 = "I am a modified inner";
    private static final String innerPropertyPath = "parent.innerprops.";
    private static final String cdataNode = "CDATA_NODE";
    private static final String cdataNodeContent = "Thisis theCDATA nodeCOntent";
    private static final String cdataNodeContent2 = "The return of the CDATA";
    private static final String textNode = "TEXT_NODE";
    private static final String textNodeContent = "Thisis the TeXt nodeCOntent";
    private static final String textNodeContent2 = "The text strikes back";
    private static String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sip-communicator>\n   <parent>\n      <p1 value=\"p1.value\"/>\n      <SYSTEM_PROPERTY value=\"I AM the SyS guy\" system=\"true\"/>\n      <innerprops>\n          <INNER_PROPERTY value=\"I am an insider\"/>\n      </innerprops>\n   </parent>\n   <CDATA_NODE><![CDATA[Thisis theCDATA nodeCOntent]]></CDATA_NODE>\n   <TEXT_NODE>Thisis the TeXt nodeCOntent</TEXT_NODE>\n</sip-communicator>\n";
    DocumentBuilderFactory factory = null;
    DocumentBuilder builder = null;
    Document document = null;
    Node rootNode = null;

    public TestXMLUtils(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = this.factory.newDocumentBuilder();
        ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
        this.document = builder.parse(in);
        this.rootNode = this.document.getFirstChild();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFindChild() {
        Element parent = (Element)this.rootNode;
        String tagName = "parent";
        Element actualReturn = XMLUtils.findChild((Element)parent, (String)tagName);
        TestXMLUtils.assertEquals((String)"parent", (String)actualReturn.getTagName());
        parent = actualReturn;
        tagName = "innerprops";
        actualReturn = XMLUtils.findChild((Element)parent, (String)tagName);
        TestXMLUtils.assertEquals((String)"innerprops", (String)actualReturn.getTagName());
    }

    public void testGetAttribute() {
        Element parent = (Element)this.rootNode;
        String tagName = "parent";
        Element actualReturn = XMLUtils.findChild((Element)parent, (String)tagName);
        TestXMLUtils.assertEquals((String)"parent", (String)actualReturn.getTagName());
        parent = actualReturn;
        actualReturn = XMLUtils.findChild((Element)parent, (String)property1);
        TestXMLUtils.assertEquals((String)property1, (String)actualReturn.getTagName());
        TestXMLUtils.assertEquals((String)property1Value, (String)XMLUtils.getAttribute((Node)actualReturn, (String)"value"));
    }

    public void testGetSetCData() {
        Element parent = (Element)this.rootNode;
        Element returnedCdataNode = XMLUtils.findChild((Element)parent, (String)cdataNode);
        String actualReturn = XMLUtils.getCData((Element)returnedCdataNode);
        TestXMLUtils.assertEquals((String)cdataNodeContent, (String)actualReturn);
        XMLUtils.setCData((Element)returnedCdataNode, (String)cdataNodeContent2);
        returnedCdataNode = XMLUtils.findChild((Element)parent, (String)cdataNode);
        actualReturn = XMLUtils.getCData((Element)returnedCdataNode);
        TestXMLUtils.assertEquals((String)cdataNodeContent2, (String)actualReturn);
    }

    public void testGetSetText() {
        Element parent = (Element)this.rootNode;
        Element returnedTextNode = XMLUtils.findChild((Element)parent, (String)textNode);
        String actualReturn = XMLUtils.getText((Element)returnedTextNode);
        TestXMLUtils.assertEquals((String)textNodeContent, (String)actualReturn);
        XMLUtils.setCData((Element)returnedTextNode, (String)textNodeContent2);
        returnedTextNode = XMLUtils.findChild((Element)parent, (String)textNode);
        actualReturn = XMLUtils.getCData((Element)returnedTextNode);
        TestXMLUtils.assertEquals((String)textNodeContent2, (String)actualReturn);
    }

    public void testWriteXML() throws Exception {
        StringWriter writer = new StringWriter();
        StreamResult streamResult = new StreamResult(writer);
        String doctypeSystem = null;
        String doctypePublic = null;
        XMLUtils.writeXML((Document)this.document, (StreamResult)streamResult, doctypeSystem, doctypePublic);
        String writtenString = writer.toString();
        xmlString = new StringBuffer(writtenString).toString();
        this.setUp();
        this.testFindChild();
        xmlString = new StringBuffer(writtenString).toString();
        this.setUp();
        this.testGetAttribute();
        xmlString = new StringBuffer(writtenString).toString();
        this.setUp();
        this.testGetSetCData();
        xmlString = new StringBuffer(writtenString).toString();
        this.setUp();
        this.testGetSetText();
    }
}

