/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import net.java.sip.communicator.plugin.addrbook.AdvancedConfigForm;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookAddrBookContactSourceService;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookMAPIHResultException;
import net.java.sip.communicator.plugin.addrbook.msoutlook.RegistryHandler;
import net.java.sip.communicator.plugin.addrbook.msoutlook.calendar.CalendarServiceImpl;
import net.java.sip.communicator.service.calendar.CalendarService;
import net.java.sip.communicator.service.contactsource.AsyncContactSourceService;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.protocol.PhoneNumberI18nService;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class AddrBookActivator
implements BundleActivator {
    public static final String PNAME_ENABLE_MICROSOFT_OUTLOOK_SEARCH = "plugin.addrbook.ENABLE_MICROSOFT_OUTLOOK_SEARCH";
    public static final String PNAME_ENABLE_MACOSX_ADDRESS_BOOK_SEARCH = "plugin.addrbook.ENABLE_MACOSX_ADDRESS_BOOK_SEARCH";
    public static final String PNAME_ENABLE_DEFAULT_IM_APPLICATION_CHANGE = "plugin.addrbook.ENABLE_DEFAULT_IM_APPLICATION_CHANGE";
    public static final String PNAME_MAKE_JITSI_DEFAULT_IM_APPLICATION = "plugin.addrbook.REGISTER_AS_DEFAULT_IM_PROVIDER";
    private static final Logger logger = Logger.getLogger(AddrBookActivator.class);
    private static BundleContext bundleContext;
    private static ContactSourceService css;
    private static ServiceRegistration cssServiceRegistration;
    private static ResourceManagementService resourceService;
    private static ConfigurationService configService;
    private static CalendarServiceImpl calendarService;
    private static List<ProtocolProviderService> providers;
    private static PhoneNumberI18nService phoneNumberI18nService;
    private static RegistrationStateChangeListener providerListener;
    private static ServiceListener serviceListener;

    public static ResourceManagementService getResources() {
        if (resourceService == null) {
            resourceService = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resourceService;
    }

    public static CalendarServiceImpl getCalendarService() {
        return calendarService;
    }

    public static ConfigurationService getConfigService() {
        if (configService == null) {
            configService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configService;
    }

    public void start(BundleContext bundleContext) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Address book \"plugin.addrbook.ADDRESS_BOOKS\" ... [STARTED]");
        }
        AddrBookActivator.bundleContext = bundleContext;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("FORM_TYPE", "CONTACT_SOURCE_TYPE");
        bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(AdvancedConfigForm.class.getName(), this.getClass().getClassLoader(), null, "plugin.addrbook.ADDRESS_BOOKS", 101, false), properties);
        AddrBookActivator.startService();
        AddrBookActivator.startCalendarService();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Address book \"plugin.addrbook.ADDRESS_BOOKS\" ... [STOPPED]");
        }
        AddrBookActivator.stopService();
        AddrBookActivator.stopCalendarService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startService() {
        String cssClassName;
        ConfigurationService configService = AddrBookActivator.getConfigService();
        if (OSUtils.IS_WINDOWS && configService.getBoolean(PNAME_ENABLE_MICROSOFT_OUTLOOK_SEARCH, true)) {
            cssClassName = "net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookAddrBookContactSourceService";
        } else if (OSUtils.IS_MAC && configService.getBoolean(PNAME_ENABLE_MACOSX_ADDRESS_BOOK_SEARCH, true)) {
            cssClassName = "net.java.sip.communicator.plugin.addrbook.macosx.MacOSXAddrBookContactSourceService";
        } else {
            return;
        }
        if (OSUtils.IS_WINDOWS && configService.getBoolean(PNAME_ENABLE_DEFAULT_IM_APPLICATION_CHANGE, true)) {
            String isDefaultIMAppString = configService.getString(PNAME_MAKE_JITSI_DEFAULT_IM_APPLICATION);
            if (isDefaultIMAppString == null) {
                configService.setProperty(PNAME_MAKE_JITSI_DEFAULT_IM_APPLICATION, (Object)RegistryHandler.isJitsiDefaultIMApp());
            } else {
                boolean isDefaultIMApp = Boolean.parseBoolean(isDefaultIMAppString);
                if (RegistryHandler.isJitsiDefaultIMApp() != isDefaultIMApp) {
                    if (isDefaultIMApp) {
                        AddrBookActivator.setAsDefaultIMApplication();
                    } else {
                        AddrBookActivator.unsetDefaultIMApplication();
                    }
                }
            }
        }
        try {
            css = (ContactSourceService)Class.forName(cssClassName).newInstance();
            if (cssClassName.equals("net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookAddrBookContactSourceService")) {
                MsOutlookAddrBookContactSourceService contactSource = (MsOutlookAddrBookContactSourceService)css;
                MsOutlookAddrBookContactSourceService.initMAPI(contactSource.createNotificationDelegate());
            }
        }
        catch (Exception ex) {
            String msg = "Failed to instantiate " + cssClassName + ": " + ex.getMessage();
            logger.error((Object)msg);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)msg, (Throwable)ex);
            }
            return;
        }
        try {
            cssServiceRegistration = bundleContext.registerService(ContactSourceService.class.getName(), (Object)css, null);
        }
        finally {
            if (cssServiceRegistration == null) {
                if (css instanceof AsyncContactSourceService) {
                    ((AsyncContactSourceService)css).stop();
                }
                css = null;
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("Address book \"" + css.getDisplayName() + "\" ... [REGISTERED]"));
            }
        }
    }

    static void startCalendarService() {
        if (OSUtils.IS_WINDOWS && !AddrBookActivator.getConfigService().getBoolean("net.java.sip.communicator.service.calendar.FreeBusyStatus.disabled", false)) {
            calendarService = new CalendarServiceImpl();
            try {
                MsOutlookAddrBookContactSourceService.initMAPI(null);
            }
            catch (MsOutlookMAPIHResultException ex) {
                String msg = "Failed to initialize MAPI: " + ex.getMessage();
                logger.error((Object)msg);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)msg, (Throwable)ex);
                }
                return;
            }
            bundleContext.addServiceListener(serviceListener);
            for (ProtocolProviderService pps : AddrBookActivator.getProtocolProviders()) {
                if (pps.isRegistered()) continue;
                pps.addRegistrationStateChangeListener(providerListener);
            }
            bundleContext.registerService(CalendarService.class.getName(), (Object)calendarService, null);
            calendarService.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopCalendarService() {
        if (OSUtils.IS_WINDOWS && !AddrBookActivator.getConfigService().getBoolean("net.java.sip.communicator.service.calendar.FreeBusyStatus.disabled", false)) {
            bundleContext.removeServiceListener(serviceListener);
            List<ProtocolProviderService> list = providers;
            synchronized (list) {
                for (ProtocolProviderService pps : AddrBookActivator.getProtocolProviders()) {
                    pps.removeRegistrationStateChangeListener(providerListener);
                }
            }
            calendarService = null;
            MsOutlookAddrBookContactSourceService.UninitializeMAPI();
        }
    }

    static void stopService() {
        try {
            if (cssServiceRegistration != null) {
                cssServiceRegistration.unregister();
                cssServiceRegistration = null;
            }
        }
        finally {
            if (css != null) {
                if (css instanceof AsyncContactSourceService) {
                    ((AsyncContactSourceService)css).stop();
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Address book \"" + css.getDisplayName() + "\" ... [UNREGISTERED]"));
                }
                css = null;
            }
        }
    }

    public static void setAsDefaultIMApplication() {
        if (OSUtils.IS_WINDOWS) {
            RegistryHandler.setJitsiAsDefaultApp();
        }
    }

    public static void unsetDefaultIMApplication() {
        if (OSUtils.IS_WINDOWS) {
            RegistryHandler.unsetDefaultApp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProtocolProviderService> getProtocolProviders() {
        ArrayList<ProtocolProviderService> result;
        List<ProtocolProviderService> list = providers;
        synchronized (list) {
            ServiceReference[] ppsRefs;
            try {
                ppsRefs = bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
            }
            catch (InvalidSyntaxException ise) {
                ppsRefs = null;
            }
            if (ppsRefs != null && ppsRefs.length != 0) {
                for (ServiceReference ppsRef : ppsRefs) {
                    ProtocolProviderService pps = (ProtocolProviderService)bundleContext.getService(ppsRef);
                    providers.add(pps);
                }
            }
        }
        list = providers;
        synchronized (list) {
            result = new ArrayList<ProtocolProviderService>(providers);
        }
        return result;
    }

    public static PhoneNumberI18nService getPhoneNumberI18nService() {
        if (phoneNumberI18nService == null) {
            phoneNumberI18nService = (PhoneNumberI18nService)ServiceUtils.getService((BundleContext)bundleContext, PhoneNumberI18nService.class);
        }
        return phoneNumberI18nService;
    }

    static {
        calendarService = null;
        providers = new ArrayList<ProtocolProviderService>();
        providerListener = new RegistrationStateChangeListener(){

            public void registrationStateChanged(RegistrationStateChangeEvent ev) {
                if (ev.getNewState().equals((Object)RegistrationState.REGISTERED) && calendarService != null) {
                    calendarService.handleProviderAdded(ev.getProvider());
                }
            }
        };
        serviceListener = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceChanged(ServiceEvent ev) {
                Object service = bundleContext.getService(ev.getServiceReference());
                if (!(service instanceof ProtocolProviderService)) {
                    return;
                }
                ProtocolProviderService pps = (ProtocolProviderService)service;
                switch (ev.getType()) {
                    case 1: {
                        List list = providers;
                        synchronized (list) {
                            providers.add(pps);
                        }
                        if (pps.isRegistered()) break;
                        pps.addRegistrationStateChangeListener(providerListener);
                        break;
                    }
                    case 4: {
                        List list = providers;
                        synchronized (list) {
                            providers.remove(pps);
                        }
                        pps.removeRegistrationStateChangeListener(providerListener);
                    }
                }
            }
        };
    }
}

