/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.splashscreen;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class SplashScreenActivator
implements BundleActivator,
ServiceListener {
    private BundleContext bundleContext = null;
    private SplashScreen splash;
    private Graphics2D g;
    private int progress = 0;
    private Color TEXT_BACKGROUND = new Color(203, 202, 202);
    private Color TEXT_FOREGROUND = new Color(82, 82, 82);
    private Color PROGRESS_FOREGROUND = new Color(177, 174, 173);

    public void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.splash = SplashScreen.getSplashScreen();
        if (this.splash == null) {
            return;
        }
        this.g = this.splash.createGraphics();
        if (this.g == null) {
            return;
        }
        bundleContext.addServiceListener((ServiceListener)this);
    }

    public void stop(BundleContext bc) {
        bc.removeServiceListener((ServiceListener)this);
        this.g = null;
        this.splash = null;
        this.TEXT_BACKGROUND = null;
        this.TEXT_FOREGROUND = null;
        this.PROGRESS_FOREGROUND = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent serviceEvent) {
        if (this.splash == null) {
            return;
        }
        SplashScreen splashScreen = this.splash;
        synchronized (splashScreen) {
            try {
                if (!this.splash.isVisible()) {
                    this.stop(this.bundleContext);
                    return;
                }
                Bundle bundle = serviceEvent.getServiceReference().getBundle();
                if (bundle == null) {
                    return;
                }
                Object bundleName = bundle.getHeaders().get("Bundle-Name");
                if (bundleName == null) {
                    return;
                }
                Object service = this.bundleContext.getService(serviceEvent.getServiceReference());
                if (service.getClass().getSimpleName().equals("UIServiceImpl")) {
                    this.splash.close();
                    this.stop(this.bundleContext);
                    return;
                }
                this.bundleContext.ungetService(serviceEvent.getServiceReference());
                ++this.progress;
                int progressWidth = 233;
                int progressHeight = 14;
                int progressX = 168;
                int progressY = 97;
                int textHeight = 20;
                int textBaseX = 150;
                int textBaseY = 145 + (50 - textHeight) / 2 + textHeight;
                int currentProgressWidth = Math.min(2 * this.progress, progressWidth);
                this.g.setComposite(AlphaComposite.Clear);
                this.g.setPaintMode();
                this.g.setColor(this.TEXT_BACKGROUND);
                this.g.clearRect(textBaseX - 1, textBaseY - textHeight, (int)this.splash.getBounds().getWidth() - textBaseX, textHeight + 5);
                this.g.fillRect(textBaseX - 1, textBaseY - textHeight, (int)this.splash.getBounds().getWidth() - textBaseX, textHeight + 5);
                this.g.setColor(this.PROGRESS_FOREGROUND);
                this.g.fillRect(progressX, progressY, currentProgressWidth, progressHeight);
                this.g.drawRect(progressX, progressY, currentProgressWidth, progressHeight);
                this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                this.g.setColor(this.TEXT_FOREGROUND);
                this.g.drawString(bundleName.toString(), textBaseX, textBaseY);
                this.splash.update();
            }
            catch (Throwable e) {
                this.stop(this.bundleContext);
                return;
            }
        }
    }
}

