/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.contactsource;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupNode;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.SourceUIContact;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.customcontactactions.ContactAction;
import net.java.sip.communicator.service.customcontactactions.ContactActionMenuItem;
import net.java.sip.communicator.service.customcontactactions.CustomContactActionsService;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactSource;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.util.ConfigurationUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ExternalContactSource
implements UIContactSource {
    public static final String UI_CONTACT_DATA_KEY = SourceUIContact.class.getName() + ".uiContactDescriptor";
    private final SourceUIGroup sourceUIGroup;
    private final ContactSourceService contactSource;
    private static SourceContact customActionContact;
    private static Map<ContactAction<SourceContact>, SIPCommButton> customContactActionButtons;
    private static Map<ContactActionMenuItem<SourceContact>, JMenuItem> customContactActionMenuItems;
    private Map<ContactAction<ContactSourceService>, SIPCommButton> customServiceActionButtons;
    private final JTree contactListTree;
    private int contactSourceIndex;
    private Map<ContactActionMenuItem<ContactSourceService>, JMenuItem> customGroupActionMenuItems;

    public ExternalContactSource(ContactSourceService contactSource, JTree contactListTree) {
        this.contactSource = contactSource;
        this.contactListTree = contactListTree;
        this.contactSourceIndex = contactSource.getIndex();
        this.sourceUIGroup = new SourceUIGroup(contactSource.getDisplayName(), this);
    }

    public ContactSourceService getContactSourceService() {
        return this.contactSource;
    }

    public UIGroup getUIGroup() {
        return this.sourceUIGroup;
    }

    public UIContact createUIContact(SourceContact sourceContact) {
        SourceUIContact descriptor = new SourceUIContact(sourceContact, this.sourceUIGroup);
        sourceContact.setData((Object)UI_CONTACT_DATA_KEY, (Object)descriptor);
        return descriptor;
    }

    public void removeUIContact(SourceContact sourceContact) {
        sourceContact.setData((Object)UI_CONTACT_DATA_KEY, null);
    }

    public UIContact getUIContact(SourceContact sourceContact) {
        return (UIContact)sourceContact.getData((Object)UI_CONTACT_DATA_KEY);
    }

    public Collection<SIPCommButton> getContactCustomActionButtons(SourceContact sourceContact) {
        customActionContact = sourceContact;
        if (customContactActionButtons == null) {
            this.initCustomContactActionButtons();
        }
        Iterator<ContactAction<SourceContact>> customActionsIter = customContactActionButtons.keySet().iterator();
        LinkedList<SIPCommButton> availableCustomActionButtons = new LinkedList<SIPCommButton>();
        while (customActionsIter.hasNext()) {
            ContactAction<SourceContact> contactAction = customActionsIter.next();
            SIPCommButton actionButton = customContactActionButtons.get(contactAction);
            if (!ExternalContactSource.isContactActionVisible(contactAction, sourceContact)) continue;
            availableCustomActionButtons.add(actionButton);
        }
        return availableCustomActionButtons;
    }

    public Collection<JMenuItem> getContactCustomActionMenuItems(SourceContact sourceContact, boolean initActions) {
        customActionContact = sourceContact;
        if (initActions || customContactActionMenuItems == null) {
            this.initCustomContactActionMenuItems();
        }
        Iterator<ContactActionMenuItem<SourceContact>> customActionsIter = customContactActionMenuItems.keySet().iterator();
        LinkedList<JMenuItem> availableCustomActionMenuItems = new LinkedList<JMenuItem>();
        while (customActionsIter.hasNext()) {
            ContactActionMenuItem<SourceContact> contactAction = customActionsIter.next();
            JMenuItem actionMenuItem = customContactActionMenuItems.get(contactAction);
            if (!ExternalContactSource.isContactActionVisible(contactAction, sourceContact)) continue;
            availableCustomActionMenuItems.add(actionMenuItem);
        }
        return availableCustomActionMenuItems;
    }

    public Collection<JMenuItem> getGroupCustomActionMenuItems(boolean initActions) {
        if (initActions || this.customGroupActionMenuItems == null) {
            this.initCustomGroupActionMenuItems();
        }
        Iterator<ContactActionMenuItem<ContactSourceService>> customActionsIter = this.customGroupActionMenuItems.keySet().iterator();
        LinkedList<JMenuItem> availableCustomActionMenuItems = new LinkedList<JMenuItem>();
        while (customActionsIter.hasNext()) {
            ContactActionMenuItem<ContactSourceService> contactAction = customActionsIter.next();
            JMenuItem actionMenuItem = this.customGroupActionMenuItems.get(contactAction);
            if (!ExternalContactSource.isContactActionVisible(contactAction, this.contactSource)) continue;
            availableCustomActionMenuItems.add(actionMenuItem);
        }
        return availableCustomActionMenuItems;
    }

    private static boolean isContactActionVisible(ContactAction<SourceContact> contactAction, SourceContact contact) {
        return contactAction.isVisible((Object)contact);
    }

    private static boolean isContactActionVisible(ContactActionMenuItem<ContactSourceService> contactAction, ContactSourceService contactSource) {
        return contactAction.isVisible((Object)contactSource);
    }

    private static boolean isContactActionVisible(ContactActionMenuItem<SourceContact> contactAction, SourceContact contact) {
        return contactAction.isVisible((Object)contact);
    }

    private void initCustomContactActionButtons() {
        customContactActionButtons = new LinkedHashMap<ContactAction<SourceContact>, SIPCommButton>();
        for (CustomContactActionsService<SourceContact> ccas : this.getContactActionsServices()) {
            Iterator actionIterator = ccas.getCustomContactActions();
            if (actionIterator == null) continue;
            while (actionIterator.hasNext()) {
                ContactAction ca = (ContactAction)actionIterator.next();
                this.initActionButton(ca, SourceContact.class);
            }
        }
    }

    private void initCustomContactActionMenuItems() {
        customContactActionMenuItems = new LinkedHashMap<ContactActionMenuItem<SourceContact>, JMenuItem>();
        for (CustomContactActionsService<SourceContact> ccas : this.getContactActionsServices()) {
            Iterator actionIterator = ccas.getCustomContactActionsMenuItems();
            if (actionIterator == null) continue;
            while (actionIterator.hasNext()) {
                ContactActionMenuItem ca = (ContactActionMenuItem)actionIterator.next();
                this.initActionMenuItem((ContactActionMenuItem<SourceContact>)ca);
            }
        }
    }

    private void initCustomGroupActionMenuItems() {
        this.customGroupActionMenuItems = new LinkedHashMap<ContactActionMenuItem<ContactSourceService>, JMenuItem>();
        for (CustomContactActionsService<ContactSourceService> ccas : this.getGroupActionsServices()) {
            Iterator actionIterator = ccas.getCustomContactActionsMenuItems();
            if (actionIterator == null) continue;
            while (actionIterator.hasNext()) {
                ContactActionMenuItem ca = (ContactActionMenuItem)actionIterator.next();
                this.initGroupActionMenuItem((ContactActionMenuItem<ContactSourceService>)ca);
            }
        }
    }

    private void initCustomServiceActionButtons() {
        this.customServiceActionButtons = new LinkedHashMap<ContactAction<ContactSourceService>, SIPCommButton>();
        for (CustomContactActionsService<ContactSourceService> ccas : this.getCustomActionsContactServices()) {
            Iterator actionIterator = ccas.getCustomContactActions();
            while (actionIterator != null && actionIterator.hasNext()) {
                ContactAction ca = (ContactAction)actionIterator.next();
                this.initActionButton(ca, ContactSourceService.class);
            }
        }
    }

    private <T> void initActionButton(final ContactAction<T> ca, final Class<T> contactSourceClass) {
        SIPCommButton actionButton;
        if (contactSourceClass.equals(SourceContact.class)) {
            actionButton = customContactActionButtons.get(ca);
        } else if (contactSourceClass.equals(ContactSourceService.class)) {
            actionButton = this.customServiceActionButtons.get(ca);
        } else {
            return;
        }
        if (actionButton == null) {
            actionButton = new SIPCommButton();
            actionButton.setToolTipText(ca.getToolTipText());
            actionButton.setIconImage(new ImageIcon(ca.getIcon()).getImage());
            actionButton.setRolloverIcon(new ImageIcon(ca.getRolloverIcon()).getImage());
            actionButton.setPressedIcon(new ImageIcon(ca.getPressedIcon()).getImage());
            actionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        JButton button = (JButton)event.getSource();
                        Point location = new Point(button.getX(), button.getY() + button.getHeight());
                        SwingUtilities.convertPointToScreen(location, ExternalContactSource.this.contactListTree);
                        TreePath selectionPath = ExternalContactSource.this.contactListTree.getSelectionPath();
                        if (selectionPath != null) {
                            location.y += ((ExternalContactSource)ExternalContactSource.this).contactListTree.getPathBounds((TreePath)selectionPath).y;
                        }
                        if (contactSourceClass.equals(SourceContact.class)) {
                            SourceContact t = customActionContact;
                            ca.actionPerformed((Object)t, location.x, location.y);
                        } else if (contactSourceClass.equals(ContactSourceService.class)) {
                            ContactSourceService t = ExternalContactSource.this.contactSource;
                            ca.actionPerformed((Object)t, location.x, location.y);
                        }
                    }
                    catch (OperationFailedException e) {
                        new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), e.getMessage());
                    }
                }
            });
            if (contactSourceClass.equals(SourceContact.class)) {
                ContactAction<T> casc = ca;
                customContactActionButtons.put(casc, actionButton);
            } else if (contactSourceClass.equals(ContactSourceService.class)) {
                ContactAction<T> cacss = ca;
                this.customServiceActionButtons.put(cacss, actionButton);
            }
        }
    }

    private void initActionMenuItem(final ContactActionMenuItem<SourceContact> ca) {
        JMenuItem actionMenuItem = customContactActionMenuItems.get(ca);
        if (actionMenuItem == null) {
            actionMenuItem = ca.isCheckBox() ? new JCheckBoxMenuItem() : new JMenuItem();
            actionMenuItem.setText(ca.getText((Object)customActionContact));
            actionMenuItem.setMnemonic(ca.getMnemonics());
            byte[] icon = ca.getIcon();
            if (icon != null) {
                actionMenuItem.setIcon(new ImageIcon(icon));
            }
            actionMenuItem.setSelected(ca.isSelected((Object)customActionContact));
            actionMenuItem.setEnabled(ca.isEnabled((Object)customActionContact));
            actionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        ca.actionPerformed((Object)customActionContact);
                    }
                    catch (OperationFailedException e) {
                        new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), e.getMessage());
                    }
                }
            });
            customContactActionMenuItems.put(ca, actionMenuItem);
        }
    }

    private void initGroupActionMenuItem(final ContactActionMenuItem<ContactSourceService> ca) {
        JMenuItem actionMenuItem = this.customGroupActionMenuItems.get(ca);
        if (actionMenuItem == null) {
            actionMenuItem = ca.isCheckBox() ? new JCheckBoxMenuItem() : new JMenuItem();
            actionMenuItem.setText(ca.getText((Object)this.contactSource));
            actionMenuItem.setMnemonic(ca.getMnemonics());
            byte[] icon = ca.getIcon();
            if (icon != null) {
                actionMenuItem.setIcon(new ImageIcon(icon));
            }
            actionMenuItem.setSelected(ca.isSelected((Object)this.contactSource));
            actionMenuItem.setEnabled(ca.isEnabled((Object)this.contactSource));
            actionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        ca.actionPerformed((Object)ExternalContactSource.this.contactSource);
                    }
                    catch (OperationFailedException e) {
                        new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), e.getMessage());
                    }
                }
            });
            this.customGroupActionMenuItems.put(ca, actionMenuItem);
        }
    }

    private List<CustomContactActionsService<SourceContact>> getContactActionsServices() {
        ArrayList<CustomContactActionsService<SourceContact>> contactActionsServices = new ArrayList<CustomContactActionsService<SourceContact>>();
        ServiceReference[] serRefs = null;
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(CustomContactActionsService.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                CustomContactActionsService customActionService = (CustomContactActionsService)GuiActivator.bundleContext.getService(serRef);
                if (!customActionService.getContactSourceClass().equals(SourceContact.class)) continue;
                contactActionsServices.add((CustomContactActionsService<SourceContact>)customActionService);
            }
        }
        GuiActivator.bundleContext.addServiceListener(new ContactActionsServiceListener<SourceContact>(SourceContact.class));
        return contactActionsServices;
    }

    private List<CustomContactActionsService<ContactSourceService>> getGroupActionsServices() {
        ArrayList<CustomContactActionsService<ContactSourceService>> contactActionsServices = new ArrayList<CustomContactActionsService<ContactSourceService>>();
        ServiceReference[] serRefs = null;
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(CustomContactActionsService.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                CustomContactActionsService customActionService = (CustomContactActionsService)GuiActivator.bundleContext.getService(serRef);
                if (!customActionService.getContactSourceClass().equals(ContactSourceService.class)) continue;
                contactActionsServices.add((CustomContactActionsService<ContactSourceService>)customActionService);
            }
        }
        GuiActivator.bundleContext.addServiceListener(new ContactActionsServiceListener<SourceContact>(SourceContact.class));
        return contactActionsServices;
    }

    private List<CustomContactActionsService<ContactSourceService>> getCustomActionsContactServices() {
        ArrayList<CustomContactActionsService<ContactSourceService>> contactActionsServices = new ArrayList<CustomContactActionsService<ContactSourceService>>();
        ServiceReference[] serRefs = null;
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(CustomContactActionsService.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                CustomContactActionsService customActionService = (CustomContactActionsService)GuiActivator.bundleContext.getService(serRef);
                if (!customActionService.getContactSourceClass().equals(ContactSourceService.class)) continue;
                contactActionsServices.add((CustomContactActionsService<ContactSourceService>)customActionService);
            }
        }
        GuiActivator.bundleContext.addServiceListener(new ContactActionsServiceListener<ContactSourceService>(ContactSourceService.class));
        return contactActionsServices;
    }

    public void setContactSourceIndex(int contactSourceIndex) {
        this.contactSourceIndex = contactSourceIndex;
    }

    private class ContactActionsServiceListener<T>
    implements ServiceListener {
        private final Class<T> contactSourceClass;

        ContactActionsServiceListener(Class<T> contactSourceClass) {
            this.contactSourceClass = contactSourceClass;
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference serviceRef = event.getServiceReference();
            if (serviceRef.getBundle().getState() == 16) {
                return;
            }
            Object service = GuiActivator.bundleContext.getService(serviceRef);
            if (!(service instanceof CustomContactActionsService)) {
                return;
            }
            CustomContactActionsService cContactActionsService = (CustomContactActionsService)service;
            if (!cContactActionsService.getContactSourceClass().equals(this.contactSourceClass)) {
                return;
            }
            Iterator actionIterator = cContactActionsService.getCustomContactActions();
            while (actionIterator != null && actionIterator.hasNext()) {
                ContactAction ca = (ContactAction)actionIterator.next();
                switch (event.getType()) {
                    case 1: {
                        ExternalContactSource.this.initActionButton(ca, this.contactSourceClass);
                        break;
                    }
                    case 4: {
                        if (this.contactSourceClass.equals(SourceContact.class)) {
                            customContactActionButtons.remove(ca);
                            break;
                        }
                        if (!this.contactSourceClass.equals(ContactSourceService.class)) break;
                        ExternalContactSource.this.customServiceActionButtons.remove(ca);
                    }
                }
            }
        }
    }

    private class SourceGroupRightButtonMenu
    extends SIPCommPopupMenu {
        private static final long serialVersionUID = 0L;

        public SourceGroupRightButtonMenu() {
            for (JMenuItem item : ExternalContactSource.this.getGroupCustomActionMenuItems(true)) {
                this.add(item);
            }
        }
    }

    public class SourceUIGroup
    extends UIGroupImpl {
        private final String displayName;
        private GroupNode groupNode;
        private ExternalContactSource parentUISource;

        public SourceUIGroup(String name, ExternalContactSource parentUISource) {
            this.displayName = name;
            this.parentUISource = parentUISource;
        }

        public ExternalContactSource getParentUISource() {
            return this.parentUISource;
        }

        public UIGroup getParentGroup() {
            return null;
        }

        public int getSourceIndex() {
            if (ExternalContactSource.this.contactSourceIndex >= 0) {
                return ExternalContactSource.this.contactSourceIndex * MAX_GROUPS;
            }
            if (ExternalContactSource.this.contactSource.getType() == 2) {
                return Integer.MAX_VALUE - MAX_GROUPS;
            }
            return Integer.MAX_VALUE - MAX_GROUPS - 1;
        }

        public boolean isGroupCollapsed() {
            return ConfigurationUtils.isContactListGroupCollapsed((String)this.getId());
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int countChildContacts() {
            return -1;
        }

        public int countOnlineChildContacts() {
            return -1;
        }

        public Object getDescriptor() {
            return ExternalContactSource.this.contactSource;
        }

        public String getId() {
            return this.getDisplayName();
        }

        @Override
        public GroupNode getGroupNode() {
            return this.groupNode;
        }

        @Override
        public void setGroupNode(GroupNode groupNode) {
            this.groupNode = groupNode;
        }

        public JPopupMenu getRightButtonMenu() {
            if (ExternalContactSource.this.getGroupCustomActionMenuItems(false).isEmpty()) {
                return null;
            }
            return new SourceGroupRightButtonMenu();
        }

        public Collection<SIPCommButton> getCustomActionButtons() {
            if (ExternalContactSource.this.customServiceActionButtons == null) {
                ExternalContactSource.this.initCustomServiceActionButtons();
            }
            Iterator customActionsIter = ExternalContactSource.this.customServiceActionButtons.keySet().iterator();
            LinkedList<SIPCommButton> availableCustomActionButtons = new LinkedList<SIPCommButton>();
            while (customActionsIter.hasNext()) {
                ContactAction contactAction = (ContactAction)customActionsIter.next();
                SIPCommButton actionButton = (SIPCommButton)ExternalContactSource.this.customServiceActionButtons.get(contactAction);
                if (!contactAction.isVisible((Object)ExternalContactSource.this.contactSource)) continue;
                availableCustomActionButtons.add(actionButton);
            }
            return availableCustomActionButtons;
        }
    }
}

