/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call.conference;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenuBar;
import net.java.sip.communicator.plugin.desktoputil.SelectedObject;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;

public class ProtocolProviderSelectorBox
extends SIPCommMenuBar
implements ActionListener,
Skinnable {
    private static final Logger logger = Logger.getLogger(ProtocolProviderSelectorBox.class);
    private static final long serialVersionUID = 0L;
    private final Map<ProtocolProviderService, JMenuItem> providerMenuItems = new Hashtable<ProtocolProviderService, JMenuItem>();
    private final SIPCommMenu menu = new SelectorMenu();
    private ProtocolProviderService lastSelectedProvider = null;

    public ProtocolProviderSelectorBox(Iterator<ProtocolProviderService> providers) {
        this.setPreferredSize(new Dimension(30, 28));
        this.setMaximumSize(new Dimension(30, 28));
        this.setMinimumSize(new Dimension(30, 28));
        this.menu.setPreferredSize(new Dimension(30, 45));
        this.menu.setMaximumSize(new Dimension(30, 45));
        this.add((JMenu)this.menu);
        this.setBorder(null);
        this.menu.setBorder(null);
        this.menu.setOpaque(false);
        this.setOpaque(false);
        this.menu.setEnabled(false);
        ProtocolProviderService defaultProvider = null;
        while (providers.hasNext()) {
            ProtocolProviderService provider = providers.next();
            if (defaultProvider == null) {
                defaultProvider = provider;
            }
            this.addProtocolProviderService(provider);
        }
        this.setSelected(defaultProvider);
    }

    private void updateEnableStatus() {
        this.menu.setEnabled(this.menu.getItemCount() > 0);
    }

    public void addProtocolProviderService(ProtocolProviderService provider) {
        if (provider.getOperationSet(OperationSetBasicTelephony.class) != null) {
            Image img = this.createProviderImage(provider);
            JMenuItem menuItem = new JMenuItem("Via: " + provider.getAccountID().getDisplayName(), new ImageIcon(img));
            menuItem.addActionListener(this);
            this.providerMenuItems.put(provider, menuItem);
            this.menu.add(menuItem);
            this.updateEnableStatus();
        }
    }

    public void removeProtocolProviderService(ProtocolProviderService provider) {
        this.menu.remove(this.providerMenuItems.get(provider));
        this.providerMenuItems.remove(provider);
        this.updateEnableStatus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        for (Map.Entry<ProtocolProviderService, JMenuItem> providerMenuItem : this.providerMenuItems.entrySet()) {
            ProtocolProviderService provider = providerMenuItem.getKey();
            if (!providerMenuItem.getValue().equals(menuItem)) continue;
            this.setSelected(provider, (ImageIcon)menuItem.getIcon());
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Could not find contact for menu item " + menuItem.getText() + ". contactsTable(" + this.providerMenuItems.size() + ") is : " + this.providerMenuItems));
        }
    }

    public Image createProviderImage(ProtocolProviderService provider) {
        return ImageLoader.getIndexedProtocolImage(ImageUtils.getBytesInImage((byte[])provider.getProtocolIcon().getIcon("IconSize16x16")), provider);
    }

    private void setSelected(ProtocolProviderService provider, ImageIcon icon) {
        this.lastSelectedProvider = provider;
        SelectedObject selectedObject = new SelectedObject((Icon)icon, (Object)provider);
        this.menu.setSelected(selectedObject);
    }

    public void setSelected(ProtocolProviderService provider) {
        this.setSelected(provider, new ImageIcon(this.createProviderImage(provider)));
    }

    public SIPCommMenu getMenu() {
        return this.menu;
    }

    public ProtocolProviderService getSelectedProvider() {
        return this.lastSelectedProvider;
    }

    private class SelectorMenu
    extends SIPCommMenu {
        private static final long serialVersionUID = 0L;
        Image image = ImageLoader.getImage(ImageLoader.DOWN_ARROW_ICON);

        private SelectorMenu() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.image, this.getWidth() - this.image.getWidth((ImageObserver)((Object)this)) - 1, (this.getHeight() - this.image.getHeight((ImageObserver)((Object)this)) - 1) / 2, (ImageObserver)((Object)this));
        }
    }
}

