/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ImEncodingParams;

public final class EncodedStringInfo {
    private final String charset;
    private final byte[] data;

    public EncodedStringInfo(String charset, byte[] data) {
        DefensiveTools.checkNull(charset, "charset");
        DefensiveTools.checkNull(data, "data");
        this.charset = charset;
        this.data = (byte[])data.clone();
    }

    public final String getCharset() {
        return this.charset;
    }

    public final ImEncodingParams getImEncoding() {
        int charsetCode = this.charset == "us-ascii" ? 0 : (this.charset == "iso-8859-1" ? 3 : (this.charset == "utf-16be" ? 2 : 0));
        int charsetSubcode = 0;
        return new ImEncodingParams(charsetCode, charsetSubcode);
    }

    public final byte[] getData() {
        return (byte[])this.data.clone();
    }

    public String toString() {
        return "EncodedStringInfo: charset=" + this.charset + ", data=" + BinaryTools.describeData(ByteBlock.wrap(this.data));
    }
}

