/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.negotiators;

import com.ircclouds.irc.api.negotiators.api.Relay;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public class SaslContext {
    private static final String AUTHENTICATE = "AUTHENTICATE ";
    private static final String AUTHENTICATE_ABORT = "AUTHENTICATE *";
    private final Relay relay;
    private AbstractState state;

    public SaslContext(Relay relay) {
        if (relay == null) {
            throw new NullPointerException("relay");
        }
        this.relay = relay;
        this.state = new InitialState();
    }

    private void setState(AbstractState state) {
        if (state == null) {
            throw new NullPointerException("state");
        }
        this.state = state;
    }

    public void init() {
        this.state.init(this);
    }

    public void confirm(String parameters, String authzid, String user, String pass) {
        this.state.confirm(this, parameters, authzid, user, pass);
    }

    public void loggedIn() {
        this.state.loggedIn(this);
    }

    public void success() {
        this.state.success(this);
    }

    public void fail() {
        this.state.fail(this);
    }

    public void abort() {
        this.state.abort(this);
    }

    private static final class SaslConfirmed
    extends AbstractState {
        private boolean loggedIn = false;
        private boolean successful = false;

        private SaslConfirmed() {
        }

        @Override
        void init(SaslContext context) {
            throw new IllegalStateException("SASL already initialized. Awaiting confirmation of successful log in.");
        }

        @Override
        void confirm(SaslContext context, String parameters, String authzid, String user, String pass) {
        }

        @Override
        void loggedIn(SaslContext context) {
            this.loggedIn = true;
        }

        @Override
        void success(SaslContext context) {
            this.successful = true;
        }

        @Override
        void fail(SaslContext context) {
            this.abort(context);
        }

        @Override
        void abort(SaslContext context) {
            if (this.loggedIn || this.successful) {
                return;
            }
            context.relay.send(SaslContext.AUTHENTICATE_ABORT);
            context.setState(new InitialState());
        }
    }

    private static final class SaslInitiate
    extends AbstractState {
        private SaslInitiate() {
        }

        @Override
        void init(SaslContext context) {
            throw new IllegalStateException("SASL already initialized. Awaiting acceptance of AUTHENTICATE proposal.");
        }

        @Override
        void confirm(SaslContext context, String parameters, String authzid, String user, String pass) {
            context.relay.send(this.createAuthenticateMessage(authzid, user, pass));
            context.setState(new SaslConfirmed());
        }

        private String createAuthenticateMessage(String authzid, String user, String pass) {
            String msg = SaslContext.AUTHENTICATE + SaslInitiate.encode(authzid, user, pass);
            if (msg.length() <= 400) {
                return msg;
            }
            return msg.substring(0, 400);
        }

        protected static String encode(String authzid, String user, String pass) {
            StringBuilder response = new StringBuilder();
            if (authzid != null) {
                response.append(authzid);
            }
            response.append('\u0000').append(user).append('\u0000').append(pass);
            try {
                return new String(Base64.encodeBase64((byte[])response.toString().getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Unsupported encoding specified.", e);
            }
        }

        @Override
        void loggedIn(SaslContext context) {
            throw new IllegalStateException("SASL not confirmed yet. Awaiting acceptance of AUTHENTICATE proposal.");
        }

        @Override
        void success(SaslContext context) {
            throw new IllegalStateException("SASL not confirmed yet. Awaiting acceptance of AUTHENTICATE proposal.");
        }

        @Override
        void fail(SaslContext context) {
            this.abort(context);
        }

        @Override
        void abort(SaslContext context) {
            context.relay.send(SaslContext.AUTHENTICATE_ABORT);
            context.setState(new InitialState());
        }
    }

    private static final class InitialState
    extends AbstractState {
        private InitialState() {
        }

        @Override
        void init(SaslContext context) {
            context.relay.send("AUTHENTICATE PLAIN");
            context.setState(new SaslInitiate());
        }

        @Override
        void confirm(SaslContext context, String parameters, String authzid, String user, String pass) {
            throw new IllegalStateException("SASL not initiated. Awaiting initiation of request.");
        }

        @Override
        void loggedIn(SaslContext context) {
            throw new IllegalStateException("SASL not initiated. Awaiting initiation of request.");
        }

        @Override
        void success(SaslContext context) {
            throw new IllegalStateException("SASL not initiated. Awaiting initiation of request.");
        }

        @Override
        void fail(SaslContext context) {
            throw new IllegalStateException("SASL not initiated. Awaiting initiation of request.");
        }

        @Override
        void abort(SaslContext context) {
            throw new IllegalStateException("SASL not initiated. Awaiting initiation of request.");
        }
    }

    private static abstract class AbstractState {
        private AbstractState() {
        }

        abstract void init(SaslContext var1);

        abstract void confirm(SaslContext var1, String var2, String var3, String var4, String var5);

        abstract void loggedIn(SaslContext var1);

        abstract void success(SaslContext var1);

        abstract void fail(SaslContext var1);

        abstract void abort(SaslContext var1);
    }
}

