/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.httputil;

import com.google.common.collect.Lists;
import com.google.gdata.util.common.base.StringUtil;
import com.google.gdata.util.httputil.ParamMap;
import com.google.gdata.util.parser.Chset;
import com.google.gdata.util.parser.Parser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;

public class FormUrlDecoder {
    private static Parser<Result> parser;

    private FormUrlDecoder() {
    }

    @Deprecated
    public static void parseWithCallback(String str, String encoding, Callback callback) {
        if (StringUtil.isEmpty(str)) {
            return;
        }
        Result result = new Result(encoding);
        parser.parse(str, result);
        for (Parameter param : result.params) {
            callback.handleParameter(param.name, param.value);
        }
    }

    @Deprecated
    public static ParamMap parse(String str, ParamMap map, String encoding) {
        if ("".equals(str)) {
            return map == null ? new ParamMap() : map;
        }
        final AtomicReference<ParamMap> outMap = new AtomicReference<ParamMap>(map);
        FormUrlDecoder.parseWithCallback(str, encoding, new Callback(){

            @Override
            public void handleParameter(String name, String value) {
                ParamMap map = (ParamMap)outMap.get();
                if (map == null) {
                    map = new ParamMap();
                    outMap.set(map);
                }
                map.append(name, value);
            }
        });
        return outMap.get();
    }

    private static String getCanonicalEncodingName(String charset) {
        String canonicalName = charset;
        if (charset != null && charset.length() > 0) {
            try {
                canonicalName = Charset.forName(charset).name();
            }
            catch (UnsupportedCharsetException uce) {
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
        return canonicalName;
    }

    private static String decodeString(char[] buf, int start, int end, String encoding) {
        String str = new String(buf, start, end - start);
        try {
            if (FormUrlDecoder.requiresByteLevelDecoding(encoding)) {
                byte[] rawBytes = URLDecoder.decode(str, "ISO-8859-1").getBytes("ISO-8859-1");
                return new String(rawBytes, encoding);
            }
            return URLDecoder.decode(str, encoding);
        }
        catch (IllegalArgumentException iae) {
            return str;
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    private static boolean requiresByteLevelDecoding(String encoding) {
        return (encoding = FormUrlDecoder.getCanonicalEncodingName(encoding).toUpperCase()).endsWith("SHIFT_JIS") || encoding.endsWith("WINDOWS-31J");
    }

    static {
        Chset nameToken = Chset.difference(Chset.ANYCHAR, new Chset("&="));
        Chset valueToken = Chset.difference(Chset.ANYCHAR, new Chset("&"));
        Parser<Result> name = nameToken.star().action(new NameAction());
        Parser<Result> value = valueToken.plus().action(new ValueAction());
        value = value.optional();
        value = Parser.sequence(new Chset('='), value);
        Parser<Result> parameter = Parser.sequence(name, value.optional());
        parser = parameter.list(new Chset('&')).optional();
    }

    private static class Parameter {
        String name = null;
        String value = "";

        private Parameter() {
        }
    }

    private static class ValueAction
    implements com.google.gdata.util.parser.Callback<Result> {
        private ValueAction() {
        }

        @Override
        public void handle(char[] buf, int start, int end, Result result) {
            Parameter param = result.params.getLast();
            param.value = FormUrlDecoder.decodeString(buf, start, end, result.encoding);
        }
    }

    private static class NameAction
    implements com.google.gdata.util.parser.Callback<Result> {
        private NameAction() {
        }

        @Override
        public void handle(char[] buf, int start, int end, Result result) {
            Parameter param = new Parameter();
            param.name = FormUrlDecoder.decodeString(buf, start, end, result.encoding);
            result.params.addLast(param);
        }
    }

    @Deprecated
    public static interface Callback {
        public void handleParameter(String var1, String var2);
    }

    private static class Result {
        LinkedList<Parameter> params = Lists.newLinkedList();
        String encoding;

        public Result(String encoding) {
            this.encoding = encoding == null ? "ISO-8859-1" : encoding;
        }
    }
}

