/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.net;

import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.SipStackImpl;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.net.RFC5922Matcher;
import net.java.sip.communicator.service.certificate.CertificateMatcher;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.protocol.sip.SipAccountID;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.ServiceReference;

public class SslNetworkLayer
implements NetworkLayer {
    private static final Logger logger = Logger.getLogger(SslNetworkLayer.class);
    private static final String SIP_DSCP_PROPERTY = "net.java.sip.communicator.impl.protocol.SIP_DSCP";
    private CertificateService certificateVerification = null;

    public SslNetworkLayer() {
        ServiceReference guiVerifyReference = SipActivator.getBundleContext().getServiceReference(CertificateService.class.getName());
        if (guiVerifyReference != null) {
            this.certificateVerification = (CertificateService)SipActivator.getBundleContext().getService(guiVerifyReference);
        }
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        ServerSocket sock = new ServerSocket(port, backlog, bindAddress);
        return sock;
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        Socket sock = new Socket(address, port);
        this.setTrafficClass(sock);
        return sock;
    }

    public DatagramSocket createDatagramSocket() throws SocketException {
        DatagramSocket sock = new DatagramSocket();
        this.setTrafficClass(sock);
        return sock;
    }

    public DatagramSocket createDatagramSocket(int port, InetAddress laddr) throws SocketException {
        DatagramSocket sock = new DatagramSocket(port, laddr);
        this.setTrafficClass(sock);
        return sock;
    }

    public SSLServerSocket createSSLServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        SSLServerSocket sock = (SSLServerSocket)this.getSSLServerSocketFactory().createServerSocket(port, backlog, bindAddress);
        return sock;
    }

    protected SSLServerSocketFactory getSSLServerSocketFactory() throws IOException {
        try {
            return this.certificateVerification.getSSLContext().getServerSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
    }

    private SSLSocketFactory getSSLSocketFactory(InetAddress address) throws IOException {
        ProtocolProviderServiceSipImpl provider = null;
        for (ProtocolProviderServiceSipImpl pps : ProtocolProviderServiceSipImpl.getAllInstances()) {
            if (pps.getConnection() == null || !pps.getConnection().isSameInetAddress(address)) continue;
            provider = pps;
            break;
        }
        if (provider == null) {
            throw new IOException("The provider that requested the SSL Socket could not be found");
        }
        try {
            String userID;
            int index;
            ArrayList<String> identities = new ArrayList<String>(2);
            SipAccountID id = (SipAccountID)provider.getAccountID();
            if (!id.getAccountPropertyBoolean((Object)"PROXY_AUTO_CONFIG", false)) {
                String proxy = id.getAccountPropertyString((Object)"PROXY_ADDRESS");
                if (proxy != null) {
                    identities.add(proxy);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added <" + proxy + "> to list of valid SIP TLS server identities."));
                }
            }
            if ((index = (userID = id.getAccountPropertyString((Object)"USER_ID")).indexOf(64)) > -1) {
                identities.add(userID.substring(index + 1));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added <" + userID.substring(index + 1) + "> to list of valid SIP TLS server identities."));
                }
            }
            return this.certificateVerification.getSSLContext(id.getAccountPropertyString((Object)"CLIENT_TLS_CERTIFICATE"), this.certificateVerification.getTrustManager(identities, null, (CertificateMatcher)new RFC5922Matcher(provider))).getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
    }

    public SSLSocket createSSLSocket(InetAddress address, int port) throws IOException {
        SSLSocket sock = (SSLSocket)this.getSSLSocketFactory(address).createSocket(address, port);
        this.setTrafficClass(sock);
        return sock;
    }

    public SSLSocket createSSLSocket(InetAddress address, int port, InetAddress myAddress) throws IOException {
        SSLSocket sock = (SSLSocket)this.getSSLSocketFactory(address).createSocket(address, port, myAddress, 0);
        this.setTrafficClass(sock);
        return sock;
    }

    public Socket createSocket(InetAddress address, int port, InetAddress myAddress) throws IOException {
        Socket sock = null;
        sock = myAddress != null ? new Socket(address, port, myAddress, 0) : new Socket(address, port);
        this.setTrafficClass(sock);
        return sock;
    }

    public Socket createSocket(InetAddress address, int port, InetAddress myAddress, int myPort) throws IOException {
        Socket sock = null;
        if (myAddress != null) {
            sock = new Socket(address, port, myAddress, myPort);
        } else if (port != 0) {
            sock = new Socket();
            sock.bind(new InetSocketAddress(port));
            sock.connect(new InetSocketAddress(address, port));
        } else {
            sock = new Socket(address, port);
        }
        this.setTrafficClass(sock);
        return sock;
    }

    protected void setTrafficClass(Socket s) {
        int tc = this.getDSCP();
        try {
            s.setTrafficClass(tc);
        }
        catch (SocketException e) {
            logger.warn((Object)"Failed to set traffic class on Socket", (Throwable)e);
        }
    }

    protected void setTrafficClass(DatagramSocket s) {
        int tc = this.getDSCP();
        try {
            s.setTrafficClass(tc);
        }
        catch (SocketException e) {
            logger.warn((Object)"Failed to set traffic class on DatagramSocket", (Throwable)e);
        }
    }

    private int getDSCP() {
        ConfigurationService configService = SipActivator.getConfigurationService();
        String dscp = (String)configService.getProperty(SIP_DSCP_PROPERTY);
        if (dscp != null) {
            return Integer.parseInt(dscp) << 2;
        }
        return 0;
    }

    public void setSipStack(SipStackImpl sipStack) {
    }
}

