/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.ListeningPointExt;
import gov.nist.javax.sip.header.AllowEvents;
import gov.nist.javax.sip.header.AllowEventsList;
import gov.nist.javax.sip.header.SIPHeader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorAdapter;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipMessageFactory;
import net.java.sip.communicator.impl.protocol.sip.SipStackSharing;
import net.java.sip.communicator.impl.protocol.sip.net.ProxyConnection;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.OSUtils;

public class ClientCapabilities
extends MethodProcessorAdapter {
    private static final Logger logger = Logger.getLogger(ClientCapabilities.class);
    private final ProtocolProviderServiceSipImpl provider;
    private final RegistrationListener registrationListener;
    private Timer keepAliveTimer = null;
    private long nextCSeqValue = 1L;

    public ClientCapabilities(ProtocolProviderServiceSipImpl protocolProvider) {
        this.provider = protocolProvider;
        this.provider.registerMethodProcessor("OPTIONS", this);
        this.registrationListener = new RegistrationListener();
        this.provider.addRegistrationStateChangeListener(this.registrationListener);
    }

    @Override
    public boolean processRequest(RequestEvent requestEvent) {
        Response optionsOK = null;
        try {
            optionsOK = this.provider.getMessageFactory().createResponse(200, requestEvent.getRequest());
            for (String method : this.provider.getSupportedMethods()) {
                if (method.equals("REGISTER")) continue;
                optionsOK.addHeader((Header)this.provider.getHeaderFactory().createAllowHeader(method));
            }
            this.addAllowEventsHeader((Message)optionsOK);
        }
        catch (ParseException ex) {
            logger.warn((Object)"Failed to create an incoming OPTIONS request", (Throwable)ex);
            return false;
        }
        try {
            SipStackSharing.getOrCreateServerTransaction(requestEvent).sendResponse(optionsOK);
        }
        catch (TransactionUnavailableException ex) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Failed to respond to an incoming transactionless OPTIONS request");
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Exception was:", (Throwable)ex);
            }
            return false;
        }
        catch (InvalidArgumentException ex) {
            logger.warn((Object)"Failed to send an incoming OPTIONS request", (Throwable)ex);
            return false;
        }
        catch (SipException ex) {
            logger.warn((Object)"Failed to send an incoming OPTIONS request", (Throwable)ex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllowEventsHeader(Message message) throws ParseException {
        List<String> knownEventsList = this.provider.getKnownEventsList();
        AllowEventsList eventsList = new AllowEventsList();
        List<String> list = knownEventsList;
        synchronized (list) {
            for (String event : knownEventsList) {
                eventsList.add((SIPHeader)((AllowEvents)this.provider.getHeaderFactory().createAllowEventsHeader(event)));
            }
        }
        message.setHeader((Header)eventsList);
    }

    private long getNextCSeqValue() {
        return this.nextCSeqValue++;
    }

    private void disconnect() {
        if (this.provider.getRegistrationState().equals((Object)RegistrationState.UNREGISTERED)) {
            return;
        }
        this.provider.getRegistrarConnection().setRegistrationState(RegistrationState.CONNECTION_FAILED, -1, "A timeout occurred while trying to connect to the server.");
    }

    void shutdown() {
        this.provider.removeRegistrationStateChangeListener(this.registrationListener);
    }

    private class RegistrationListener
    implements RegistrationStateChangeListener {
        private RegistrationListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (evt.getNewState() == RegistrationState.UNREGISTERING || evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
                if (ClientCapabilities.this.keepAliveTimer != null) {
                    ClientCapabilities.this.keepAliveTimer.cancel();
                    ClientCapabilities.this.keepAliveTimer = null;
                }
            } else if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
                String keepAliveMethod = ClientCapabilities.this.provider.getAccountID().getAccountPropertyString((Object)"KEEP_ALIVE_METHOD");
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Keep alive method " + keepAliveMethod));
                }
                if (keepAliveMethod != null && !keepAliveMethod.equalsIgnoreCase("options") && !keepAliveMethod.equalsIgnoreCase("crlf")) {
                    return;
                }
                int keepAliveInterval = ClientCapabilities.this.provider.getAccountID().getAccountPropertyInt((Object)"KEEP_ALIVE_INTERVAL", -1);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Keep alive interval is " + keepAliveInterval));
                }
                if (keepAliveInterval > 0 && !ClientCapabilities.this.provider.getRegistrarConnection().isRegistrarless()) {
                    if (ClientCapabilities.this.keepAliveTimer == null) {
                        ClientCapabilities.this.keepAliveTimer = new Timer();
                    }
                    TimerTask keepAliveTask = OSUtils.IS_ANDROID && keepAliveMethod == null || "crlf".equalsIgnoreCase(keepAliveMethod) ? new CRLfKeepAliveTask() : new OptionsKeepAliveTask();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Scheduling keep alives: " + keepAliveTask));
                    }
                    ClientCapabilities.this.keepAliveTimer.schedule(keepAliveTask, 0L, (long)(keepAliveInterval * 1000));
                }
            }
        }
    }

    private class CRLfKeepAliveTask
    extends TimerTask {
        private CRLfKeepAliveTask() {
        }

        @Override
        public void run() {
            ProxyConnection connection = ClientCapabilities.this.provider.getConnection();
            if (connection == null) {
                logger.error((Object)("No connection found to send CRLF keep alive with " + (Object)((Object)ClientCapabilities.this.provider)));
                return;
            }
            ListeningPoint lp = ClientCapabilities.this.provider.getListeningPoint(connection.getTransport());
            if (!(lp instanceof ListeningPointExt)) {
                logger.error((Object)"ListeningPoint is not ListeningPointExt(or is null)");
                return;
            }
            InetSocketAddress address = connection.getAddress();
            try {
                ((ListeningPointExt)lp).sendHeartbeat(address.getAddress().getHostAddress(), address.getPort());
            }
            catch (IOException e) {
                logger.error((Object)"Error while sending a heartbeat", (Throwable)e);
            }
        }
    }

    private class OptionsKeepAliveTask
    extends TimerTask {
        private OptionsKeepAliveTask() {
        }

        @Override
        public void run() {
            try {
                logger.logEntry();
                FromHeader fromHeader = null;
                try {
                    fromHeader = ClientCapabilities.this.provider.getHeaderFactory().createFromHeader(ClientCapabilities.this.provider.getRegistrarConnection().getAddressOfRecord(), SipMessageFactory.generateLocalTag());
                }
                catch (ParseException ex) {
                    logger.error((Object)"Failed to generate a from header for our register request.", (Throwable)ex);
                    return;
                }
                CallIdHeader callIdHeader = ClientCapabilities.this.provider.getDefaultJainSipProvider().getNewCallId();
                CSeqHeader cSeqHeader = null;
                try {
                    cSeqHeader = ClientCapabilities.this.provider.getHeaderFactory().createCSeqHeader(ClientCapabilities.this.getNextCSeqValue(), "OPTIONS");
                }
                catch (ParseException ex) {
                    logger.error((Object)"Corrupt Sip Stack", (Throwable)ex);
                    return;
                }
                catch (InvalidArgumentException ex) {
                    logger.error((Object)"The application is corrupt", (Throwable)ex);
                    return;
                }
                ToHeader toHeader = null;
                try {
                    toHeader = ClientCapabilities.this.provider.getHeaderFactory().createToHeader(fromHeader.getAddress(), null);
                }
                catch (ParseException ex) {
                    logger.error((Object)("Could not create a To header for address:" + fromHeader.getAddress()), (Throwable)ex);
                    return;
                }
                MaxForwardsHeader maxForwardsHeader = ClientCapabilities.this.provider.getMaxForwardsHeader();
                Request request = null;
                try {
                    String domain = ((SipURI)toHeader.getAddress().getURI()).getHost();
                    SipURI requestURI = ClientCapabilities.this.provider.getAddressFactory().createSipURI(null, domain);
                    ArrayList<ViaHeader> viaHeaders = ClientCapabilities.this.provider.getLocalViaHeaders(requestURI);
                    request = ClientCapabilities.this.provider.getMessageFactory().createRequest((URI)requestURI, "OPTIONS", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Created OPTIONS request " + request));
                    }
                }
                catch (ParseException ex) {
                    logger.error((Object)"Could not create an OPTIONS request!", (Throwable)ex);
                    return;
                }
                for (String method : ClientCapabilities.this.provider.getSupportedMethods()) {
                    if (method.equals("REGISTER")) continue;
                    request.addHeader((Header)ClientCapabilities.this.provider.getHeaderFactory().createAllowHeader(method));
                }
                ClientCapabilities.this.addAllowEventsHeader((Message)request);
                ClientTransaction optionsTrans = null;
                try {
                    optionsTrans = ClientCapabilities.this.provider.getDefaultJainSipProvider().getNewClientTransaction(request);
                }
                catch (TransactionUnavailableException ex) {
                    logger.error((Object)"Could not create options transaction!\n", (Throwable)ex);
                    return;
                }
                try {
                    optionsTrans.sendRequest();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("sent request= " + request));
                    }
                }
                catch (SipException ex) {
                    logger.error((Object)"Could not send out the options request!", (Throwable)ex);
                    if (ex.getCause() instanceof IOException) {
                        ClientCapabilities.this.disconnect();
                    }
                    return;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Cannot send OPTIONS keep alive", (Throwable)ex);
            }
        }
    }
}

