/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.AuthorizationResponse;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.ContactPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionEvent;
import net.java.sip.communicator.service.protocol.event.SubscriptionListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionMovedEvent;
import net.java.sip.communicator.service.protocol.jabberconstants.JabberStatusEnum;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetPresence
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetPresence.class);
    private JabberSlickFixture fixture = new JabberSlickFixture();
    private OperationSetPresence operationSetPresence1 = null;
    private final Map<String, PresenceStatus> supportedStatusSet1 = new HashMap<String, PresenceStatus>();
    private OperationSetPresence operationSetPresence2 = null;
    private final Map<String, PresenceStatus> supportedStatusSet2 = new HashMap<String, PresenceStatus>();
    private String statusMessageRoot = new String("Our status is now: ");
    private static AuthEventCollector authEventCollector1 = new AuthEventCollector();
    private static AuthEventCollector authEventCollector2 = new AuthEventCollector();

    public TestOperationSetPresence(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        PresenceStatus supportedStatus;
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets1 = this.fixture.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.operationSetPresence1 = (OperationSetPresence)supportedOperationSets1.get(OperationSetPresence.class.getName());
        if (this.operationSetPresence1 == null) {
            throw new NullPointerException("An implementation of the Jabber service must provide an implementation of at least the one of the Presence Operation Sets");
        }
        Map supportedOperationSets2 = this.fixture.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this Jabber implementation. ");
        }
        this.operationSetPresence2 = (OperationSetPresence)supportedOperationSets2.get(OperationSetPresence.class.getName());
        if (this.operationSetPresence2 == null) {
            throw new NullPointerException("An implementation of the Jabber service must provide an implementation of at least the one of the Presence Operation Sets");
        }
        Iterator supportedStatusIt = this.operationSetPresence1.getSupportedStatusSet();
        while (supportedStatusIt.hasNext()) {
            supportedStatus = (PresenceStatus)supportedStatusIt.next();
            this.supportedStatusSet1.put(supportedStatus.getStatusName(), supportedStatus);
        }
        supportedStatusIt = this.operationSetPresence2.getSupportedStatusSet();
        while (supportedStatusIt.hasNext()) {
            supportedStatus = (PresenceStatus)supportedStatusIt.next();
            this.supportedStatusSet2.put(supportedStatus.getStatusName(), supportedStatus);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
    }

    public static Test suite() {
        if (JabberSlickFixture.onlineTestingDisabled) {
            TestSuite suite = new TestSuite();
            suite.addTest((Test)new TestOperationSetPresence("testSupportedStatusSetForCompleteness"));
            return suite;
        }
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestOperationSetPresence("clearLists"));
        suite.addTest((Test)new TestOperationSetPresence("postTestSubscribe"));
        suite.addTest((Test)new TestOperationSetPresence("postTestUnsubscribe"));
        return suite;
    }

    public void testSupportedStatusSetForCompleteness() {
        Iterator supportedStatusSetIter = this.operationSetPresence1.getSupportedStatusSet();
        LinkedList<String> supportedStatusNames = new LinkedList<String>();
        while (supportedStatusSetIter.hasNext()) {
            supportedStatusNames.add(((PresenceStatus)supportedStatusSetIter.next()).getStatusName());
        }
        List<String> requiredStatusNames = Arrays.asList(JabberStatusEnum.getStatusNames());
        requiredStatusNames.removeAll(supportedStatusNames);
        int unsupported = requiredStatusNames.size();
        TestOperationSetPresence.assertTrue((String)("There are " + unsupported + " statuses as follows:" + requiredStatusNames), (unsupported == 0 ? 1 : 0) != 0);
    }

    public void testChangingStateToAway() throws Exception {
        this.subtestStateTransition("Away");
    }

    public void testChangingStateToDnd() throws Exception {
        this.subtestStateTransition("Do Not Disturb");
    }

    public void testChangingStateToFreeForChat() throws Exception {
        this.subtestStateTransition("Free For Chat");
    }

    public void testChangingStateToOnline() throws Exception {
        this.subtestStateTransition("Available");
    }

    private void subtestStateTransition(String newStatusName) throws Exception {
        logger.trace((Object)" --=== beginning state transition test ===--");
        PresenceStatus newStatus = this.supportedStatusSet1.get(newStatusName);
        PresenceStatus oldStatus = this.operationSetPresence1.getPresenceStatus();
        String oldStatusMessage = this.operationSetPresence1.getCurrentStatusMessage();
        String newStatusMessage = this.statusMessageRoot + newStatus;
        logger.debug((Object)("old status is=" + oldStatus.getStatusName() + " new status=" + newStatus.getStatusName()));
        PresenceStatusEventCollector statusEventCollector = new PresenceStatusEventCollector();
        this.operationSetPresence1.addProviderPresenceStatusListener((ProviderPresenceStatusListener)statusEventCollector);
        this.operationSetPresence1.publishPresenceStatus(newStatus, newStatusMessage);
        this.pauseAfterStateChanges();
        statusEventCollector.waitForPresEvent(10000L);
        statusEventCollector.waitForStatMsgEvent(10000L);
        this.operationSetPresence1.removeProviderPresenceStatusListener((ProviderPresenceStatusListener)statusEventCollector);
        TestOperationSetPresence.assertEquals((String)"Events dispatched during an event transition.", (int)1, (int)statusEventCollector.collectedPresEvents.size());
        TestOperationSetPresence.assertEquals((String)"A status changed event contained wrong old status.", (Object)oldStatus, (Object)statusEventCollector.collectedPresEvents.get(0).getOldStatus());
        TestOperationSetPresence.assertEquals((String)"A status changed event contained wrong new status.", (Object)newStatus, (Object)statusEventCollector.collectedPresEvents.get(0).getNewStatus());
        TestOperationSetPresence.assertEquals((String)"opSet.getPresenceStatus() did not return properly.", (Object)newStatus, (Object)this.operationSetPresence1.getPresenceStatus());
        PresenceStatus actualStatus = this.operationSetPresence2.queryContactStatus(this.fixture.userID1);
        TestOperationSetPresence.assertEquals((String)"The underlying implementation did not switch to the requested presence status.", (Object)newStatus, (Object)actualStatus);
        TestOperationSetPresence.assertEquals((String)"No status message events.", (int)1, (int)statusEventCollector.collectedStatMsgEvents.size());
        TestOperationSetPresence.assertEquals((String)"A status message event contained wrong old value.", (Object)oldStatusMessage, (Object)statusEventCollector.collectedStatMsgEvents.get(0).getOldValue());
        TestOperationSetPresence.assertEquals((String)"A status message event contained wrong new value.", (Object)newStatusMessage, (Object)statusEventCollector.collectedStatMsgEvents.get(0).getNewValue());
        TestOperationSetPresence.assertEquals((String)"opSet.getCurrentStatusMessage() did not return properly.", (String)newStatusMessage, (String)this.operationSetPresence1.getCurrentStatusMessage());
        logger.trace((Object)" --=== finished test ===--");
    }

    private void pauseAfterStateChanges() {
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException ex) {
            logger.debug((Object)"Pausing between state changes was interrupted", (Throwable)ex);
        }
    }

    public void testQueryContactStatus() throws Exception {
        logger.debug((Object)"Will Query an AWAY contact.");
        this.subtestQueryContactStatus("Away", "Away");
        logger.debug((Object)"Will Query a DND contact.");
        this.subtestQueryContactStatus("Do Not Disturb", "Do Not Disturb");
        logger.debug((Object)"Will Query a Free For Chat contact.");
        this.subtestQueryContactStatus("Free For Chat", "Free For Chat");
        logger.debug((Object)"Will Query an Online contact.");
        this.subtestQueryContactStatus("Available", "Available");
    }

    private void subtestQueryContactStatus(String status, String expectedReturn) throws Exception {
        this.operationSetPresence2.publishPresenceStatus(this.supportedStatusSet2.get(status), "status message");
        this.pauseAfterStateChanges();
        PresenceStatus actualReturn = this.operationSetPresence1.queryContactStatus(this.fixture.userID2);
        TestOperationSetPresence.assertEquals((String)("Querying a " + expectedReturn + " state did not return as expected"), (Object)this.supportedStatusSet1.get(expectedReturn), (Object)actualReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTestSubscribe() throws Exception {
        logger.debug((Object)"Testing Subscription and Subscription Event Dispatch.");
        logger.trace((Object)"set Auth Handlers");
        this.operationSetPresence1.setAuthorizationHandler((AuthorizationHandler)authEventCollector1);
        this.operationSetPresence2.setAuthorizationHandler((AuthorizationHandler)authEventCollector2);
        TestOperationSetPresence.authEventCollector2.responseToRequest = new AuthorizationResponse(AuthorizationResponse.REJECT, null);
        this.operationSetPresence1.subscribe(this.fixture.userID2);
        authEventCollector2.waitForAuthRequest(10000L);
        TestOperationSetPresence.assertTrue((String)("Error authorization request not received from " + this.fixture.userID2), (boolean)TestOperationSetPresence.authEventCollector2.isAuthorizationRequestReceived);
        authEventCollector1.waitForAuthResponse(10000L);
        TestOperationSetPresence.assertTrue((String)("Error authorization reply not received from " + this.fixture.userID1), (boolean)TestOperationSetPresence.authEventCollector1.isAuthorizationResponseReceived);
        TestOperationSetPresence.assertEquals((String)"Error received authorization reply not as expected", (Object)TestOperationSetPresence.authEventCollector2.responseToRequest.getResponseCode(), (Object)TestOperationSetPresence.authEventCollector1.response.getResponseCode());
        this.pauseAfterStateChanges();
        SubscriptionEventCollector subEvtCollector = new SubscriptionEventCollector();
        this.operationSetPresence1.addSubscriptionListener((SubscriptionListener)subEvtCollector);
        TestOperationSetPresence.authEventCollector2.responseToRequest = new AuthorizationResponse(AuthorizationResponse.ACCEPT, null);
        TestOperationSetPresence.authEventCollector2.isAuthorizationRequestReceived = false;
        TestOperationSetPresence.authEventCollector1.isAuthorizationResponseReceived = false;
        this.operationSetPresence1.subscribe(this.fixture.userID2);
        authEventCollector2.waitForAuthRequest(10000L);
        TestOperationSetPresence.assertTrue((String)("Error authorization request not received from " + this.fixture.userID2), (boolean)TestOperationSetPresence.authEventCollector2.isAuthorizationRequestReceived);
        authEventCollector1.waitForAuthResponse(10000L);
        TestOperationSetPresence.assertTrue((String)("Error authorization reply not received from " + this.fixture.userID1), (boolean)TestOperationSetPresence.authEventCollector1.isAuthorizationResponseReceived);
        TestOperationSetPresence.assertEquals((String)"Error received authorization reply not as expected", (Object)TestOperationSetPresence.authEventCollector2.responseToRequest.getResponseCode(), (Object)TestOperationSetPresence.authEventCollector1.response.getResponseCode());
        TestOperationSetPresence.authEventCollector1.responseToRequest = new AuthorizationResponse(AuthorizationResponse.ACCEPT, null);
        TestOperationSetPresence.authEventCollector2.responseToRequest = new AuthorizationResponse(AuthorizationResponse.ACCEPT, null);
        this.operationSetPresence1.removeSubscriptionListener((SubscriptionListener)subEvtCollector);
        TestOperationSetPresence.assertTrue((String)"Subscription event dispatching failed.", (subEvtCollector.collectedSubscriptionEvents.size() > 0 ? 1 : 0) != 0);
        SubscriptionEvent subEvt = null;
        SubscriptionEventCollector subscriptionEventCollector = subEvtCollector;
        synchronized (subscriptionEventCollector) {
            for (SubscriptionEvent elem : subEvtCollector.collectedSubscriptionEvents) {
                if (elem.getEventID() != 1) continue;
                subEvt = elem;
            }
        }
        TestOperationSetPresence.assertNotNull((String)"Subscription event dispatching failed.", subEvt);
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source:", (String)this.fixture.userID2, (String)((Contact)subEvt.getSource()).getAddress());
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source Contact:", (String)this.fixture.userID2, (String)subEvt.getSourceContact().getAddress());
        TestOperationSetPresence.assertSame((String)"SubscriptionEvent Source Provider:", (Object)this.fixture.provider1, (Object)subEvt.getSourceProvider());
        subEvtCollector.collectedSubscriptionEvents.clear();
        subEvtCollector.collectedSubscriptionMovedEvents.clear();
        subEvtCollector.collectedContactPropertyChangeEvents.clear();
        logger.debug((Object)"Testing presence notifications.");
        PresenceStatus oldStatus = this.operationSetPresence2.getPresenceStatus();
        PresenceStatus newStatus = this.supportedStatusSet2.get("Free For Chat");
        if (oldStatus.equals((Object)newStatus)) {
            newStatus = this.supportedStatusSet2.get("Do Not Disturb");
        }
        ContactPresenceEventCollector contactPresEvtCollector = new ContactPresenceEventCollector(this.fixture.userID2, newStatus);
        this.operationSetPresence1.addContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        ContactPresenceEventCollector contactPresenceEventCollector = contactPresEvtCollector;
        synchronized (contactPresenceEventCollector) {
            this.operationSetPresence2.publishPresenceStatus(newStatus, "new status");
            contactPresEvtCollector.waitForEvent(10000L);
            this.operationSetPresence1.removeContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        }
        TestOperationSetPresence.assertEquals((String)"Presence Notif. event dispatching failed.", (int)1, (int)contactPresEvtCollector.collectedEvents.size());
        ContactPresenceStatusChangeEvent presEvt = contactPresEvtCollector.collectedEvents.get(0);
        TestOperationSetPresence.assertEquals((String)"Presence Notif. event  Source:", (String)this.fixture.userID2, (String)((Contact)presEvt.getSource()).getAddress());
        TestOperationSetPresence.assertEquals((String)"Presence Notif. event  Source Contact:", (String)this.fixture.userID2, (String)presEvt.getSourceContact().getAddress());
        TestOperationSetPresence.assertSame((String)"Presence Notif. event  Source Provider:", (Object)this.fixture.provider1, (Object)presEvt.getSourceProvider());
        PresenceStatus reportedNewStatus = presEvt.getNewStatus();
        PresenceStatus reportedOldStatus = presEvt.getOldStatus();
        TestOperationSetPresence.assertEquals((String)"Reported new PresenceStatus: ", (Object)newStatus, (Object)reportedNewStatus);
        TestOperationSetPresence.assertNotNull((String)"Reported old PresenceStatus: ", (Object)reportedOldStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTestUnsubscribe() throws Exception {
        logger.debug((Object)"Testing Unsubscribe and unsubscription event dispatch.");
        SubscriptionEventCollector subEvtCollector = new SubscriptionEventCollector();
        this.operationSetPresence1.addSubscriptionListener((SubscriptionListener)subEvtCollector);
        Contact jabberTesterAgentContact = this.operationSetPresence1.findContactByID(this.fixture.userID2);
        TestOperationSetPresence.assertNotNull((String)"Failed to find an existing subscription for the tester agent", (Object)jabberTesterAgentContact);
        SubscriptionEventCollector subscriptionEventCollector = subEvtCollector;
        synchronized (subscriptionEventCollector) {
            this.operationSetPresence1.unsubscribe(jabberTesterAgentContact);
            subEvtCollector.waitForSubscriptionEvent(10000L);
            this.operationSetPresence1.removeSubscriptionListener((SubscriptionListener)subEvtCollector);
        }
        TestOperationSetPresence.assertEquals((String)"Subscription event dispatching failed.", (int)1, (int)subEvtCollector.collectedSubscriptionEvents.size());
        SubscriptionEvent subEvt = subEvtCollector.collectedSubscriptionEvents.get(0);
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source:", (Object)jabberTesterAgentContact, (Object)subEvt.getSource());
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source Contact:", (Object)jabberTesterAgentContact, (Object)subEvt.getSourceContact());
        TestOperationSetPresence.assertSame((String)"SubscriptionEvent Source Provider:", (Object)this.fixture.provider1, (Object)subEvt.getSourceProvider());
        subEvtCollector.collectedSubscriptionEvents.clear();
        subEvtCollector.collectedSubscriptionMovedEvents.clear();
        subEvtCollector.collectedContactPropertyChangeEvents.clear();
        logger.debug((Object)"Testing (lack of) presence notifications.");
        PresenceStatus oldStatus = this.operationSetPresence2.getPresenceStatus();
        PresenceStatus newStatus = this.supportedStatusSet2.get("Free For Chat");
        if (oldStatus.equals((Object)newStatus)) {
            newStatus = this.supportedStatusSet2.get("Do Not Disturb");
        }
        ContactPresenceEventCollector contactPresEvtCollector = new ContactPresenceEventCollector(this.fixture.userID2, null);
        this.operationSetPresence1.addContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        ContactPresenceEventCollector contactPresenceEventCollector = contactPresEvtCollector;
        synchronized (contactPresenceEventCollector) {
            this.operationSetPresence2.publishPresenceStatus(newStatus, "new status");
            contactPresEvtCollector.waitForEvent(10000L);
            this.operationSetPresence1.removeContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        }
        TestOperationSetPresence.assertEquals((String)"Presence Notifications were received after unsubscibing.", (int)0, (int)contactPresEvtCollector.collectedEvents.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLists() throws Exception {
        Object o;
        logger.debug((Object)"Clear the two lists before tests");
        this.fixture.clearProvidersLists();
        Object object = o = new Object();
        synchronized (object) {
            o.wait(3000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForEvent(Object eventCollector, long waitFor, List collectedEvents) {
        long startTime = System.currentTimeMillis();
        long elapsedTime = 0L;
        Object object = eventCollector;
        synchronized (object) {
            try {
                while (collectedEvents.size() == 0 && elapsedTime < waitFor) {
                    eventCollector.wait(waitFor - elapsedTime);
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
            }
            catch (InterruptedException ex) {
                logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
            }
        }
    }

    private static class AuthEventCollector
    implements AuthorizationHandler {
        boolean isAuthorizationRequestSent = false;
        boolean isAuthorizationResponseReceived = false;
        AuthorizationResponse response = null;
        AuthorizationResponse responseToRequest = null;
        boolean isAuthorizationRequestReceived = false;

        private AuthEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthorizationResponse processAuthorisationRequest(AuthorizationRequest req, Contact sourceContact) {
            logger.debug((Object)("Processing in " + this));
            AuthEventCollector authEventCollector = this;
            synchronized (authEventCollector) {
                Object lock;
                logger.trace((Object)("processAuthorisationRequest " + req + " " + sourceContact));
                this.isAuthorizationRequestReceived = true;
                this.notifyAll();
                Object object = lock = new Object();
                synchronized (object) {
                    try {
                        lock.wait(2000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return this.responseToRequest;
            }
        }

        public AuthorizationRequest createAuthorizationRequest(Contact contact) {
            logger.trace((Object)("createAuthorizationRequest " + contact));
            AuthorizationRequest authReq = new AuthorizationRequest();
            this.isAuthorizationRequestSent = true;
            return authReq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processAuthorizationResponse(AuthorizationResponse response, Contact sourceContact) {
            AuthEventCollector authEventCollector = this;
            synchronized (authEventCollector) {
                this.isAuthorizationResponseReceived = true;
                this.response = response;
                logger.trace((Object)("processAuthorizationResponse '" + response.getResponseCode().getCode() + " " + sourceContact));
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForAuthResponse(long waitFor) {
            AuthEventCollector authEventCollector = this;
            synchronized (authEventCollector) {
                if (this.isAuthorizationResponseReceived) {
                    logger.debug((Object)"authorization response already received");
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForAuthRequest(long waitFor) {
            AuthEventCollector authEventCollector = this;
            synchronized (authEventCollector) {
                if (this.isAuthorizationRequestReceived) {
                    logger.debug((Object)"authorization request already received");
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }
    }

    private class ContactPresenceEventCollector
    implements ContactPresenceStatusListener {
        public ArrayList<ContactPresenceStatusChangeEvent> collectedEvents = new ArrayList();
        private String trackedScreenName = null;
        private PresenceStatus status = null;

        ContactPresenceEventCollector(String screenname, PresenceStatus wantedStatus) {
            this.trackedScreenName = screenname;
            this.status = wantedStatus;
        }

        public void waitForEvent(long waitFor) {
            TestOperationSetPresence.waitForEvent(this, waitFor, this.collectedEvents);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
            ContactPresenceEventCollector contactPresenceEventCollector = this;
            synchronized (contactPresenceEventCollector) {
                if (this.trackedScreenName != null && !evt.getSourceContact().getAddress().equals(this.trackedScreenName)) {
                    return;
                }
                if (this.status == null) {
                    return;
                }
                if (this.status != evt.getNewStatus()) {
                    return;
                }
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add(evt);
                this.notifyAll();
            }
        }
    }

    private class SubscriptionEventCollector
    implements SubscriptionListener {
        public ArrayList<SubscriptionEvent> collectedSubscriptionEvents = new ArrayList();
        public ArrayList<SubscriptionMovedEvent> collectedSubscriptionMovedEvents = new ArrayList();
        public ArrayList<ContactPropertyChangeEvent> collectedContactPropertyChangeEvents = new ArrayList();

        private SubscriptionEventCollector() {
        }

        public void waitForSubscriptionEvent(long waitFor) {
            TestOperationSetPresence.waitForEvent(this, waitFor, this.collectedSubscriptionEvents);
        }

        public void waitForSubscriptionMovedEvent(long waitFor) {
            TestOperationSetPresence.waitForEvent(this, waitFor, this.collectedSubscriptionMovedEvents);
        }

        public void waitForContactPropertyChangeEvent(long waitFor) {
            TestOperationSetPresence.waitForEvent(this, waitFor, this.collectedContactPropertyChangeEvents);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedSubscriptionEvent(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected SubscriptionEvnet(" + this.collectedSubscriptionEvents.size() + ")= " + evt));
                this.collectedSubscriptionEvents.add(evt);
                this.notifyAll();
            }
        }

        public void subscriptionCreated(SubscriptionEvent evt) {
            this.receivedSubscriptionEvent(evt);
        }

        public void subscriptionRemoved(SubscriptionEvent evt) {
            this.receivedSubscriptionEvent(evt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contactModified(ContactPropertyChangeEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected ContactPropertyChangeEvent(" + this.collectedContactPropertyChangeEvents.size() + ")= " + evt));
                this.collectedContactPropertyChangeEvents.add(evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionMoved(SubscriptionMovedEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedSubscriptionMovedEvents.size() + ")= " + evt));
                this.collectedSubscriptionMovedEvents.add(evt);
                this.notifyAll();
            }
        }

        public void subscriptionFailed(SubscriptionEvent evt) {
            this.receivedSubscriptionEvent(evt);
        }

        public void subscriptionResolved(SubscriptionEvent evt) {
            this.receivedSubscriptionEvent(evt);
        }
    }

    private class PresenceStatusEventCollector
    implements ProviderPresenceStatusListener {
        public ArrayList<ProviderPresenceStatusChangeEvent> collectedPresEvents = new ArrayList();
        public ArrayList<PropertyChangeEvent> collectedStatMsgEvents = new ArrayList();

        private PresenceStatusEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void providerStatusChanged(ProviderPresenceStatusChangeEvent evt) {
            PresenceStatusEventCollector presenceStatusEventCollector = this;
            synchronized (presenceStatusEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedPresEvents.size() + ")= " + evt));
                this.collectedPresEvents.add(evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void providerStatusMessageChanged(PropertyChangeEvent evt) {
            PresenceStatusEventCollector presenceStatusEventCollector = this;
            synchronized (presenceStatusEventCollector) {
                logger.debug((Object)("Collected stat.msg. evt(" + this.collectedPresEvents.size() + ")= " + evt));
                this.collectedStatMsgEvents.add(evt);
                this.notifyAll();
            }
        }

        public void waitForPresEvent(long waitFor) {
            logger.trace((Object)"Waiting for a change in provider status.");
            TestOperationSetPresence.waitForEvent(this, waitFor, this.collectedPresEvents);
        }

        public void waitForStatMsgEvent(long waitFor) {
            logger.trace((Object)"Waiting for a provider status message event.");
            TestOperationSetPresence.waitForEvent(this, waitFor, this.collectedStatMsgEvents);
        }
    }
}

