/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import org.fife.ui.rtextarea.BackgroundPainterStrategy;
import org.fife.ui.rtextarea.RTextAreaBase;

public abstract class ImageBackgroundPainterStrategy
implements BackgroundPainterStrategy {
    protected MediaTracker tracker;
    private RTextAreaBase textArea;
    private Image master;
    private int oldWidth;
    private int oldHeight;
    private int scalingHint;

    public ImageBackgroundPainterStrategy(RTextAreaBase rTextAreaBase) {
        this.textArea = rTextAreaBase;
        this.tracker = new MediaTracker(rTextAreaBase);
        this.scalingHint = 2;
    }

    public RTextAreaBase getRTextAreaBase() {
        return this.textArea;
    }

    public Image getMasterImage() {
        return this.master;
    }

    public int getScalingHint() {
        return this.scalingHint;
    }

    @Override
    public final void paint(Graphics graphics, Rectangle rectangle) {
        if (rectangle.width != this.oldWidth || rectangle.height != this.oldHeight) {
            this.rescaleImage(rectangle.width, rectangle.height, this.getScalingHint());
            this.oldWidth = rectangle.width;
            this.oldHeight = rectangle.height;
        }
        this.paintImage(graphics, rectangle.x, rectangle.y);
    }

    protected abstract void paintImage(Graphics var1, int var2, int var3);

    protected abstract void rescaleImage(int var1, int var2, int var3);

    public void setImage(URL uRL) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setImage(bufferedImage);
    }

    public void setImage(Image image) {
        this.master = image;
        this.oldWidth = -1;
    }

    public void setScalingHint(int n) {
        this.scalingHint = n;
    }
}

