/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubnetUtils {
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SLASH_FORMAT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})";
    private static final Pattern addressPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final Pattern cidrPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");
    private static final int NBITS = 32;
    private int netmask = 0;
    private int address = 0;
    private int network = 0;
    private int broadcast = 0;
    private boolean inclusiveHostCount = false;

    public SubnetUtils(String string) {
        this.calculate(string);
    }

    public SubnetUtils(String string, String string2) {
        this.calculate(this.toCidrNotation(string, string2));
    }

    public boolean isInclusiveHostCount() {
        return this.inclusiveHostCount;
    }

    public void setInclusiveHostCount(boolean bl) {
        this.inclusiveHostCount = bl;
    }

    public final SubnetInfo getInfo() {
        return new SubnetInfo();
    }

    private void calculate(String string) {
        Matcher matcher = cidrPattern.matcher(string);
        if (matcher.matches()) {
            this.address = this.matchAddress(matcher);
            int n = this.rangeCheck(Integer.parseInt(matcher.group(5)), 0, 32);
            for (int i = 0; i < n; ++i) {
                this.netmask |= 1 << 31 - i;
            }
        } else {
            throw new IllegalArgumentException("Could not parse [" + string + "]");
        }
        this.network = this.address & this.netmask;
        this.broadcast = this.network | ~this.netmask;
    }

    private int toInteger(String string) {
        Matcher matcher = addressPattern.matcher(string);
        if (matcher.matches()) {
            return this.matchAddress(matcher);
        }
        throw new IllegalArgumentException("Could not parse [" + string + "]");
    }

    private int matchAddress(Matcher matcher) {
        int n = 0;
        for (int i = 1; i <= 4; ++i) {
            int n2 = this.rangeCheck(Integer.parseInt(matcher.group(i)), 0, 255);
            n |= (n2 & 0xFF) << 8 * (4 - i);
        }
        return n;
    }

    private int[] toArray(int n) {
        int[] nArray = new int[4];
        for (int i = 3; i >= 0; --i) {
            int n2 = i;
            nArray[n2] = nArray[n2] | n >>> 8 * (3 - i) & 0xFF;
        }
        return nArray;
    }

    private String format(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    private int rangeCheck(int n, int n2, int n3) {
        if (n >= n2 && n <= n3) {
            return n;
        }
        throw new IllegalArgumentException("Value [" + n + "] not in range [" + n2 + "," + n3 + "]");
    }

    int pop(int n) {
        n -= n >>> 1 & 0x55555555;
        n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
        n = n + (n >>> 4) & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return n & 0x3F;
    }

    private String toCidrNotation(String string, String string2) {
        return string + "/" + this.pop(this.toInteger(string2));
    }

    public final class SubnetInfo {
        private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;

        private SubnetInfo() {
        }

        private int netmask() {
            return SubnetUtils.this.netmask;
        }

        private int network() {
            return SubnetUtils.this.network;
        }

        private int address() {
            return SubnetUtils.this.address;
        }

        private int broadcast() {
            return SubnetUtils.this.broadcast;
        }

        private long networkLong() {
            return (long)SubnetUtils.this.network & 0xFFFFFFFFL;
        }

        private long broadcastLong() {
            return (long)SubnetUtils.this.broadcast & 0xFFFFFFFFL;
        }

        private int low() {
            return SubnetUtils.this.isInclusiveHostCount() ? this.network() : (this.broadcastLong() - this.networkLong() > 1L ? this.network() + 1 : 0);
        }

        private int high() {
            return SubnetUtils.this.isInclusiveHostCount() ? this.broadcast() : (this.broadcastLong() - this.networkLong() > 1L ? this.broadcast() - 1 : 0);
        }

        public boolean isInRange(String string) {
            return this.isInRange(SubnetUtils.this.toInteger(string));
        }

        public boolean isInRange(int n) {
            long l = (long)n & 0xFFFFFFFFL;
            long l2 = (long)this.low() & 0xFFFFFFFFL;
            long l3 = (long)this.high() & 0xFFFFFFFFL;
            return l >= l2 && l <= l3;
        }

        public String getBroadcastAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.broadcast()));
        }

        public String getNetworkAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.network()));
        }

        public String getNetmask() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.netmask()));
        }

        public String getAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.address()));
        }

        public String getLowAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.low()));
        }

        public String getHighAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.high()));
        }

        @Deprecated
        public int getAddressCount() {
            long l = this.getAddressCountLong();
            if (l > Integer.MAX_VALUE) {
                throw new RuntimeException("Count is larger than an integer: " + l);
            }
            return (int)l;
        }

        public long getAddressCountLong() {
            long l = this.broadcastLong();
            long l2 = this.networkLong();
            long l3 = l - l2 + (long)(SubnetUtils.this.isInclusiveHostCount() ? 1 : -1);
            return l3 < 0L ? 0L : l3;
        }

        public int asInteger(String string) {
            return SubnetUtils.this.toInteger(string);
        }

        public String getCidrSignature() {
            return SubnetUtils.this.toCidrNotation(SubnetUtils.this.format(SubnetUtils.this.toArray(this.address())), SubnetUtils.this.format(SubnetUtils.this.toArray(this.netmask())));
        }

        public String[] getAllAddresses() {
            int n = this.getAddressCount();
            String[] stringArray = new String[n];
            if (n == 0) {
                return stringArray;
            }
            int n2 = this.low();
            int n3 = 0;
            while (n2 <= this.high()) {
                stringArray[n3] = SubnetUtils.this.format(SubnetUtils.this.toArray(n2));
                ++n2;
                ++n3;
            }
            return stringArray;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CIDR Signature:\t[").append(this.getCidrSignature()).append("]").append(" Netmask: [").append(this.getNetmask()).append("]\n").append("Network:\t[").append(this.getNetworkAddress()).append("]\n").append("Broadcast:\t[").append(this.getBroadcastAddress()).append("]\n").append("First Address:\t[").append(this.getLowAddress()).append("]\n").append("Last Address:\t[").append(this.getHighAddress()).append("]\n").append("# Addresses:\t[").append(this.getAddressCount()).append("]\n");
            return stringBuilder.toString();
        }
    }
}

