/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public final class DotTerminatedMessageReader
extends BufferedReader {
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final int DOT = 46;
    private boolean atBeginning = true;
    private boolean eof = false;
    private boolean seenCR;

    public DotTerminatedMessageReader(Reader reader) {
        super(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.eof) {
                return -1;
            }
            int n = super.read();
            if (n == -1) {
                this.eof = true;
                return -1;
            }
            if (this.atBeginning) {
                this.atBeginning = false;
                if (n == 46) {
                    this.mark(2);
                    n = super.read();
                    if (n == -1) {
                        this.eof = true;
                        return 46;
                    }
                    if (n == 46) {
                        return n;
                    }
                    if (n == 13) {
                        n = super.read();
                        if (n == -1) {
                            this.reset();
                            return 46;
                        }
                        if (n == 10) {
                            this.atBeginning = true;
                            this.eof = true;
                            return -1;
                        }
                    }
                    this.reset();
                    return 46;
                }
            }
            if (this.seenCR) {
                this.seenCR = false;
                if (n == 10) {
                    this.atBeginning = true;
                }
            }
            if (n == 13) {
                this.seenCR = true;
            }
            return n;
        }
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 < 1) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            int n3 = this.read();
            if (n3 == -1) {
                return -1;
            }
            int n4 = n;
            do {
                cArray[n++] = (char)n3;
            } while (--n2 > 0 && (n3 = this.read()) != -1);
            return n - n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.eof) {
                while (this.read() != -1) {
                }
            }
            this.eof = true;
            this.atBeginning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.lock;
        synchronized (object) {
            int n;
            while ((n = this.read()) != -1) {
                if (n == 10 && this.atBeginning) {
                    return stringBuilder.substring(0, stringBuilder.length() - 1);
                }
                stringBuilder.append((char)n);
            }
        }
        object = stringBuilder.toString();
        if (((String)object).length() == 0) {
            return null;
        }
        return object;
    }
}

