/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParserImpl;

public class MLSxEntryParser
extends FTPFileEntryParserImpl {
    private static final MLSxEntryParser PARSER = new MLSxEntryParser();
    private static final HashMap<String, Integer> TYPE_TO_INT = new HashMap();
    private static int[] UNIX_GROUPS;
    private static int[][] UNIX_PERMS;

    @Override
    public FTPFile parseFTPEntry(String string) {
        if (string.startsWith(" ")) {
            if (string.length() > 1) {
                FTPFile fTPFile = new FTPFile();
                fTPFile.setRawListing(string);
                fTPFile.setName(string.substring(1));
                return fTPFile;
            }
            return null;
        }
        String[] stringArray = string.split(" ", 2);
        if (stringArray.length != 2 || stringArray[1].length() == 0) {
            return null;
        }
        String string2 = stringArray[0];
        if (!string2.endsWith(";")) {
            return null;
        }
        FTPFile fTPFile = new FTPFile();
        fTPFile.setRawListing(string);
        fTPFile.setName(stringArray[1]);
        String[] stringArray2 = string2.split(";");
        boolean bl = stringArray[0].toLowerCase(Locale.ENGLISH).contains("unix.mode=");
        for (String string3 : stringArray2) {
            Object object;
            String[] stringArray3 = string3.split("=", -1);
            if (stringArray3.length != 2) {
                return null;
            }
            String string4 = stringArray3[0].toLowerCase(Locale.ENGLISH);
            String string5 = stringArray3[1];
            if (string5.length() == 0) continue;
            String string6 = string5.toLowerCase(Locale.ENGLISH);
            if ("size".equals(string4)) {
                fTPFile.setSize(Long.parseLong(string5));
                continue;
            }
            if ("sizd".equals(string4)) {
                fTPFile.setSize(Long.parseLong(string5));
                continue;
            }
            if ("modify".equals(string4)) {
                object = MLSxEntryParser.parseGMTdateTime(string5);
                if (object == null) {
                    return null;
                }
                fTPFile.setTimestamp((Calendar)object);
                continue;
            }
            if ("type".equals(string4)) {
                object = TYPE_TO_INT.get(string6);
                if (object == null) {
                    fTPFile.setType(3);
                    continue;
                }
                fTPFile.setType((Integer)object);
                continue;
            }
            if (string4.startsWith("unix.")) {
                object = string4.substring("unix.".length()).toLowerCase(Locale.ENGLISH);
                if ("group".equals(object)) {
                    fTPFile.setGroup(string5);
                    continue;
                }
                if ("owner".equals(object)) {
                    fTPFile.setUser(string5);
                    continue;
                }
                if (!"mode".equals(object)) continue;
                int n = string5.length() - 3;
                for (int i = 0; i < 3; ++i) {
                    int n2 = string5.charAt(n + i) - 48;
                    if (n2 < 0 || n2 > 7) continue;
                    for (int n3 : UNIX_PERMS[n2]) {
                        fTPFile.setPermission(UNIX_GROUPS[i], n3, true);
                    }
                }
                continue;
            }
            if (bl || !"perm".equals(string4)) continue;
            this.doUnixPerms(fTPFile, string6);
        }
        return fTPFile;
    }

    public static Calendar parseGMTdateTime(String string) {
        boolean bl;
        SimpleDateFormat simpleDateFormat;
        if (string.contains(".")) {
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
            bl = true;
        } else {
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            bl = false;
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        simpleDateFormat.setTimeZone(timeZone);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        ParsePosition parsePosition = new ParsePosition(0);
        simpleDateFormat.setLenient(false);
        Date date = simpleDateFormat.parse(string, parsePosition);
        if (parsePosition.getIndex() != string.length()) {
            return null;
        }
        gregorianCalendar.setTime(date);
        if (!bl) {
            gregorianCalendar.clear(14);
        }
        return gregorianCalendar;
    }

    private void doUnixPerms(FTPFile fTPFile, String string) {
        block12: for (char c : string.toCharArray()) {
            switch (c) {
                case 'a': {
                    fTPFile.setPermission(0, 1, true);
                    continue block12;
                }
                case 'c': {
                    fTPFile.setPermission(0, 1, true);
                    continue block12;
                }
                case 'd': {
                    fTPFile.setPermission(0, 1, true);
                    continue block12;
                }
                case 'e': {
                    fTPFile.setPermission(0, 0, true);
                    continue block12;
                }
                case 'f': {
                    continue block12;
                }
                case 'l': {
                    fTPFile.setPermission(0, 2, true);
                    continue block12;
                }
                case 'm': {
                    fTPFile.setPermission(0, 1, true);
                    continue block12;
                }
                case 'p': {
                    fTPFile.setPermission(0, 1, true);
                    continue block12;
                }
                case 'r': {
                    fTPFile.setPermission(0, 0, true);
                    continue block12;
                }
                case 'w': {
                    fTPFile.setPermission(0, 1, true);
                    continue block12;
                }
            }
        }
    }

    public static FTPFile parseEntry(String string) {
        return PARSER.parseFTPEntry(string);
    }

    public static MLSxEntryParser getInstance() {
        return PARSER;
    }

    static {
        TYPE_TO_INT.put("file", 0);
        TYPE_TO_INT.put("cdir", 1);
        TYPE_TO_INT.put("pdir", 1);
        TYPE_TO_INT.put("dir", 1);
        UNIX_GROUPS = new int[]{0, 1, 2};
        UNIX_PERMS = new int[][]{new int[0], {2}, {1}, {2, 1}, {0}, {0, 2}, {0, 1}, {0, 1, 2}};
    }
}

