/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.xz;

import java.util.HashMap;
import org.apache.commons.compress.compressors.FileNameUtil;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;

public class XZUtils {
    private static final FileNameUtil fileNameUtil;
    private static final byte[] HEADER_MAGIC;
    private static volatile CachedAvailability cachedXZAvailability;

    private XZUtils() {
    }

    public static boolean matches(byte[] byArray, int n) {
        if (n < HEADER_MAGIC.length) {
            return false;
        }
        for (int i = 0; i < HEADER_MAGIC.length; ++i) {
            if (byArray[i] == HEADER_MAGIC[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isXZCompressionAvailable() {
        CachedAvailability cachedAvailability = cachedXZAvailability;
        if (cachedAvailability != CachedAvailability.DONT_CACHE) {
            return cachedAvailability == CachedAvailability.CACHED_AVAILABLE;
        }
        return XZUtils.internalIsXZCompressionAvailable();
    }

    private static boolean internalIsXZCompressionAvailable() {
        try {
            XZCompressorInputStream.matches(null, 0);
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    public static boolean isCompressedFilename(String string) {
        return fileNameUtil.isCompressedFilename(string);
    }

    public static String getUncompressedFilename(String string) {
        return fileNameUtil.getUncompressedFilename(string);
    }

    public static String getCompressedFilename(String string) {
        return fileNameUtil.getCompressedFilename(string);
    }

    public static void setCacheXZAvailablity(boolean bl) {
        if (!bl) {
            cachedXZAvailability = CachedAvailability.DONT_CACHE;
        } else if (cachedXZAvailability == CachedAvailability.DONT_CACHE) {
            boolean bl2 = XZUtils.internalIsXZCompressionAvailable();
            cachedXZAvailability = bl2 ? CachedAvailability.CACHED_AVAILABLE : CachedAvailability.CACHED_UNAVAILABLE;
        }
    }

    static CachedAvailability getCachedXZAvailability() {
        return cachedXZAvailability;
    }

    static {
        HEADER_MAGIC = new byte[]{-3, 55, 122, 88, 90, 0};
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(".txz", ".tar");
        hashMap.put(".xz", "");
        hashMap.put("-xz", "");
        fileNameUtil = new FileNameUtil(hashMap, ".xz");
        cachedXZAvailability = CachedAvailability.DONT_CACHE;
        try {
            Class.forName("org.osgi.framework.BundleEvent");
        }
        catch (Exception exception) {
            XZUtils.setCacheXZAvailablity(true);
        }
    }

    static enum CachedAvailability {
        DONT_CACHE,
        CACHED_AVAILABLE,
        CACHED_UNAVAILABLE;

    }
}

