/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.optimizer;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.optimizer.ConstantPool;

public class AnnotationConstantsCollector
extends AnnotationVisitor {
    private final ConstantPool cp;

    public AnnotationConstantsCollector(AnnotationVisitor annotationVisitor, ConstantPool constantPool) {
        super(327680, annotationVisitor);
        this.cp = constantPool;
    }

    public void visit(String string, Object object) {
        if (string != null) {
            this.cp.newUTF8(string);
        }
        if (object instanceof Byte) {
            this.cp.newInteger(((Byte)object).byteValue());
        } else if (object instanceof Boolean) {
            this.cp.newInteger((Boolean)object != false ? 1 : 0);
        } else if (object instanceof Character) {
            this.cp.newInteger(((Character)object).charValue());
        } else if (object instanceof Short) {
            this.cp.newInteger(((Short)object).shortValue());
        } else if (object instanceof Type) {
            this.cp.newUTF8(((Type)object).getDescriptor());
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            for (int i = 0; i < byArray.length; ++i) {
                this.cp.newInteger(byArray[i]);
            }
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < blArray.length; ++i) {
                this.cp.newInteger(blArray[i] ? 1 : 0);
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            for (int i = 0; i < sArray.length; ++i) {
                this.cp.newInteger(sArray[i]);
            }
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            for (int i = 0; i < cArray.length; ++i) {
                this.cp.newInteger(cArray[i]);
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                this.cp.newInteger(nArray[i]);
            }
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            for (int i = 0; i < lArray.length; ++i) {
                this.cp.newLong(lArray[i]);
            }
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            for (int i = 0; i < fArray.length; ++i) {
                this.cp.newFloat(fArray[i]);
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                this.cp.newDouble(dArray[i]);
            }
        } else {
            this.cp.newConst(object);
        }
        this.av.visit(string, object);
    }

    public void visitEnum(String string, String string2, String string3) {
        if (string != null) {
            this.cp.newUTF8(string);
        }
        this.cp.newUTF8(string2);
        this.cp.newUTF8(string3);
        this.av.visitEnum(string, string2, string3);
    }

    public AnnotationVisitor visitAnnotation(String string, String string2) {
        if (string != null) {
            this.cp.newUTF8(string);
        }
        this.cp.newUTF8(string2);
        return new AnnotationConstantsCollector(this.av.visitAnnotation(string, string2), this.cp);
    }

    public AnnotationVisitor visitArray(String string) {
        if (string != null) {
            this.cp.newUTF8(string);
        }
        return new AnnotationConstantsCollector(this.av.visitArray(string), this.cp);
    }

    public void visitEnd() {
        this.av.visitEnd();
    }
}

