/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.crypt.MasterSecret;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.FileUtil;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PaddedRandomAccessBuffer;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class PaddedRandomAccessBucket
implements RandomAccessBucket,
Serializable {
    private static final long serialVersionUID = 1L;
    private final RandomAccessBucket underlying;
    private long size;
    private transient boolean outputStreamOpen;
    private boolean readOnly;
    private static final long MIN_PADDED_SIZE = 1024L;
    static final int MAGIC = -1782305228;
    static final int VERSION = 1;

    public PaddedRandomAccessBucket(RandomAccessBucket underlying) {
        this(underlying, 0L);
    }

    public PaddedRandomAccessBucket(RandomAccessBucket underlying, long size) {
        this.underlying = underlying;
        this.size = size;
    }

    protected PaddedRandomAccessBucket() {
        this.underlying = null;
        this.size = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream os;
        PaddedRandomAccessBucket paddedRandomAccessBucket = this;
        synchronized (paddedRandomAccessBucket) {
            if (this.outputStreamOpen) {
                throw new IOException("Already have an OutputStream for " + this);
            }
            os = this.underlying.getOutputStream();
            this.outputStreamOpen = true;
            this.size = 0L;
        }
        return new MyOutputStream(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        OutputStream os;
        PaddedRandomAccessBucket paddedRandomAccessBucket = this;
        synchronized (paddedRandomAccessBucket) {
            if (this.outputStreamOpen) {
                throw new IOException("Already have an OutputStream for " + this);
            }
            os = this.underlying.getOutputStreamUnbuffered();
            this.outputStreamOpen = true;
            this.size = 0L;
        }
        return new MyOutputStream(os);
    }

    private long paddedLength(long size) {
        if (size < 1024L) {
            size = 1024L;
        }
        if (size == 1024L) {
            return size;
        }
        long min = 1024L;
        long max = 2048L;
        while (true) {
            if (max < 0L) {
                throw new Error("Impossible size: " + size + " - min=" + min + ", max=" + max);
            }
            if (size < min) {
                throw new IllegalStateException("???");
            }
            if (size >= min && size <= max) {
                return max;
            }
            min = max;
            max <<= 1;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new MyInputStream(this.underlying.getInputStream());
    }

    @Override
    public InputStream getInputStreamUnbuffered() throws IOException {
        return new MyInputStream(this.underlying.getInputStreamUnbuffered());
    }

    @Override
    public String getName() {
        return "Padded:" + this.underlying.getName();
    }

    @Override
    public synchronized long size() {
        return this.size;
    }

    @Override
    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public void free() {
        this.underlying.free();
    }

    @Override
    public RandomAccessBucket createShadow() {
        RandomAccessBucket shadow = this.underlying.createShadow();
        PaddedRandomAccessBucket ret = new PaddedRandomAccessBucket(shadow, this.size);
        ret.setReadOnly();
        return ret;
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        this.underlying.onResume(context);
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(-1782305228);
        dos.writeInt(1);
        dos.writeLong(this.size);
        dos.writeBoolean(this.readOnly);
        this.underlying.storeTo(dos);
    }

    protected PaddedRandomAccessBucket(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterKey) throws IOException, StorageFormatException, ResumeFailedException {
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        this.size = dis.readLong();
        this.readOnly = dis.readBoolean();
        this.underlying = (RandomAccessBucket)BucketTools.restoreFrom(dis, fg, persistentFileTracker, masterKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockableRandomAccessBuffer toRandomAccessBuffer() throws IOException {
        PaddedRandomAccessBucket paddedRandomAccessBucket = this;
        synchronized (paddedRandomAccessBucket) {
            if (this.outputStreamOpen) {
                throw new IOException("Must close first");
            }
            this.readOnly = true;
        }
        this.underlying.setReadOnly();
        LockableRandomAccessBuffer u = this.underlying.toRandomAccessBuffer();
        return new PaddedRandomAccessBuffer(u, this.size);
    }

    public RandomAccessBucket getUnderlying() {
        return this.underlying;
    }

    private class MyInputStream
    extends FilterInputStream {
        private long counter;

        public MyInputStream(InputStream is) {
            super(is);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            PaddedRandomAccessBucket paddedRandomAccessBucket = PaddedRandomAccessBucket.this;
            synchronized (paddedRandomAccessBucket) {
                if (this.counter >= PaddedRandomAccessBucket.this.size) {
                    return -1;
                }
            }
            int ret = this.in.read();
            PaddedRandomAccessBucket paddedRandomAccessBucket2 = PaddedRandomAccessBucket.this;
            synchronized (paddedRandomAccessBucket2) {
                ++this.counter;
            }
            return ret;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            PaddedRandomAccessBucket paddedRandomAccessBucket = PaddedRandomAccessBucket.this;
            synchronized (paddedRandomAccessBucket) {
                if (length < 0) {
                    return -1;
                }
                if (length == 0) {
                    return 0;
                }
                if (this.counter >= PaddedRandomAccessBucket.this.size) {
                    return -1;
                }
                if (this.counter + (long)length >= PaddedRandomAccessBucket.this.size) {
                    length = (int)Math.min((long)length, PaddedRandomAccessBucket.this.size - this.counter);
                }
            }
            int ret = this.in.read(buf, offset, length);
            PaddedRandomAccessBucket paddedRandomAccessBucket2 = PaddedRandomAccessBucket.this;
            synchronized (paddedRandomAccessBucket2) {
                if (ret > 0) {
                    this.counter += (long)ret;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long length) throws IOException {
            PaddedRandomAccessBucket paddedRandomAccessBucket = PaddedRandomAccessBucket.this;
            synchronized (paddedRandomAccessBucket) {
                if (this.counter >= PaddedRandomAccessBucket.this.size) {
                    return -1L;
                }
                if (this.counter + length >= PaddedRandomAccessBucket.this.size) {
                    length = (int)Math.min(length, this.counter + length - PaddedRandomAccessBucket.this.size);
                }
            }
            long ret = this.in.skip(length);
            PaddedRandomAccessBucket paddedRandomAccessBucket2 = PaddedRandomAccessBucket.this;
            synchronized (paddedRandomAccessBucket2) {
                if (ret > 0L) {
                    this.counter += ret;
                }
            }
            return ret;
        }

        @Override
        public synchronized int available() throws IOException {
            int ret;
            long max = PaddedRandomAccessBucket.this.size - this.counter;
            if (max < (long)(ret = this.in.available())) {
                ret = (int)max;
            }
            if (ret < 0) {
                return 0;
            }
            return ret;
        }
    }

    private class MyOutputStream
    extends FilterOutputStream {
        private boolean closed;

        MyOutputStream(OutputStream os) {
            super(os);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            PaddedRandomAccessBucket paddedRandomAccessBucket = PaddedRandomAccessBucket.this;
            synchronized (paddedRandomAccessBucket) {
                PaddedRandomAccessBucket.this.size++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf) throws IOException {
            this.out.write(buf);
            PaddedRandomAccessBucket paddedRandomAccessBucket = PaddedRandomAccessBucket.this;
            synchronized (paddedRandomAccessBucket) {
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                PaddedRandomAccessBucket.this.size += buf.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            this.out.write(buf, offset, length);
            PaddedRandomAccessBucket paddedRandomAccessBucket = PaddedRandomAccessBucket.this;
            synchronized (paddedRandomAccessBucket) {
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                PaddedRandomAccessBucket.this.size += length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                long padding;
                PaddedRandomAccessBucket paddedRandomAccessBucket = PaddedRandomAccessBucket.this;
                synchronized (paddedRandomAccessBucket) {
                    block17: {
                        if (!this.closed) break block17;
                        return;
                    }
                    this.closed = true;
                    long paddedLength = PaddedRandomAccessBucket.this.paddedLength(PaddedRandomAccessBucket.this.size);
                    padding = paddedLength - PaddedRandomAccessBucket.this.size;
                }
                FileUtil.fill(this.out, padding);
                this.out.close();
            }
            finally {
                PaddedRandomAccessBucket paddedRandomAccessBucket = PaddedRandomAccessBucket.this;
                synchronized (paddedRandomAccessBucket) {
                    PaddedRandomAccessBucket.this.outputStreamOpen = false;
                }
            }
        }

        public String toString() {
            return "TrivialPaddedBucketOutputStream:" + this.out + "(" + PaddedRandomAccessBucket.this + ")";
        }
    }
}

