/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.ECDH;
import freenet.crypt.KeyAgreementSchemeContext;
import freenet.support.HexUtil;
import freenet.support.Logger;
import java.security.interfaces.ECPublicKey;

public class ECDHLightContext
extends KeyAgreementSchemeContext {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    public final ECDH ecdh;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        return sb.toString();
    }

    public ECDHLightContext(ECDH.Curves curve) {
        this.ecdh = new ECDH(curve);
        this.lastUsedTime = System.currentTimeMillis();
    }

    public ECPublicKey getPublicKey() {
        return this.ecdh.getPublicKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHMACKey(ECPublicKey peerExponential) {
        ECDHLightContext eCDHLightContext = this;
        synchronized (eCDHLightContext) {
            this.lastUsedTime = System.currentTimeMillis();
        }
        byte[] sharedKey = this.ecdh.getAgreedSecret(peerExponential);
        if (logMINOR) {
            Logger.minor(this, "Curve in use: " + this.ecdh.curve.toString());
            if (logDEBUG) {
                Logger.debug(this, "My exponential: " + HexUtil.bytesToHex(this.ecdh.getPublicKey().getEncoded()));
                Logger.debug(this, "Peer's exponential: " + HexUtil.bytesToHex(peerExponential.getEncoded()));
                Logger.debug(this, "SharedSecret = " + HexUtil.bytesToHex(sharedKey));
            }
        }
        return sharedKey;
    }

    @Override
    public byte[] getPublicKeyNetworkFormat() {
        return this.ecdh.getPublicKeyNetworkFormat();
    }

    static {
        Logger.registerClass(ECDHLightContext.class);
    }
}

