/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class RequestIdentifier {
    static final int MAGIC = 636212109;
    static final short VERSION = 1;
    final boolean globalQueue;
    final String clientName;
    final String identifier;
    public final RequestType type;

    public RequestIdentifier(boolean globalQueue, String clientName, String identifier, RequestType type) {
        this.globalQueue = globalQueue;
        this.clientName = clientName;
        this.identifier = identifier;
        this.type = type;
    }

    public RequestIdentifier(DataInput dis) throws IOException {
        int magic = dis.readInt();
        if (magic != 636212109) {
            throw new IOException("Bad magic");
        }
        short version = dis.readShort();
        if (version != 1) {
            throw new IOException("Bad version");
        }
        this.globalQueue = dis.readBoolean();
        this.clientName = this.globalQueue ? null : dis.readUTF();
        this.identifier = dis.readUTF();
        RequestType[] types = RequestType.values();
        short typeKey = dis.readShort();
        if (typeKey < 0 || typeKey >= types.length) {
            throw new IOException("Bogus type");
        }
        this.type = types[typeKey];
    }

    public void writeTo(DataOutput dos) throws IOException {
        dos.writeInt(636212109);
        dos.writeShort(1);
        dos.writeBoolean(this.globalQueue);
        if (!this.globalQueue) {
            dos.writeUTF(this.clientName);
        }
        dos.writeUTF(this.identifier);
        dos.writeShort(this.type.ordinal());
    }

    public boolean sameIdentifier(RequestIdentifier other) {
        if (this.globalQueue != other.globalQueue) {
            return false;
        }
        if (!this.globalQueue && !this.clientName.equals(other.clientName)) {
            return false;
        }
        if (this.globalQueue != other.globalQueue) {
            return false;
        }
        return this.identifier.equals(other.identifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientName == null ? 0 : this.clientName.hashCode());
        result = 31 * result + (this.globalQueue ? 1231 : 1237);
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestIdentifier)) {
            return false;
        }
        RequestIdentifier other = (RequestIdentifier)obj;
        if (this.globalQueue != other.globalQueue) {
            return false;
        }
        if (!this.globalQueue && !this.clientName.equals(other.clientName)) {
            return false;
        }
        if (this.globalQueue != other.globalQueue) {
            return false;
        }
        if (!this.identifier.equals(other.identifier)) {
            return false;
        }
        return this.type == other.type;
    }

    static enum RequestType {
        GET,
        PUT,
        PUTDIR;

    }
}

