/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.algebra;

import java.io.Serializable;
import java.math.BigInteger;
import org.spaceroots.mantissa.algebra.Polynomial;
import org.spaceroots.mantissa.algebra.RationalNumber;

public class PolynomialFraction
implements Serializable {
    private Polynomial.Rational p;
    private Polynomial.Rational q;
    private static final long serialVersionUID = 6033909492898954748L;

    public PolynomialFraction() {
        this(new Polynomial.Rational(0L), new Polynomial.Rational(1L));
    }

    public PolynomialFraction(long numerator, long denominator) {
        this(new Polynomial.Rational(numerator), new Polynomial.Rational(denominator));
    }

    public PolynomialFraction(BigInteger numerator, BigInteger denominator) {
        this(new Polynomial.Rational(new RationalNumber(numerator)), new Polynomial.Rational(new RationalNumber(denominator)));
    }

    public PolynomialFraction(RationalNumber numerator, RationalNumber denominator) {
        this(new Polynomial.Rational(numerator), new Polynomial.Rational(denominator));
    }

    public PolynomialFraction(Polynomial.Rational numerator, Polynomial.Rational denominator) {
        if (denominator.isZero()) {
            throw new ArithmeticException("null denominator");
        }
        this.p = numerator;
        this.q = denominator;
        RationalNumber[] a = this.q.getCoefficients();
        if (a[a.length - 1].isNegative()) {
            this.p = (Polynomial.Rational)this.p.negate();
            this.q = (Polynomial.Rational)this.q.negate();
        }
        this.simplify();
    }

    public PolynomialFraction(long l) {
        this(l, 1L);
    }

    public PolynomialFraction(BigInteger i) {
        this(i, BigInteger.ONE);
    }

    public PolynomialFraction(RationalNumber r) {
        this(r.getNumerator(), r.getDenominator());
    }

    public PolynomialFraction(Polynomial.Rational p) {
        this(p, new Polynomial.Rational(1L));
    }

    public PolynomialFraction negate() {
        return new PolynomialFraction((Polynomial.Rational)this.p.negate(), this.q);
    }

    public PolynomialFraction add(PolynomialFraction f) {
        return new PolynomialFraction(this.p.multiply(f.q).add(f.p.multiply(this.q)), this.q.multiply(f.q));
    }

    public PolynomialFraction subtract(PolynomialFraction f) {
        return new PolynomialFraction(this.p.multiply(f.q).subtract(f.p.multiply(this.q)), this.q.multiply(f.q));
    }

    public PolynomialFraction multiply(PolynomialFraction f) {
        PolynomialFraction product = new PolynomialFraction(this.p.multiply(f.p), this.q.multiply(f.q));
        product.simplify();
        return product;
    }

    public PolynomialFraction divide(PolynomialFraction f) {
        if (f.p.isZero()) {
            throw new ArithmeticException("divide by zero");
        }
        Polynomial.Rational newP = this.p.multiply(f.q);
        Polynomial.Rational newQ = this.q.multiply(f.p);
        RationalNumber[] a = newQ.getCoefficients();
        if (a[a.length - 1].isNegative()) {
            newP = (Polynomial.Rational)newP.negate();
            newQ = (Polynomial.Rational)newQ.negate();
        }
        PolynomialFraction result = new PolynomialFraction(newP, newQ);
        result.simplify();
        return result;
    }

    public PolynomialFraction invert() {
        if (this.p.isZero()) {
            throw new ArithmeticException("divide by zero");
        }
        RationalNumber[] a = this.p.getCoefficients();
        PolynomialFraction inverse = a[a.length - 1].isNegative() ? new PolynomialFraction((Polynomial.Rational)this.q.negate(), (Polynomial.Rational)this.p.negate()) : new PolynomialFraction(this.q, this.p);
        inverse.simplify();
        return inverse;
    }

    private void simplify() {
        Polynomial.Rational a = this.p;
        Polynomial.Rational b = this.q;
        if (a.getDegree() < b.getDegree()) {
            Polynomial.Rational tmp = a;
            a = b;
            b = tmp;
        }
        Polynomial.DivisionResult res = Polynomial.Rational.euclidianDivision(a, b);
        while (res.remainder.getDegree() != 0) {
            a = b;
            b = res.remainder;
            res = Polynomial.Rational.euclidianDivision(a, b);
        }
        if (res.remainder.isZero()) {
            this.p = Polynomial.Rational.euclidianDivision((Polynomial.Rational)this.p, (Polynomial.Rational)b).quotient;
            this.q = Polynomial.Rational.euclidianDivision((Polynomial.Rational)this.q, (Polynomial.Rational)b).quotient;
        }
        if (this.q.getDegree() == 0) {
            if (!this.q.isOne()) {
                this.p = (Polynomial.Rational)this.p.divide(this.q.getCoefficients()[0]);
                this.q = new Polynomial.Rational(1L);
            }
        } else {
            BigInteger lcm = this.p.getDenominatorsLCM();
            if (lcm.compareTo(BigInteger.ONE) != 0) {
                this.p = (Polynomial.Rational)this.p.multiply(lcm);
                this.q = (Polynomial.Rational)this.q.multiply(lcm);
            }
            if ((lcm = this.q.getDenominatorsLCM()).compareTo(BigInteger.ONE) != 0) {
                this.p = (Polynomial.Rational)this.p.multiply(lcm);
                this.q = (Polynomial.Rational)this.q.multiply(lcm);
            }
        }
        if (this.q.getCoefficients()[this.q.getDegree()].isNegative()) {
            this.p = (Polynomial.Rational)this.p.negate();
            this.q = (Polynomial.Rational)this.q.negate();
        }
    }

    public Polynomial.Rational getNumerator() {
        return this.p;
    }

    public Polynomial.Rational getDenominator() {
        return this.q;
    }

    public String toString() {
        if (this.p.isZero()) {
            return "0";
        }
        if (this.q.isOne()) {
            return this.p.toString();
        }
        StringBuffer s = new StringBuffer();
        String pString = this.p.toString();
        if (pString.indexOf(32) > 0) {
            s.append('(');
            s.append(pString);
            s.append(')');
        } else {
            s.append(pString);
        }
        s.append('/');
        String qString = this.q.toString();
        if (qString.indexOf(32) > 0) {
            s.append('(');
            s.append(qString);
            s.append(')');
        } else {
            s.append(qString);
        }
        return s.toString();
    }
}

