/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import net.contrapunctus.lzma.ConcurrentBufferInputStream;
import net.contrapunctus.lzma.DecoderThread;

public class LzmaInputStream
extends FilterInputStream {
    protected DecoderThread dth;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    public LzmaInputStream(InputStream inputStream) {
        super(null);
        this.dth = new DecoderThread(inputStream);
        this.in = ConcurrentBufferInputStream.create(this.dth.q);
        if (DEBUG) {
            dbg.printf("%s << %s (%s)%n", this, this.in, this.dth.q);
        }
        this.dth.start();
    }

    @Override
    public void close() throws IOException {
        if (DEBUG) {
            dbg.printf("%s closed%n", this);
        }
        super.close();
    }

    public String toString() {
        return String.format("lzmaIn@%x", this.hashCode());
    }

    public static void main(String[] stringArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print("I will try decoding this text.");
        printStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayOutputStream = new ByteArrayOutputStream();
        Encoder encoder = new Encoder();
        encoder.SetEndMarkerMode(true);
        encoder.WriteCoderProperties(byteArrayOutputStream);
        encoder.Code(byteArrayInputStream, byteArrayOutputStream, -1L, -1L, null);
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        Decoder decoder = new Decoder();
        byte[] byArray2 = new byte[5];
        byteArrayInputStream.read(byArray2, 0, 5);
        decoder.SetDecoderProperties(byArray2);
        decoder.Code(byteArrayInputStream, System.out, -1L);
        System.out.println();
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        LzmaInputStream lzmaInputStream = new LzmaInputStream(byteArrayInputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(lzmaInputStream));
        System.out.println(bufferedReader.readLine());
    }

    static {
        String string = null;
        try {
            string = System.getProperty("DEBUG_LzmaStreams");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = string != null;
    }
}

