/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import org.easymock.internal.RuntimeExceptionWrapper;

public class Range
implements Serializable {
    private static final long serialVersionUID = -6743402320315331536L;
    private final int minimum;
    private final int maximum;

    public Range(int n) {
        this(n, n);
    }

    public Range(int n, int n2) {
        if (n > n2) {
            throw new RuntimeExceptionWrapper(new IllegalArgumentException("minimum must be <= maximum"));
        }
        if (n < 0) {
            throw new RuntimeExceptionWrapper(new IllegalArgumentException("minimum must be >= 0"));
        }
        if (n2 < 1) {
            throw new RuntimeExceptionWrapper(new IllegalArgumentException("maximum must be >= 1"));
        }
        this.minimum = n;
        this.maximum = n2;
    }

    public boolean hasFixedCount() {
        return this.minimum == this.maximum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public String toString() {
        if (this.hasFixedCount()) {
            return "" + this.minimum;
        }
        if (this.hasOpenCount()) {
            return "at least " + this.minimum;
        }
        return "between " + this.minimum + " and " + this.maximum;
    }

    public String expectedCount() {
        return "expected: " + this.toString();
    }

    public boolean contains(int n) {
        return this.minimum <= n && n <= this.maximum;
    }

    public boolean hasOpenCount() {
        return this.maximum == Integer.MAX_VALUE;
    }
}

