/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.easymock.internal.AssertionErrorWrapper;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.MocksControl;
import org.easymock.internal.RecordState;
import org.easymock.internal.RuntimeExceptionWrapper;
import org.easymock.internal.ThrowableWrapper;

public final class MockInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -7799769066534714634L;
    private final MocksControl control;

    public MockInvocationHandler(MocksControl mocksControl) {
        this.control = mocksControl;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            if (this.control.getState() instanceof RecordState) {
                LastControl.reportLastControl(this.control);
            }
            return this.control.getState().invoke(new Invocation(object, method, objectArray));
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
        catch (AssertionErrorWrapper assertionErrorWrapper) {
            throw ((Throwable)((Object)assertionErrorWrapper.getAssertionError())).fillInStackTrace();
        }
        catch (ThrowableWrapper throwableWrapper) {
            throw throwableWrapper.getThrowable().fillInStackTrace();
        }
    }

    public MocksControl getControl() {
        return this.control;
    }
}

