/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MethodSerializationWrapper
implements Serializable {
    private static final long serialVersionUID = 1775475200823842126L;
    private static final Map<String, Class<?>> primitiveTypes = new HashMap(10);
    private final String className;
    private final String methodName;
    private final String[] parameterTypeNames;

    public MethodSerializationWrapper(Method method) {
        this.className = method.getDeclaringClass().getName();
        this.methodName = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        this.parameterTypeNames = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            this.parameterTypeNames[i] = classArray[i].getName();
        }
    }

    public Method getMethod() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
        Class[] classArray = new Class[this.parameterTypeNames.length];
        for (int i = 0; i < this.parameterTypeNames.length; ++i) {
            Class<?> clazz2 = primitiveTypes.get(this.parameterTypeNames[i]);
            classArray[i] = clazz2 != null ? clazz2 : Class.forName(this.parameterTypeNames[i], true, Thread.currentThread().getContextClassLoader());
        }
        Method method = clazz.getDeclaredMethod(this.methodName, classArray);
        return method;
    }

    static {
        primitiveTypes.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveTypes.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveTypes.put(Short.TYPE.getName(), Short.TYPE);
        primitiveTypes.put(Character.TYPE.getName(), Character.TYPE);
        primitiveTypes.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveTypes.put(Long.TYPE.getName(), Long.TYPE);
        primitiveTypes.put(Float.TYPE.getName(), Float.TYPE);
        primitiveTypes.put(Double.TYPE.getName(), Double.TYPE);
    }
}

