/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import blue.settings.ProjectDefaultsOptionsPanelController;
import blue.settings.ProjectDefaultsSettings;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class ProjectDefaultsPanel
extends JPanel {
    private final ProjectDefaultsOptionsPanelController controller;
    private boolean loading = false;
    private JTextField defaultAuthorText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JComboBox<String> layerHeightDefaultComboBox;
    private JCheckBox mixerEnabledCheckBox;

    ProjectDefaultsPanel(ProjectDefaultsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        SimpleDocumentListener changeListener = new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!ProjectDefaultsPanel.this.loading) {
                    ProjectDefaultsPanel.this.controller.changed();
                }
            }
        };
        this.defaultAuthorText.getDocument().addDocumentListener((DocumentListener)changeListener);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.defaultAuthorText = new JTextField();
        this.mixerEnabledCheckBox = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.layerHeightDefaultComboBox = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProjectDefaultsPanel.class, (String)"ProjectDefaultsPanel.jLabel1.text_1"));
        this.jLabel2.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ProjectDefaultsPanel.class, (String)"ProjectDefaultsPanel.jLabel2.text_1"));
        this.defaultAuthorText.setText(NbBundle.getMessage(ProjectDefaultsPanel.class, (String)"ProjectDefaultsPanel.defaultAuthorText.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.mixerEnabledCheckBox, (String)NbBundle.getMessage(ProjectDefaultsPanel.class, (String)"ProjectDefaultsPanel.mixerEnabledCheckBox.text_1"));
        this.mixerEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectDefaultsPanel.this.mixerEnabledCheckBoxActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ProjectDefaultsPanel.class, (String)"ProjectDefaultsPanel.jLabel3.text"));
        this.layerHeightDefaultComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"}));
        this.layerHeightDefaultComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectDefaultsPanel.this.layerHeightDefaultComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -1, 108, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mixerEnabledCheckBox, -1, 139, Short.MAX_VALUE).addComponent(this.defaultAuthorText).addComponent(this.layerHeightDefaultComboBox, 0, 139, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.defaultAuthorText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.mixerEnabledCheckBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.layerHeightDefaultComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void mixerEnabledCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private void layerHeightDefaultComboBoxActionPerformed(ActionEvent evt) {
    }

    void load() {
        this.loading = true;
        ProjectDefaultsSettings settings = ProjectDefaultsSettings.getInstance();
        this.defaultAuthorText.setText(settings.defaultAuthor);
        this.mixerEnabledCheckBox.setSelected(settings.mixerEnabled);
        this.layerHeightDefaultComboBox.setSelectedIndex(settings.layerHeightDefault);
        this.loading = false;
    }

    void store() {
        ProjectDefaultsSettings settings = ProjectDefaultsSettings.getInstance();
        settings.defaultAuthor = this.defaultAuthorText.getText();
        settings.mixerEnabled = this.mixerEnabledCheckBox.isSelected();
        settings.layerHeightDefault = this.layerHeightDefaultComboBox.getSelectedIndex();
        settings.save();
    }

    boolean valid() {
        return true;
    }
}

