/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.utilities.audio;

import blue.ui.utilities.audio.AudioWaveformCacheGenerator;
import blue.ui.utilities.audio.AudioWaveformData;
import blue.ui.utilities.audio.AudioWaveformListener;
import blue.ui.utilities.audio.WaveformCacheKey;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AudioWaveformCache {
    public static final AudioWaveformData EMPTY_AUDIO_FILENAME = new AudioWaveformData();
    public static final AudioWaveformData NOT_YET_CACHED = new AudioWaveformData();
    private final Map<WaveformCacheKey, SoftReference<AudioWaveformData>> waveCache = new HashMap<WaveformCacheKey, SoftReference<AudioWaveformData>>();
    private List<AudioWaveformListener> listeners = null;
    private AudioWaveformCacheGenerator generator = null;
    private static AudioWaveformCache INSTANCE = null;

    public static synchronized AudioWaveformCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AudioWaveformCache();
        }
        return INSTANCE;
    }

    private AudioWaveformCache() {
    }

    public synchronized AudioWaveformData getAudioWaveformData(String audioFilename, int pixelSeconds) {
        if (audioFilename == null || audioFilename.length() == 0) {
            return EMPTY_AUDIO_FILENAME;
        }
        WaveformCacheKey key = new WaveformCacheKey(audioFilename, pixelSeconds);
        SoftReference<AudioWaveformData> waveDataRef = this.waveCache.get(key);
        if (waveDataRef != null && waveDataRef.get() != null) {
            return waveDataRef.get();
        }
        AudioWaveformData waveData = new AudioWaveformData();
        waveData.fileName = audioFilename;
        waveData.pixelSeconds = pixelSeconds;
        waveData.data = null;
        waveData.percentLoadingComplete = 0.0;
        File f = new File(audioFilename);
        if (!f.exists() && !f.isFile()) {
            this.waveCache.put(new WaveformCacheKey(audioFilename, pixelSeconds), new SoftReference<AudioWaveformData>(waveData));
            return waveData;
        }
        if (this.generator == null || !this.generator.isRunning()) {
            this.generator = new AudioWaveformCacheGenerator(this);
            this.generator.addAudioWaveformData(waveData);
            this.generator.start();
        } else if (this.generator.getPixelSeconds() != waveData.pixelSeconds) {
            this.generator.killRunning();
            this.clearCache();
            this.generator = new AudioWaveformCacheGenerator(this);
            this.generator.addAudioWaveformData(waveData);
            this.generator.start();
        } else {
            this.generator.addAudioWaveformData(waveData);
        }
        this.waveCache.put(new WaveformCacheKey(audioFilename, pixelSeconds), new SoftReference<AudioWaveformData>(waveData));
        return waveData;
    }

    public synchronized void clearCache() {
        this.waveCache.clear();
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public synchronized void addAudioWaveformListener(AudioWaveformListener audioWaveformListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        this.listeners.add(audioWaveformListener);
    }

    public synchronized void fireAudioWaveformDataGenerated(String filename) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        if (filename == "CACHE_GEN_COMPLETE") {
            for (AudioWaveformListener listener : this.listeners) {
                listener.waveDataGenerated();
            }
            this.listeners.clear();
            return;
        }
        for (AudioWaveformListener listener : this.listeners) {
            if (!listener.getFilename().equals(filename)) continue;
            listener.waveDataGenerated();
        }
    }
}

