/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import blue.soundObject.CeciliaModule;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import pnuts.awt.PnutsLayout;

public class PropertiesPanel
extends JComponent {
    private CeciliaModule ceciliaModule;
    JRadioButton mono = new JRadioButton("Mono");
    JRadioButton stereo = new JRadioButton("Stereo");
    JRadioButton quad = new JRadioButton("Quad");
    JRadioButton[] orchOptions = new JRadioButton[]{this.mono, this.stereo, this.quad};
    Object[] genSizes = new Object[]{"128", "256", "512", "1024", "2048", "4096", "8192", "16384", "32768", "65536"};
    JComboBox genSizeOptions = new JComboBox<Object>(this.genSizes);
    boolean initiatingObject = false;

    public PropertiesPanel() {
        ButtonGroup group = new ButtonGroup();
        ActionListener orchListener = e -> {
            if (this.initiatingObject) {
                return;
            }
            for (int i = 0; i < this.orchOptions.length; ++i) {
                if (!this.orchOptions[i].isSelected()) continue;
                this.ceciliaModule.setOrchestraVersion(i);
            }
        };
        this.mono.addActionListener(orchListener);
        this.stereo.addActionListener(orchListener);
        this.quad.addActionListener(orchListener);
        this.genSizeOptions.addActionListener(e -> {
            if (this.initiatingObject) {
                return;
            }
            this.ceciliaModule.setGenSize(this.genSizeOptions.getSelectedItem().toString());
        });
        group.add(this.mono);
        group.add(this.stereo);
        group.add(this.quad);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(this.mono);
        buttonPanel.add(this.stereo);
        buttonPanel.add(this.quad);
        buttonPanel.add(this.genSizeOptions);
        this.stereo.setSelected(true);
        this.setLayout(new PnutsLayout("cols=3"));
        this.add((Component)buttonPanel, "valign=top");
    }

    public void editCeciliaModule(CeciliaModule ceciliaModule) {
        this.initiatingObject = true;
        this.ceciliaModule = ceciliaModule;
        this.orchOptions[ceciliaModule.getOrchestraVersion()].setSelected(true);
        this.genSizeOptions.setSelectedItem(ceciliaModule.getGenSize());
        this.initiatingObject = false;
    }
}

